/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.acra.ACRA;
import org.acra.collector.Compatibility;

final class DisplayManagerCollector {
    static final SparseArray<String> mDensities;
    static final SparseArray<String> mFlagsNames;

    static {
        mFlagsNames = new SparseArray();
        mDensities = new SparseArray();
    }

    DisplayManagerCollector() {
    }

    private static String activeFlags(SparseArray<String> sparseArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < sparseArray.size(); ++i2) {
            int n3 = n2 & sparseArray.keyAt(i2);
            if (n3 <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('+');
            }
            stringBuilder.append((String)sparseArray.get(n3));
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String collectCurrentSizeRange(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod("getCurrentSizeRange", Point.class, Point.class);
            Point point = new Point();
            Point point2 = new Point();
            method.invoke((Object)display, point, point2);
            stringBuilder.append(display.getDisplayId()).append(".currentSizeRange.smallest=[").append(point.x).append(',').append(point.y).append(']').append('\n');
            stringBuilder.append(display.getDisplayId()).append(".currentSizeRange.largest=[").append(point2.x).append(',').append(point2.y).append(']').append('\n');
        }
        catch (InvocationTargetException invocationTargetException) {
            return stringBuilder.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            return stringBuilder.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return stringBuilder.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return stringBuilder.toString();
        }
        catch (SecurityException securityException) {
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    private static Object collectDisplayData(Display display) {
        display.getMetrics(new DisplayMetrics());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DisplayManagerCollector.collectCurrentSizeRange(display));
        stringBuilder.append(DisplayManagerCollector.collectFlags(display));
        stringBuilder.append(display.getDisplayId()).append(".height=").append(display.getHeight()).append('\n');
        stringBuilder.append(DisplayManagerCollector.collectMetrics(display, "getMetrics"));
        stringBuilder.append(DisplayManagerCollector.collectName(display));
        stringBuilder.append(display.getDisplayId()).append(".orientation=").append(display.getOrientation()).append('\n');
        stringBuilder.append(display.getDisplayId()).append(".pixelFormat=").append(display.getPixelFormat()).append('\n');
        stringBuilder.append(DisplayManagerCollector.collectMetrics(display, "getRealMetrics"));
        stringBuilder.append(DisplayManagerCollector.collectSize(display, "getRealSize"));
        stringBuilder.append(DisplayManagerCollector.collectRectSize(display));
        stringBuilder.append(display.getDisplayId()).append(".refreshRate=").append(display.getRefreshRate()).append('\n');
        stringBuilder.append(DisplayManagerCollector.collectRotation(display));
        stringBuilder.append(DisplayManagerCollector.collectSize(display, "getSize"));
        stringBuilder.append(display.getDisplayId()).append(".width=").append(display.getWidth()).append('\n');
        stringBuilder.append(DisplayManagerCollector.collectIsValid(display));
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String collectDisplays(Context context) {
        Display[] displayArray;
        StringBuilder stringBuilder = new StringBuilder();
        if (Compatibility.getAPILevel() < 17) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            displayArray = new Display[]{windowManager.getDefaultDisplay()};
        } else {
            try {
                Object object = context.getSystemService((String)context.getClass().getField("DISPLAY_SERVICE").get(null));
                displayArray = (Display[])object.getClass().getMethod("getDisplays", new Class[0]).invoke(object, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", illegalArgumentException);
                displayArray = null;
            }
            catch (SecurityException securityException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", securityException);
                displayArray = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", illegalAccessException);
                displayArray = null;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", noSuchFieldException);
                displayArray = null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", noSuchMethodException);
                displayArray = null;
            }
            catch (InvocationTargetException invocationTargetException) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", invocationTargetException);
                displayArray = null;
            }
        }
        Display[] displayArray2 = displayArray;
        int n2 = displayArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            stringBuilder.append(DisplayManagerCollector.collectDisplayData(displayArray2[n3]));
            ++n3;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String collectFlags(Display display) {
        int n2;
        int n3;
        Field[] fieldArray;
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            n4 = (Integer)display.getClass().getMethod("getFlags", new Class[0]).invoke((Object)display, new Object[0]);
            fieldArray = display.getClass().getFields();
            n3 = fieldArray.length;
            n2 = 0;
        }
        catch (InvocationTargetException invocationTargetException) {
            return stringBuilder.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            return stringBuilder.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return stringBuilder.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return stringBuilder.toString();
        }
        catch (SecurityException securityException) {
            return stringBuilder.toString();
        }
        while (true) {
            if (n2 < n3) {
                Field field = fieldArray[n2];
                if (field.getName().startsWith("FLAG_")) {
                    mFlagsNames.put(field.getInt(null), (Object)field.getName());
                }
            } else {
                stringBuilder.append(display.getDisplayId()).append(".flags=").append(DisplayManagerCollector.activeFlags(mFlagsNames, n4)).append('\n');
                return stringBuilder.toString();
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object collectIsValid(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Boolean bl2 = (Boolean)display.getClass().getMethod("isValid", new Class[0]).invoke((Object)display, new Object[0]);
            stringBuilder.append(display.getDisplayId()).append(".isValid=").append(bl2).append('\n');
        }
        catch (InvocationTargetException invocationTargetException) {
            return stringBuilder.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            return stringBuilder.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return stringBuilder.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return stringBuilder.toString();
        }
        catch (SecurityException securityException) {
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object collectMetrics(Display display, String string2) {
        int n2;
        int n3;
        Field[] fieldArray;
        DisplayMetrics displayMetrics;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            displayMetrics = (DisplayMetrics)display.getClass().getMethod(string2, new Class[0]).invoke((Object)display, new Object[0]);
            fieldArray = DisplayMetrics.class.getFields();
            n3 = fieldArray.length;
            n2 = 0;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return stringBuilder.toString();
        }
        catch (InvocationTargetException invocationTargetException) {
            return stringBuilder.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            return stringBuilder.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return stringBuilder.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return stringBuilder.toString();
        }
        catch (SecurityException securityException) {
            return stringBuilder.toString();
        }
        while (true) {
            if (n2 < n3) {
                Field field = fieldArray[n2];
                if (field.getType().equals(Integer.class) && field.getName().startsWith("DENSITY_") && !field.getName().equals("DENSITY_DEFAULT")) {
                    mDensities.put(field.getInt(null), (Object)field.getName());
                }
            } else {
                stringBuilder.append(display.getDisplayId()).append('.').append(string2).append(".density=").append(displayMetrics.density).append('\n');
                stringBuilder.append(display.getDisplayId()).append('.').append(string2).append(".densityDpi=").append(displayMetrics.getClass().getField("densityDpi")).append('\n');
                stringBuilder.append(display.getDisplayId()).append('.').append(string2).append("scaledDensity=x").append(displayMetrics.scaledDensity).append('\n');
                stringBuilder.append(display.getDisplayId()).append('.').append(string2).append(".widthPixels=").append(displayMetrics.widthPixels).append('\n');
                stringBuilder.append(display.getDisplayId()).append('.').append(string2).append(".heightPixels=").append(displayMetrics.heightPixels).append('\n');
                stringBuilder.append(display.getDisplayId()).append('.').append(string2).append(".xdpi=").append(displayMetrics.xdpi).append('\n');
                stringBuilder.append(display.getDisplayId()).append('.').append(string2).append(".ydpi=").append(displayMetrics.ydpi).append('\n');
                return stringBuilder.toString();
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String collectName(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string2 = (String)display.getClass().getMethod("getName", new Class[0]).invoke((Object)display, new Object[0]);
            stringBuilder.append(display.getDisplayId()).append(".name=").append(string2).append('\n');
        }
        catch (InvocationTargetException invocationTargetException) {
            return stringBuilder.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            return stringBuilder.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return stringBuilder.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return stringBuilder.toString();
        }
        catch (SecurityException securityException) {
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object collectRectSize(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod("getRectSize", Rect.class);
            Rect rect = new Rect();
            method.invoke((Object)display, rect);
            stringBuilder.append(display.getDisplayId()).append(".rectSize=[").append(rect.top).append(',').append(rect.left).append(',').append(rect.width()).append(',').append(rect.height()).append(']').append('\n');
        }
        catch (InvocationTargetException invocationTargetException) {
            return stringBuilder.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            return stringBuilder.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return stringBuilder.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return stringBuilder.toString();
        }
        catch (SecurityException securityException) {
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    /*
     * Exception decompiling
     */
    private static Object collectRotation(Display var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object collectSize(Display display, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Method method = display.getClass().getMethod(string2, Point.class);
            Point point = new Point();
            method.invoke((Object)display, point);
            stringBuilder.append(display.getDisplayId()).append('.').append(string2).append("=[").append(point.x).append(',').append(point.y).append(']').append('\n');
        }
        catch (InvocationTargetException invocationTargetException) {
            return stringBuilder.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            return stringBuilder.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return stringBuilder.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return stringBuilder.toString();
        }
        catch (SecurityException securityException) {
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }
}

