/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import org.acra.ACRA;
import org.acra.collector.Compatibility;

final class DeviceFeaturesCollector {
    DeviceFeaturesCollector() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFeatures(Context context) {
        if (Compatibility.getAPILevel() < 5) {
            return "Data available only with API Level >= 5";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            PackageManager packageManager = context.getPackageManager();
            for (Object object : (Object[])PackageManager.class.getMethod("getSystemAvailableFeatures", null).invoke((Object)packageManager, new Object[0])) {
                String string2 = (String)object.getClass().getField("name").get(object);
                if (string2 != null) {
                    stringBuilder.append(string2);
                } else {
                    String string3 = (String)object.getClass().getMethod("getGlEsVersion", null).invoke(object, new Object[0]);
                    stringBuilder.append("glEsVersion = ");
                    stringBuilder.append(string3);
                }
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve DeviceFeatures for " + context.getPackageName()), (Throwable)throwable);
            stringBuilder.append("Could not retrieve data: ");
            stringBuilder.append(throwable.getMessage());
        }
        return stringBuilder.toString();
    }
}

