/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Environment;
import android.text.format.Time;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.acra.ACRA;
import org.acra.ACRAConfiguration;
import org.acra.ACRAConstants;
import org.acra.ReportField;
import org.acra.collector.Compatibility;
import org.acra.collector.ConfigurationCollector;
import org.acra.collector.CrashReportData;
import org.acra.collector.DeviceFeaturesCollector;
import org.acra.collector.DisplayManagerCollector;
import org.acra.collector.DropBoxCollector;
import org.acra.collector.DumpSysCollector;
import org.acra.collector.LogCatCollector;
import org.acra.collector.LogFileCollector;
import org.acra.collector.MediaCodecListCollector;
import org.acra.collector.ReflectionCollector;
import org.acra.collector.SettingsCollector;
import org.acra.collector.SharedPreferencesCollector;
import org.acra.collector.ThreadCollector;
import org.acra.util.Installation;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.ReportUtils;

public final class CrashReportDataFactory {
    private final Time appStartDate;
    private final Context context;
    private final Map<String, String> customParameters = new HashMap<String, String>();
    private final String initialConfiguration;
    private final SharedPreferences prefs;

    public CrashReportDataFactory(Context context, SharedPreferences sharedPreferences, Time time, String string2) {
        this.context = context;
        this.prefs = sharedPreferences;
        this.appStartDate = time;
        this.initialConfiguration = string2;
    }

    private String createCustomInfoString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : this.customParameters.keySet()) {
            String string3 = this.customParameters.get(string2);
            stringBuilder.append(string2);
            stringBuilder.append(" = ");
            if (string3 != null) {
                string3 = string3.replaceAll("\n", "\\\\n");
            }
            stringBuilder.append(string3);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ReportField> getReportFields() {
        ReportField[] reportFieldArray;
        ACRAConfiguration aCRAConfiguration = ACRA.getConfig();
        ReportField[] reportFieldArray2 = aCRAConfiguration.customReportContent();
        if (reportFieldArray2.length != 0) {
            Log.d((String)ACRA.LOG_TAG, (String)"Using custom Report Fields");
            reportFieldArray = reportFieldArray2;
            return Arrays.asList(reportFieldArray);
        }
        if (aCRAConfiguration.mailTo() == null || "".equals(aCRAConfiguration.mailTo())) {
            Log.d((String)ACRA.LOG_TAG, (String)"Using default Report Fields");
            reportFieldArray = ACRAConstants.DEFAULT_REPORT_FIELDS;
            return Arrays.asList(reportFieldArray);
        }
        Log.d((String)ACRA.LOG_TAG, (String)"Using default Mail Report Fields");
        reportFieldArray = ACRAConstants.DEFAULT_MAIL_REPORT_FIELDS;
        return Arrays.asList(reportFieldArray);
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            throwable2.printStackTrace(printWriter);
        }
        String string2 = ((Object)stringWriter).toString();
        printWriter.close();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CrashReportData createCrashData(Throwable throwable, boolean bl2, Thread thread) {
        CrashReportData crashReportData = new CrashReportData();
        try {
            String string2;
            PackageManagerWrapper packageManagerWrapper;
            PackageInfo packageInfo;
            List<ReportField> list = this.getReportFields();
            crashReportData.put(ReportField.STACK_TRACE, this.getStackTrace(throwable));
            crashReportData.put(ReportField.USER_APP_START_DATE, this.appStartDate.format3339(false));
            if (bl2) {
                crashReportData.put(ReportField.IS_SILENT, "true");
            }
            if (list.contains((Object)ReportField.REPORT_ID)) {
                crashReportData.put(ReportField.REPORT_ID, UUID.randomUUID().toString());
            }
            if (list.contains((Object)ReportField.INSTALLATION_ID)) {
                crashReportData.put(ReportField.INSTALLATION_ID, Installation.id(this.context));
            }
            if (list.contains((Object)ReportField.INITIAL_CONFIGURATION)) {
                crashReportData.put(ReportField.INITIAL_CONFIGURATION, this.initialConfiguration);
            }
            if (list.contains((Object)ReportField.CRASH_CONFIGURATION)) {
                crashReportData.put(ReportField.CRASH_CONFIGURATION, ConfigurationCollector.collectConfiguration(this.context));
            }
            if (!(throwable instanceof OutOfMemoryError) && list.contains((Object)ReportField.DUMPSYS_MEMINFO)) {
                crashReportData.put(ReportField.DUMPSYS_MEMINFO, DumpSysCollector.collectMemInfo());
            }
            if (list.contains((Object)ReportField.PACKAGE_NAME)) {
                crashReportData.put(ReportField.PACKAGE_NAME, this.context.getPackageName());
            }
            if (list.contains((Object)ReportField.BUILD)) {
                crashReportData.put(ReportField.BUILD, ReflectionCollector.collectConstants(Build.class) + ReflectionCollector.collectConstants(Build.VERSION.class, "VERSION"));
            }
            if (list.contains((Object)ReportField.PHONE_MODEL)) {
                crashReportData.put(ReportField.PHONE_MODEL, Build.MODEL);
            }
            if (list.contains((Object)ReportField.ANDROID_VERSION)) {
                crashReportData.put(ReportField.ANDROID_VERSION, Build.VERSION.RELEASE);
            }
            if (list.contains((Object)ReportField.BRAND)) {
                crashReportData.put(ReportField.BRAND, Build.BRAND);
            }
            if (list.contains((Object)ReportField.PRODUCT)) {
                crashReportData.put(ReportField.PRODUCT, Build.PRODUCT);
            }
            if (list.contains((Object)ReportField.TOTAL_MEM_SIZE)) {
                crashReportData.put(ReportField.TOTAL_MEM_SIZE, Long.toString(ReportUtils.getTotalInternalMemorySize()));
            }
            if (list.contains((Object)ReportField.AVAILABLE_MEM_SIZE)) {
                crashReportData.put(ReportField.AVAILABLE_MEM_SIZE, Long.toString(ReportUtils.getAvailableInternalMemorySize()));
            }
            if (list.contains((Object)ReportField.FILE_PATH)) {
                crashReportData.put(ReportField.FILE_PATH, ReportUtils.getApplicationFilePath(this.context));
            }
            if (list.contains((Object)ReportField.DISPLAY)) {
                crashReportData.put(ReportField.DISPLAY, DisplayManagerCollector.collectDisplays(this.context));
            }
            if (list.contains((Object)ReportField.USER_CRASH_DATE)) {
                Time time = new Time();
                time.setToNow();
                crashReportData.put(ReportField.USER_CRASH_DATE, time.format3339(false));
            }
            if (list.contains((Object)ReportField.CUSTOM_DATA)) {
                crashReportData.put(ReportField.CUSTOM_DATA, this.createCustomInfoString());
            }
            if (list.contains((Object)ReportField.USER_EMAIL)) {
                crashReportData.put(ReportField.USER_EMAIL, this.prefs.getString("acra.user.email", "N/A"));
            }
            if (list.contains((Object)ReportField.DEVICE_FEATURES)) {
                crashReportData.put(ReportField.DEVICE_FEATURES, DeviceFeaturesCollector.getFeatures(this.context));
            }
            if (list.contains((Object)ReportField.ENVIRONMENT)) {
                crashReportData.put(ReportField.ENVIRONMENT, ReflectionCollector.collectStaticGettersResults(Environment.class));
            }
            if (list.contains((Object)ReportField.SETTINGS_SYSTEM)) {
                crashReportData.put(ReportField.SETTINGS_SYSTEM, SettingsCollector.collectSystemSettings(this.context));
            }
            if (list.contains((Object)ReportField.SETTINGS_SECURE)) {
                crashReportData.put(ReportField.SETTINGS_SECURE, SettingsCollector.collectSecureSettings(this.context));
            }
            if (list.contains((Object)ReportField.SETTINGS_GLOBAL)) {
                crashReportData.put(ReportField.SETTINGS_GLOBAL, SettingsCollector.collectGlobalSettings(this.context));
            }
            if (list.contains((Object)ReportField.SHARED_PREFERENCES)) {
                crashReportData.put(ReportField.SHARED_PREFERENCES, SharedPreferencesCollector.collect(this.context));
            }
            if ((packageInfo = (packageManagerWrapper = new PackageManagerWrapper(this.context)).getPackageInfo()) != null) {
                if (list.contains((Object)ReportField.APP_VERSION_CODE)) {
                    crashReportData.put(ReportField.APP_VERSION_CODE, Integer.toString(packageInfo.versionCode));
                }
                if (list.contains((Object)ReportField.APP_VERSION_NAME)) {
                    ReportField reportField = ReportField.APP_VERSION_NAME;
                    String string3 = packageInfo.versionName != null ? packageInfo.versionName : "not set";
                    crashReportData.put(reportField, string3);
                }
            } else {
                crashReportData.put(ReportField.APP_VERSION_NAME, "Package info unavailable");
            }
            if (list.contains((Object)ReportField.DEVICE_ID) && this.prefs.getBoolean("acra.deviceid.enable", true) && packageManagerWrapper.hasPermission("android.permission.READ_PHONE_STATE") && (string2 = ReportUtils.getDeviceId(this.context)) != null) {
                crashReportData.put(ReportField.DEVICE_ID, string2);
            }
            if (this.prefs.getBoolean("acra.syslog.enable", true) && packageManagerWrapper.hasPermission("android.permission.READ_LOGS") || Compatibility.getAPILevel() >= 16) {
                Log.i((String)ACRA.LOG_TAG, (String)"READ_LOGS granted! ACRA can include LogCat and DropBox data.");
                if (list.contains((Object)ReportField.LOGCAT)) {
                    crashReportData.put(ReportField.LOGCAT, LogCatCollector.collectLogCat(null));
                }
                if (list.contains((Object)ReportField.EVENTSLOG)) {
                    crashReportData.put(ReportField.EVENTSLOG, LogCatCollector.collectLogCat("events"));
                }
                if (list.contains((Object)ReportField.RADIOLOG)) {
                    crashReportData.put(ReportField.RADIOLOG, LogCatCollector.collectLogCat("radio"));
                }
                if (list.contains((Object)ReportField.DROPBOX)) {
                    crashReportData.put(ReportField.DROPBOX, DropBoxCollector.read(this.context, ACRA.getConfig().additionalDropBoxTags()));
                }
            } else {
                Log.i((String)ACRA.LOG_TAG, (String)"READ_LOGS not allowed. ACRA will not include LogCat and DropBox data.");
            }
            if (list.contains((Object)ReportField.APPLICATION_LOG)) {
                crashReportData.put(ReportField.APPLICATION_LOG, LogFileCollector.collectLogFile(this.context, ACRA.getConfig().applicationLogFile(), ACRA.getConfig().applicationLogFileLines()));
            }
            if (list.contains((Object)ReportField.MEDIA_CODEC_LIST)) {
                crashReportData.put(ReportField.MEDIA_CODEC_LIST, MediaCodecListCollector.collecMediaCodecList());
            }
            if (list.contains((Object)ReportField.THREAD_DETAILS)) {
                crashReportData.put(ReportField.THREAD_DETAILS, ThreadCollector.collect(thread));
            }
            if (!list.contains((Object)ReportField.USER_IP)) return crashReportData;
            crashReportData.put(ReportField.USER_IP, ReportUtils.getLocalIpAddress());
            return crashReportData;
        }
        catch (RuntimeException runtimeException) {
            Log.e((String)ACRA.LOG_TAG, (String)"Error while retrieving crash data", (Throwable)runtimeException);
            return crashReportData;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)ACRA.LOG_TAG, (String)("Error : application log file " + ACRA.getConfig().applicationLogFile() + " not found."), (Throwable)fileNotFoundException);
            return crashReportData;
        }
        catch (IOException iOException) {
            Log.e((String)ACRA.LOG_TAG, (String)("Error while reading application log file " + ACRA.getConfig().applicationLogFile() + "."), (Throwable)iOException);
        }
        return crashReportData;
    }

    public String getCustomData(String string2) {
        return this.customParameters.get(string2);
    }

    public String putCustomData(String string2, String string3) {
        return this.customParameters.put(string2, string3);
    }

    public String removeCustomData(String string2) {
        return this.customParameters.remove(string2);
    }
}

