/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.res.Configuration;
import android.util.Log;
import android.util.SparseArray;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.acra.ACRA;

public final class ConfigurationCollector {
    private static final String FIELD_MCC = "mcc";
    private static final String FIELD_MNC = "mnc";
    private static final String FIELD_SCREENLAYOUT = "screenLayout";
    private static final String FIELD_UIMODE = "uiMode";
    private static final String PREFIX_HARDKEYBOARDHIDDEN = "HARDKEYBOARDHIDDEN_";
    private static final String PREFIX_KEYBOARD = "KEYBOARD_";
    private static final String PREFIX_KEYBOARDHIDDEN = "KEYBOARDHIDDEN_";
    private static final String PREFIX_NAVIGATION = "NAVIGATION_";
    private static final String PREFIX_NAVIGATIONHIDDEN = "NAVIGATIONHIDDEN_";
    private static final String PREFIX_ORIENTATION = "ORIENTATION_";
    private static final String PREFIX_SCREENLAYOUT = "SCREENLAYOUT_";
    private static final String PREFIX_TOUCHSCREEN = "TOUCHSCREEN_";
    private static final String PREFIX_UI_MODE = "UI_MODE_";
    private static final String SUFFIX_MASK = "_MASK";
    private static SparseArray<String> mHardKeyboardHiddenValues = new SparseArray();
    private static SparseArray<String> mKeyboardHiddenValues;
    private static SparseArray<String> mKeyboardValues;
    private static SparseArray<String> mNavigationHiddenValues;
    private static SparseArray<String> mNavigationValues;
    private static SparseArray<String> mOrientationValues;
    private static SparseArray<String> mScreenLayoutValues;
    private static SparseArray<String> mTouchScreenValues;
    private static SparseArray<String> mUiModeValues;
    private static final HashMap<String, SparseArray<String>> mValueArrays;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        mKeyboardValues = new SparseArray();
        mKeyboardHiddenValues = new SparseArray();
        mNavigationValues = new SparseArray();
        mNavigationHiddenValues = new SparseArray();
        mOrientationValues = new SparseArray();
        mScreenLayoutValues = new SparseArray();
        mTouchScreenValues = new SparseArray();
        mUiModeValues = new SparseArray();
        mValueArrays = new HashMap();
        mValueArrays.put(PREFIX_HARDKEYBOARDHIDDEN, mHardKeyboardHiddenValues);
        mValueArrays.put(PREFIX_KEYBOARD, mKeyboardValues);
        mValueArrays.put(PREFIX_KEYBOARDHIDDEN, mKeyboardHiddenValues);
        mValueArrays.put(PREFIX_NAVIGATION, mNavigationValues);
        mValueArrays.put(PREFIX_NAVIGATIONHIDDEN, mNavigationHiddenValues);
        mValueArrays.put(PREFIX_ORIENTATION, mOrientationValues);
        mValueArrays.put(PREFIX_SCREENLAYOUT, mScreenLayoutValues);
        mValueArrays.put(PREFIX_TOUCHSCREEN, mTouchScreenValues);
        mValueArrays.put(PREFIX_UI_MODE, mUiModeValues);
        Field[] fieldArray = Configuration.class.getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (true) {
            block12: {
                block14: {
                    String string2;
                    Field field;
                    block17: {
                        block16: {
                            block15: {
                                block13: {
                                    if (n3 >= n2) break block14;
                                    field = fieldArray[n3];
                                    if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) break block12;
                                    string2 = field.getName();
                                    try {
                                        if (string2.startsWith(PREFIX_HARDKEYBOARDHIDDEN)) {
                                            mHardKeyboardHiddenValues.put(field.getInt(null), (Object)string2);
                                            break block12;
                                        }
                                        if (string2.startsWith(PREFIX_KEYBOARD)) {
                                            mKeyboardValues.put(field.getInt(null), (Object)string2);
                                        }
                                        if (string2.startsWith(PREFIX_KEYBOARDHIDDEN)) {
                                            mKeyboardHiddenValues.put(field.getInt(null), (Object)string2);
                                            break block12;
                                        }
                                        if (!string2.startsWith(PREFIX_NAVIGATION)) break block13;
                                        mNavigationValues.put(field.getInt(null), (Object)string2);
                                        break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        Log.w((String)ACRA.LOG_TAG, (String)"Error while inspecting device configuration: ", (Throwable)illegalArgumentException);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        Log.w((String)ACRA.LOG_TAG, (String)"Error while inspecting device configuration: ", (Throwable)illegalAccessException);
                                    }
                                    break block12;
                                }
                                if (!string2.startsWith(PREFIX_NAVIGATIONHIDDEN)) break block15;
                                mNavigationHiddenValues.put(field.getInt(null), (Object)string2);
                                break block12;
                            }
                            if (!string2.startsWith(PREFIX_ORIENTATION)) break block16;
                            mOrientationValues.put(field.getInt(null), (Object)string2);
                            break block12;
                        }
                        if (!string2.startsWith(PREFIX_SCREENLAYOUT)) break block17;
                        mScreenLayoutValues.put(field.getInt(null), (Object)string2);
                        break block12;
                    }
                    if (string2.startsWith(PREFIX_TOUCHSCREEN)) {
                        mTouchScreenValues.put(field.getInt(null), (Object)string2);
                        break block12;
                    } else if (string2.startsWith(PREFIX_UI_MODE)) {
                        mUiModeValues.put(field.getInt(null), (Object)string2);
                    }
                    break block12;
                }
                return;
            }
            ++n3;
        }
    }

    private static String activeFlags(SparseArray<String> sparseArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < sparseArray.size(); ++i2) {
            int n3;
            int n4 = sparseArray.keyAt(i2);
            if (!((String)sparseArray.get(n4)).endsWith(SUFFIX_MASK) || (n3 = n2 & n4) <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('+');
            }
            stringBuilder.append((String)sparseArray.get(n3));
        }
        return stringBuilder.toString();
    }

    public static String collectConfiguration(Context context) {
        try {
            String string2 = ConfigurationCollector.toString(context.getResources().getConfiguration());
            return string2;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve CrashConfiguration for : " + context.getPackageName()), (Throwable)runtimeException);
            return "Couldn't retrieve crash config";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFieldValueName(Configuration configuration, Field field) throws IllegalAccessException {
        String string2 = field.getName();
        if (string2.equals(FIELD_MCC)) return Integer.toString(field.getInt(configuration));
        if (string2.equals(FIELD_MNC)) {
            return Integer.toString(field.getInt(configuration));
        }
        if (string2.equals(FIELD_UIMODE)) {
            return ConfigurationCollector.activeFlags(mValueArrays.get(PREFIX_UI_MODE), field.getInt(configuration));
        }
        if (string2.equals(FIELD_SCREENLAYOUT)) {
            return ConfigurationCollector.activeFlags(mValueArrays.get(PREFIX_SCREENLAYOUT), field.getInt(configuration));
        }
        SparseArray<String> sparseArray = mValueArrays.get(string2.toUpperCase() + '_');
        if (sparseArray == null) {
            return Integer.toString(field.getInt(configuration));
        }
        String string3 = (String)sparseArray.get(field.getInt(configuration));
        if (string3 != null) return string3;
        return Integer.toString(field.getInt(configuration));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(Configuration configuration) {
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray = configuration.getClass().getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            try {
                if (!Modifier.isStatic(field.getModifiers())) {
                    stringBuilder.append(field.getName()).append('=');
                    if (field.getType().equals(Integer.TYPE)) {
                        stringBuilder.append(ConfigurationCollector.getFieldValueName(configuration, field));
                    } else if (field.get(configuration) != null) {
                        stringBuilder.append(field.get(configuration).toString());
                    }
                    stringBuilder.append('\n');
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)ACRA.LOG_TAG, (String)"Error while inspecting device configuration: ", (Throwable)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)ACRA.LOG_TAG, (String)"Error while inspecting device configuration: ", (Throwable)illegalAccessException);
            }
            ++n3;
        }
        return stringBuilder.toString();
    }
}

