/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.acra.ACRA;
import org.acra.CrashReportFileNameParser;
import org.acra.CrashReportFinder;
import org.acra.CrashReportPersister;
import org.acra.collector.CrashReportData;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;

final class SendWorker
extends Thread {
    private final boolean approvePendingReports;
    private final Context context;
    private final CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
    private final List<ReportSender> reportSenders;
    private final boolean sendOnlySilentReports;

    public SendWorker(Context context, List<ReportSender> list, boolean bl2, boolean bl3) {
        this.context = context;
        this.reportSenders = list;
        this.sendOnlySilentReports = bl2;
        this.approvePendingReports = bl3;
    }

    private void approvePendingReports() {
        Log.d((String)ACRA.LOG_TAG, (String)"Mark all pending reports as approved.");
        for (String string2 : new CrashReportFinder(this.context).getCrashReportFiles()) {
            if (this.fileNameParser.isApproved(string2)) continue;
            File file = new File(this.context.getFilesDir(), string2);
            String string3 = string2.replace(".stacktrace", "-approved.stacktrace");
            File file2 = new File(this.context.getFilesDir(), string3);
            if (file.renameTo(file2)) continue;
            Log.e((String)ACRA.LOG_TAG, (String)("Could not rename approved report from " + file + " to " + file2));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkAndSendReports(Context context, boolean bl2) {
        Log.d((String)ACRA.LOG_TAG, (String)"#checkAndSendReports - start");
        Object[] objectArray = new CrashReportFinder(context).getCrashReportFiles();
        Arrays.sort(objectArray);
        int n2 = 0;
        for (Object object : objectArray) {
            if (bl2 && !this.fileNameParser.isSilent((String)object)) continue;
            if (n2 >= 5) break;
            Log.i((String)ACRA.LOG_TAG, (String)("Sending file " + (String)object));
            try {
                this.sendCrashReport(new CrashReportPersister(context).load((String)object));
                this.deleteFile(context, (String)object);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)ACRA.LOG_TAG, (String)("Failed to send crash reports for " + (String)object), (Throwable)runtimeException);
                this.deleteFile(context, (String)object);
                break;
            }
            catch (IOException iOException) {
                Log.e((String)ACRA.LOG_TAG, (String)("Failed to load crash report for " + (String)object), (Throwable)iOException);
                this.deleteFile(context, (String)object);
                break;
            }
            catch (ReportSenderException reportSenderException) {
                Log.e((String)ACRA.LOG_TAG, (String)("Failed to send crash report for " + (String)object), (Throwable)reportSenderException);
            }
            ++n2;
        }
        Log.d((String)ACRA.LOG_TAG, (String)"#checkAndSendReports - finish");
    }

    private void deleteFile(Context context, String string2) {
        if (!context.deleteFile(string2)) {
            Log.w((String)ACRA.LOG_TAG, (String)("Could not delete error report : " + string2));
        }
    }

    private void sendCrashReport(CrashReportData crashReportData) throws ReportSenderException {
        if (!ACRA.isDebuggable() || ACRA.getConfig().sendReportsInDevMode()) {
            boolean bl2 = false;
            for (ReportSender reportSender : this.reportSenders) {
                try {
                    reportSender.send(crashReportData);
                    bl2 = true;
                }
                catch (ReportSenderException reportSenderException) {
                    if (!bl2) {
                        throw reportSenderException;
                    }
                    Log.w((String)ACRA.LOG_TAG, (String)("ReportSender of class " + reportSender.getClass().getName() + " failed but other senders completed their task. ACRA will not send this report again."));
                }
            }
        }
    }

    @Override
    public void run() {
        if (this.approvePendingReports) {
            this.approvePendingReports();
        }
        this.checkAndSendReports(this.context, this.sendOnlySilentReports);
    }
}

