/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Activity;
import android.app.Application;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Bundle;
import android.os.Looper;
import android.os.Process;
import android.text.format.Time;
import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.acra.ACRA;
import org.acra.ACRAConfiguration;
import org.acra.ACRAConstants;
import org.acra.CrashReportDialog;
import org.acra.CrashReportFileNameParser;
import org.acra.CrashReportFinder;
import org.acra.CrashReportPersister;
import org.acra.ReportField;
import org.acra.ReportingInteractionMode;
import org.acra.SendWorker;
import org.acra.collector.Compatibility;
import org.acra.collector.ConfigurationCollector;
import org.acra.collector.CrashReportData;
import org.acra.collector.CrashReportDataFactory;
import org.acra.jraf.android.util.activitylifecyclecallbackscompat.ActivityLifecycleCallbacksCompat;
import org.acra.jraf.android.util.activitylifecyclecallbackscompat.ApplicationHelper;
import org.acra.sender.EmailIntentSender;
import org.acra.sender.GoogleFormSender;
import org.acra.sender.HttpSender;
import org.acra.sender.ReportSender;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.ToastSender;

public class ErrorReporter
implements Thread.UncaughtExceptionHandler {
    private static int mNotificationCounter;
    private static boolean toastWaitEnded;
    private Thread brokenThread;
    private final CrashReportDataFactory crashReportDataFactory;
    private boolean enabled = false;
    private final CrashReportFileNameParser fileNameParser;
    private transient Activity lastActivityCreated;
    private final Application mContext;
    private final Thread.UncaughtExceptionHandler mDfltExceptionHandler;
    private final List<ReportSender> mReportSenders = new ArrayList<ReportSender>();
    private final SharedPreferences prefs;
    private Throwable unhandledThrowable;

    static {
        toastWaitEnded = true;
        mNotificationCounter = 0;
    }

    ErrorReporter(Application application, SharedPreferences sharedPreferences, boolean bl2) {
        this.fileNameParser = new CrashReportFileNameParser();
        this.mContext = application;
        this.prefs = sharedPreferences;
        this.enabled = bl2;
        String string2 = ConfigurationCollector.collectConfiguration((Context)this.mContext);
        Time time = new Time();
        time.setToNow();
        if (Compatibility.getAPILevel() >= 14) {
            ApplicationHelper.registerActivityLifecycleCallbacks(application, new ActivityLifecycleCallbacksCompat(){

                @Override
                public void onActivityCreated(Activity activity, Bundle bundle) {
                    if (!(activity instanceof CrashReportDialog)) {
                        ErrorReporter.access$002(ErrorReporter.this, activity);
                    }
                }

                @Override
                public void onActivityDestroyed(Activity activity) {
                }

                @Override
                public void onActivityPaused(Activity activity) {
                }

                @Override
                public void onActivityResumed(Activity activity) {
                }

                @Override
                public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                }

                @Override
                public void onActivityStarted(Activity activity) {
                }

                @Override
                public void onActivityStopped(Activity activity) {
                }
            });
        }
        this.crashReportDataFactory = new CrashReportDataFactory((Context)this.mContext, sharedPreferences, time, string2);
        this.mDfltExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.checkReportsOnApplicationStart();
    }

    static /* synthetic */ Activity access$002(ErrorReporter errorReporter, Activity activity) {
        errorReporter.lastActivityCreated = activity;
        return activity;
    }

    static /* synthetic */ boolean access$202(boolean bl2) {
        toastWaitEnded = bl2;
        return bl2;
    }

    private boolean containsOnlySilentOrApprovedReports(String[] stringArray) {
        for (String string2 : stringArray) {
            if (this.fileNameParser.isApproved(string2)) continue;
            return false;
        }
        return true;
    }

    private void deletePendingReports(boolean bl2, boolean bl3, int n2) {
        Object[] objectArray = new CrashReportFinder((Context)this.mContext).getCrashReportFiles();
        Arrays.sort(objectArray);
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length - n2; ++i2) {
                Object object = objectArray[i2];
                boolean bl4 = this.fileNameParser.isApproved((String)object);
                if ((!bl4 || !bl2) && (bl4 || !bl3)) continue;
                File file = new File(this.mContext.getFilesDir(), (String)object);
                ACRA.log.d(ACRA.LOG_TAG, "Deleting file " + (String)object);
                if (file.delete()) continue;
                Log.e((String)ACRA.LOG_TAG, (String)("Could not delete report : " + file));
            }
        }
    }

    private void endApplication() {
        if (ACRA.getConfig().mode() == ReportingInteractionMode.SILENT || ACRA.getConfig().mode() == ReportingInteractionMode.TOAST && ACRA.getConfig().forceCloseDialogAfterToast()) {
            this.mDfltExceptionHandler.uncaughtException(this.brokenThread, this.unhandledThrowable);
            return;
        }
        Log.e((String)ACRA.LOG_TAG, (String)(this.mContext.getPackageName() + " fatal error : " + this.unhandledThrowable.getMessage()), (Throwable)this.unhandledThrowable);
        if (this.lastActivityCreated != null) {
            Log.i((String)ACRA.LOG_TAG, (String)"Finishing the last Activity prior to killing the Process");
            this.lastActivityCreated.finish();
            Log.i((String)ACRA.LOG_TAG, (String)("Finished " + this.lastActivityCreated.getClass()));
            this.lastActivityCreated = null;
        }
        Process.killProcess((int)Process.myPid());
        System.exit(10);
    }

    public static ErrorReporter getInstance() {
        return ACRA.getErrorReporter();
    }

    private String getLatestNonSilentReport(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = -1 + stringArray.length; i2 >= 0; --i2) {
                if (this.fileNameParser.isSilent(stringArray[i2])) continue;
                return stringArray[i2];
            }
            return stringArray[-1 + stringArray.length];
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getReportFileName(CrashReportData crashReportData) {
        String string2;
        Time time = new Time();
        time.setToNow();
        long l2 = time.toMillis(false);
        String string3 = crashReportData.getProperty(ReportField.IS_SILENT);
        StringBuilder stringBuilder = new StringBuilder().append("").append(l2);
        if (string3 != null) {
            string2 = ACRAConstants.SILENT_SUFFIX;
            return stringBuilder.append(string2).append(".stacktrace").toString();
        }
        string2 = "";
        return stringBuilder.append(string2).append(".stacktrace").toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleException(Throwable throwable, ReportingInteractionMode reportingInteractionMode, boolean bl2, final boolean bl3) {
        SendWorker sendWorker;
        boolean bl4;
        final boolean bl5 = true;
        if (!this.enabled) {
            return;
        }
        boolean bl6 = false;
        if (reportingInteractionMode == null) {
            reportingInteractionMode = ACRA.getConfig().mode();
        } else {
            ReportingInteractionMode reportingInteractionMode2 = ReportingInteractionMode.SILENT;
            bl6 = false;
            if (reportingInteractionMode == reportingInteractionMode2) {
                ReportingInteractionMode reportingInteractionMode3 = ACRA.getConfig().mode();
                ReportingInteractionMode reportingInteractionMode4 = ReportingInteractionMode.SILENT;
                bl6 = false;
                if (reportingInteractionMode3 != reportingInteractionMode4) {
                    bl6 = true;
                }
            }
        }
        if (throwable == null) {
            throwable = new Exception("Report requested by developer");
        }
        if (bl4 = reportingInteractionMode == ReportingInteractionMode.TOAST || ACRA.getConfig().resToastText() != 0 && (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION || reportingInteractionMode == ReportingInteractionMode.DIALOG) ? bl5 : false) {
            new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    ToastSender.sendToast((Context)ErrorReporter.this.mContext, ACRA.getConfig().resToastText(), 1);
                    Looper.loop();
                }
            }.start();
        }
        CrashReportData crashReportData = this.crashReportDataFactory.createCrashData(throwable, bl2, this.brokenThread);
        final String string2 = this.getReportFileName(crashReportData);
        this.saveCrashReportFile(string2, crashReportData);
        if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST || this.prefs.getBoolean("acra.alwaysaccept", false)) {
            Log.d((String)ACRA.LOG_TAG, (String)"About to start ReportSenderWorker from #handleException");
            sendWorker = this.startSendingReports(bl6, bl5);
        } else {
            ReportingInteractionMode reportingInteractionMode5 = ReportingInteractionMode.NOTIFICATION;
            sendWorker = null;
            if (reportingInteractionMode == reportingInteractionMode5) {
                Log.d((String)ACRA.LOG_TAG, (String)"Notification will be created on application start.");
                sendWorker = null;
            }
        }
        if (bl4) {
            toastWaitEnded = false;
            new Thread(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Time time = new Time();
                    Time time2 = new Time();
                    time.setToNow();
                    long l2 = time.toMillis(false);
                    long l3 = 0L;
                    while (true) {
                        if (l3 >= 3000L) {
                            ErrorReporter.access$202(true);
                            return;
                        }
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)ACRA.LOG_TAG, (String)"Interrupted while waiting for Toast to end.", (Throwable)interruptedException);
                        }
                        time2.setToNow();
                        l3 = time2.toMillis(false) - l2;
                    }
                }
            }.start();
        }
        final SendWorker sendWorker2 = sendWorker;
        if (reportingInteractionMode != ReportingInteractionMode.DIALOG || this.prefs.getBoolean("acra.alwaysaccept", false)) {
            bl5 = false;
        }
        new Thread(){

            @Override
            public void run() {
                Log.d((String)ACRA.LOG_TAG, (String)"Waiting for Toast + worker...");
                while (!toastWaitEnded || sendWorker2 != null && sendWorker2.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        Log.e((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)interruptedException);
                    }
                }
                if (bl5) {
                    Log.d((String)ACRA.LOG_TAG, (String)"About to create DIALOG from #handleException");
                    ErrorReporter.this.notifyDialog(string2);
                }
                Log.d((String)ACRA.LOG_TAG, (String)("Wait for Toast + worker ended. Kill Application ? " + bl3));
                if (bl3) {
                    ErrorReporter.this.endApplication();
                }
            }
        }.start();
    }

    private void notifySendReport(String string2) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        ACRAConfiguration aCRAConfiguration = ACRA.getConfig();
        Notification notification = new Notification(aCRAConfiguration.resNotifIcon(), this.mContext.getText(aCRAConfiguration.resNotifTickerText()), System.currentTimeMillis());
        CharSequence charSequence = this.mContext.getText(aCRAConfiguration.resNotifTitle());
        CharSequence charSequence2 = this.mContext.getText(aCRAConfiguration.resNotifText());
        Intent intent = new Intent((Context)this.mContext, CrashReportDialog.class);
        Log.d((String)ACRA.LOG_TAG, (String)("Creating Notification for " + string2));
        intent.putExtra("REPORT_FILE_NAME", string2);
        Application application = this.mContext;
        int n2 = mNotificationCounter;
        mNotificationCounter = n2 + 1;
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)application, (int)n2, (Intent)intent, (int)0x8000000);
        notification.setLatestEventInfo((Context)this.mContext, charSequence, charSequence2, pendingIntent);
        Intent intent2 = new Intent((Context)this.mContext, CrashReportDialog.class);
        intent2.putExtra("FORCE_CANCEL", true);
        notification.deleteIntent = PendingIntent.getActivity((Context)this.mContext, (int)-1, (Intent)intent2, (int)0);
        notificationManager.notify(666, notification);
    }

    private void saveCrashReportFile(String string2, CrashReportData crashReportData) {
        try {
            Log.d((String)ACRA.LOG_TAG, (String)("Writing crash report file " + string2 + "."));
            new CrashReportPersister((Context)this.mContext).store(crashReportData, string2);
            return;
        }
        catch (Exception exception) {
            Log.e((String)ACRA.LOG_TAG, (String)"An error occurred while writing the report file...", (Throwable)exception);
            return;
        }
    }

    @Deprecated
    public void addCustomData(String string2, String string3) {
        this.crashReportDataFactory.putCustomData(string2, string3);
    }

    public void addReportSender(ReportSender reportSender) {
        this.mReportSenders.add(reportSender);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkReportsOnApplicationStart() {
        CrashReportFinder crashReportFinder;
        String[] stringArray;
        long l2 = this.prefs.getInt("acra.lastVersionNr", 0);
        PackageInfo packageInfo = new PackageManagerWrapper((Context)this.mContext).getPackageInfo();
        boolean bl2 = packageInfo != null && (long)packageInfo.versionCode > l2;
        if (bl2) {
            if (ACRA.getConfig().deleteOldUnsentReportsOnApplicationStart()) {
                this.deletePendingReports();
            }
            SharedPreferences.Editor editor = this.prefs.edit();
            editor.putInt("acra.lastVersionNr", packageInfo.versionCode);
            editor.commit();
        }
        if ((ACRA.getConfig().mode() == ReportingInteractionMode.NOTIFICATION || ACRA.getConfig().mode() == ReportingInteractionMode.DIALOG) && ACRA.getConfig().deleteUnapprovedReportsOnApplicationStart()) {
            this.deletePendingNonApprovedReports(true);
        }
        if ((stringArray = (crashReportFinder = new CrashReportFinder((Context)this.mContext)).getCrashReportFiles()) == null || stringArray.length <= 0) return;
        ReportingInteractionMode reportingInteractionMode = ACRA.getConfig().mode();
        String[] stringArray2 = crashReportFinder.getCrashReportFiles();
        boolean bl3 = this.containsOnlySilentOrApprovedReports(stringArray2);
        if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST || bl3 && (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION || reportingInteractionMode == ReportingInteractionMode.DIALOG)) {
            if (reportingInteractionMode == ReportingInteractionMode.TOAST && !bl3) {
                ToastSender.sendToast((Context)this.mContext, ACRA.getConfig().resToastText(), 1);
            }
            Log.v((String)ACRA.LOG_TAG, (String)"About to start ReportSenderWorker from #checkReportOnApplicationStart");
            this.startSendingReports(false, false);
            return;
        } else {
            if (ACRA.getConfig().mode() == ReportingInteractionMode.NOTIFICATION) {
                this.notifySendReport(this.getLatestNonSilentReport(stringArray2));
                return;
            }
            if (ACRA.getConfig().mode() != ReportingInteractionMode.DIALOG) return;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void deletePendingNonApprovedReports(boolean bl2) {
        int n2 = bl2 ? 1 : 0;
        this.deletePendingReports(false, true, n2);
    }

    void deletePendingReports() {
        this.deletePendingReports(true, true, 0);
    }

    public String getCustomData(String string2) {
        return this.crashReportDataFactory.getCustomData(string2);
    }

    public void handleException(Throwable throwable) {
        this.handleException(throwable, ACRA.getConfig().mode(), false, false);
    }

    public void handleException(Throwable throwable, boolean bl2) {
        this.handleException(throwable, ACRA.getConfig().mode(), false, bl2);
    }

    public void handleSilentException(Throwable throwable) {
        if (this.enabled) {
            this.handleException(throwable, ReportingInteractionMode.SILENT, true, false);
            Log.d((String)ACRA.LOG_TAG, (String)"ACRA sent Silent report.");
            return;
        }
        Log.d((String)ACRA.LOG_TAG, (String)"ACRA is disabled. Silent report not sent.");
    }

    void notifyDialog(String string2) {
        Log.d((String)ACRA.LOG_TAG, (String)("Creating Dialog for " + string2));
        Intent intent = new Intent((Context)this.mContext, CrashReportDialog.class);
        intent.putExtra("REPORT_FILE_NAME", string2);
        intent.setFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    public String putCustomData(String string2, String string3) {
        return this.crashReportDataFactory.putCustomData(string2, string3);
    }

    public void removeAllReportSenders() {
        this.mReportSenders.clear();
    }

    public String removeCustomData(String string2) {
        return this.crashReportDataFactory.removeCustomData(string2);
    }

    public void removeReportSender(ReportSender reportSender) {
        this.mReportSenders.remove(reportSender);
    }

    public void removeReportSenders(Class<?> clazz) {
        if (ReportSender.class.isAssignableFrom(clazz)) {
            for (ReportSender reportSender : this.mReportSenders) {
                if (!clazz.isInstance(reportSender)) continue;
                this.mReportSenders.remove(reportSender);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDefaultReportSenders() {
        ACRAConfiguration aCRAConfiguration = ACRA.getConfig();
        Application application = ACRA.getApplication();
        this.removeAllReportSenders();
        if (!"".equals(aCRAConfiguration.mailTo())) {
            Log.w((String)ACRA.LOG_TAG, (String)(application.getPackageName() + " reports will be sent by email (if accepted by user)."));
            this.setReportSender(new EmailIntentSender((Context)application));
            return;
        } else {
            if (!new PackageManagerWrapper((Context)application).hasPermission("android.permission.INTERNET")) {
                Log.e((String)ACRA.LOG_TAG, (String)(application.getPackageName() + " should be granted permission " + "android.permission.INTERNET" + " if you want your crash reports to be sent. If you don't want to add this permission to your application you can also enable sending reports by email. If this is your will then provide your email address in @ReportsCrashes(mailTo=\"your.account@domain.com\""));
                return;
            }
            if (aCRAConfiguration.formUri() != null && !"".equals(aCRAConfiguration.formUri())) {
                this.setReportSender(new HttpSender(ACRA.getConfig().httpMethod(), ACRA.getConfig().reportType(), null));
                return;
            }
            if (aCRAConfiguration.formKey() == null || "".equals(aCRAConfiguration.formKey().trim())) return;
            this.addReportSender(new GoogleFormSender());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setEnabled(boolean bl2) {
        String string2 = ACRA.LOG_TAG;
        StringBuilder stringBuilder = new StringBuilder().append("ACRA is ");
        String string3 = bl2 ? "enabled" : "disabled";
        Log.i((String)string2, (String)stringBuilder.append(string3).append(" for ").append(this.mContext.getPackageName()).toString());
        this.enabled = bl2;
    }

    public void setReportSender(ReportSender reportSender) {
        this.removeAllReportSenders();
        this.addReportSender(reportSender);
    }

    SendWorker startSendingReports(boolean bl2, boolean bl3) {
        SendWorker sendWorker = new SendWorker((Context)this.mContext, this.mReportSenders, bl2, bl3);
        sendWorker.start();
        return sendWorker;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        try {
            if (!this.enabled) {
                if (this.mDfltExceptionHandler != null) {
                    Log.e((String)ACRA.LOG_TAG, (String)("ACRA is disabled for " + this.mContext.getPackageName() + " - forwarding uncaught Exception on to default ExceptionHandler"));
                    this.mDfltExceptionHandler.uncaughtException(thread, throwable);
                    return;
                }
                Log.e((String)ACRA.LOG_TAG, (String)("ACRA is disabled for " + this.mContext.getPackageName() + " - no default ExceptionHandler"));
                return;
            }
        }
        catch (Throwable throwable2) {
            if (this.mDfltExceptionHandler == null) return;
            this.mDfltExceptionHandler.uncaughtException(thread, throwable);
            return;
        }
        {
            this.brokenThread = thread;
            this.unhandledThrowable = throwable;
            Log.e((String)ACRA.LOG_TAG, (String)("ACRA caught a " + throwable.getClass().getSimpleName() + " exception for " + this.mContext.getPackageName() + ". Building report."));
            this.handleException(throwable, ACRA.getConfig().mode(), false, true);
            return;
        }
    }
}

