/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.content.Context;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Map;
import org.acra.ReportField;
import org.acra.collector.CrashReportData;

final class CrashReportPersister {
    private static final int CONTINUE = 3;
    private static final int IGNORE = 5;
    private static final int KEY_DONE = 4;
    private static final String LINE_SEPARATOR = "\n";
    private static final int NONE = 0;
    private static final int SLASH = 1;
    private static final int UNICODE = 2;
    private final Context context;

    CrashReportPersister(Context context) {
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dumpString(StringBuilder stringBuilder, String string2, boolean bl2) {
        int n2 = 0;
        if (!bl2) {
            int n3 = string2.length();
            n2 = 0;
            if (n3 < 0) {
                char c2 = string2.charAt(0);
                n2 = 0;
                if (c2 == ' ') {
                    stringBuilder.append("\\ ");
                    n2 = 0 + 1;
                }
            }
        }
        while (true) {
            block13: {
                if (n2 >= string2.length()) {
                    return;
                }
                char c3 = string2.charAt(n2);
                switch (c3) {
                    default: {
                        if ("\\#!=:".indexOf(c3) >= 0 || bl2 && c3 == ' ') {
                            stringBuilder.append('\\');
                        }
                        if (c3 < ' ' || c3 > '~') break;
                        stringBuilder.append(c3);
                        break block13;
                    }
                    case '\t': {
                        stringBuilder.append("\\t");
                        break block13;
                    }
                    case '\n': {
                        stringBuilder.append("\\n");
                        break block13;
                    }
                    case '\f': {
                        stringBuilder.append("\\f");
                        break block13;
                    }
                    case '\r': {
                        stringBuilder.append("\\r");
                        break block13;
                    }
                }
                String string3 = Integer.toHexString(c3);
                stringBuilder.append("\\u");
                for (int i2 = 0; i2 < 4 - string3.length(); ++i2) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(string3);
            }
            ++n2;
        }
    }

    private boolean isEbcdic(BufferedInputStream bufferedInputStream) throws IOException {
        byte by2;
        do {
            if ((by2 = (byte)bufferedInputStream.read()) != -1 && by2 != 35 && by2 != 10 && by2 != 61) continue;
            return false;
        } while (by2 != 21);
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CrashReportData load(Reader var1_1) throws IOException {
        synchronized (this) {
            var2_2 = 0;
            var3_3 = 0;
            var4_4 = 0;
            var6_5 = new char[40];
            var7_6 = -1;
            var8_7 = true;
            var9_8 = new CrashReportData();
            var10_9 = new BufferedReader(var1_1, 8192);
            var11_10 = 0;
            block22: while (true) {
                block44: {
                    block43: {
                        if ((var12_11 = var10_9.read()) == -1) {
                            if (var2_2 != 2 || var4_4 > 4) break;
                            throw new IllegalArgumentException("luni.08");
                        }
                        var13_12 = var12_11;
                        if (var11_10 == var6_5.length) {
                            var21_19 = new char[2 * var6_5.length];
                            System.arraycopy(var6_5, 0, var21_19, 0, var11_10);
                            var6_5 = var21_19;
                        }
                        if (var2_2 == 2) {
                            var14_13 = Character.digit((char)var13_12, 16);
                            if (var14_13 >= 0) {
                                var3_3 = var14_13 + (var3_3 << 4);
                                if (++var4_4 < 4) continue;
                            } else if (var4_4 <= 4) {
                                throw new IllegalArgumentException("luni.09");
                            }
                            var2_2 = 0;
                            var15_14 = var11_10 + 1;
                            var6_5[var11_10] = (char)var3_3;
                            if (var13_12 != 10 && var13_12 != 133) {
                                var11_10 = var15_14;
                                var2_2 = 0;
                                continue;
                            }
                            var11_10 = var15_14;
                        }
                        if (var2_2 != 1) break block43;
                        var2_2 = 0;
                        switch (var13_12) {
                            case 13: {
                                var2_2 = 3;
                                continue block22;
                            }
                            case 10: 
                            case 133: {
                                var2_2 = 5;
                                continue block22;
                            }
                            case 98: {
                                var13_12 = 8;
                                var2_2 = 0;
                                ** break;
                            }
                            case 102: {
                                var13_12 = 12;
                                var2_2 = 0;
                                ** break;
                            }
                            case 110: {
                                var13_12 = 10;
                                var2_2 = 0;
                                ** break;
                            }
                            case 114: {
                                var13_12 = 13;
                                var2_2 = 0;
                                ** break;
                            }
                            case 116: {
                                var13_12 = 9;
                                var2_2 = 0;
                            }
lbl64:
                            // 6 sources

                            default: {
                                break block44;
                            }
                            case 117: 
                        }
                        var2_2 = 2;
                        var4_4 = 0;
                        var3_3 = 0;
                        continue;
                    }
                    switch (var13_12) {
                        default: {
                            break;
                        }
                        case 33: 
                        case 35: {
                            if (!var8_7) break;
                            while ((var19_17 = var10_9.read()) != -1 && (var20_18 = (char)var19_17) != '\r' && var20_18 != '\n' && var20_18 != '\u0085') {
                            }
                            continue block22;
                        }
                        case 10: {
                            if (var2_2 == 3) {
                                var2_2 = 5;
                                continue block22;
                            }
                        }
                        case 13: 
                        case 133: {
                            var8_7 = true;
                            if (var11_10 > 0 || var11_10 == 0 && var7_6 == 0) {
                                if (var7_6 == -1) {
                                    var7_6 = var11_10;
                                }
                                var17_16 = new String(var6_5, 0, var11_10);
                                var9_8.put(Enum.valueOf(ReportField.class, var17_16.substring(0, var7_6)), var17_16.substring(var7_6));
                            }
                            var7_6 = -1;
                            var2_2 = 0;
                            var11_10 = 0;
                            continue block22;
                        }
                        case 92: {
                            if (var2_2 == 4) {
                                var7_6 = var11_10;
                            }
                            var2_2 = 1;
                            continue block22;
                        }
                        case 58: 
                        case 61: {
                            if (var7_6 != -1) break;
                            var7_6 = var11_10;
                            var2_2 = 0;
                            continue block22;
                        }
                    }
                    if (Character.isWhitespace((char)var13_12)) {
                        if (var2_2 == 3) {
                            var2_2 = 5;
                        }
                        if (var11_10 == 0 || var11_10 == var7_6 || var2_2 == 5) continue;
                        if (var7_6 == -1) {
                            var2_2 = 4;
                            continue;
                        }
                    }
                    if (var2_2 == 5 || var2_2 == 3) {
                        var2_2 = 0;
                    }
                }
                if (var2_2 == 4) {
                    var7_6 = var11_10;
                    var2_2 = 0;
                }
                var16_15 = var11_10 + 1;
                var6_5[var11_10] = var13_12;
                var11_10 = var16_15;
                var8_7 = false;
            }
            if (var7_6 == -1 && var11_10 > 0) {
                var7_6 = var11_10;
            }
            if (var7_6 >= 0) {
                var22_20 = new String(var6_5, 0, var11_10);
                var23_21 = Enum.valueOf(ReportField.class, var22_20.substring(0, var7_6));
                var24_22 = var22_20.substring(var7_6);
                if (var2_2 == 1) {
                    var24_22 = var24_22 + "\u0000";
                }
                var9_8.put(var23_21, var24_22);
            }
            return var9_8;
        }
    }

    public CrashReportData load(String string2) throws IOException {
        FileInputStream fileInputStream = this.context.openFileInput(string2);
        if (fileInputStream == null) {
            throw new IllegalArgumentException("Invalid crash report fileName : " + string2);
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
            bufferedInputStream.mark(Integer.MAX_VALUE);
            boolean bl2 = this.isEbcdic(bufferedInputStream);
            bufferedInputStream.reset();
            if (!bl2) {
                CrashReportData crashReportData = this.load(new InputStreamReader((InputStream)bufferedInputStream, "ISO8859-1"));
                return crashReportData;
            }
            CrashReportData crashReportData = this.load(new InputStreamReader(bufferedInputStream));
            return crashReportData;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(CrashReportData crashReportData, String string2) throws IOException {
        FileOutputStream fileOutputStream = this.context.openFileOutput(string2, 0);
        try {
            StringBuilder stringBuilder = new StringBuilder(200);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "ISO8859_1");
            for (Map.Entry entry : crashReportData.entrySet()) {
                this.dumpString(stringBuilder, ((ReportField)((Object)entry.getKey())).toString(), true);
                stringBuilder.append('=');
                this.dumpString(stringBuilder, (String)entry.getValue(), false);
                stringBuilder.append(LINE_SEPARATOR);
                outputStreamWriter.write(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            outputStreamWriter.flush();
            return;
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }
}

