/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import java.io.IOException;
import org.acra.ACRA;
import org.acra.CrashReportPersister;
import org.acra.ReportField;
import org.acra.collector.CrashReportData;
import org.acra.util.ToastSender;

public class CrashReportDialog
extends Activity
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener {
    private static final String STATE_COMMENT = "comment";
    private static final String STATE_EMAIL = "email";
    AlertDialog mDialog;
    String mReportFileName;
    private SharedPreferences prefs;
    private EditText userComment;
    private EditText userEmail;

    /*
     * Enabled aggressive block sorting
     */
    private View buildCustomView(Bundle bundle) {
        int n2;
        LinearLayout linearLayout = new LinearLayout((Context)this);
        linearLayout.setOrientation(1);
        linearLayout.setPadding(10, 10, 10, 10);
        linearLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        linearLayout.setFocusable(true);
        linearLayout.setFocusableInTouchMode(true);
        ScrollView scrollView = new ScrollView((Context)this);
        linearLayout.addView((View)scrollView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        LinearLayout linearLayout2 = new LinearLayout((Context)this);
        linearLayout2.setOrientation(1);
        scrollView.addView((View)linearLayout2);
        TextView textView = new TextView((Context)this);
        int n3 = ACRA.getConfig().resDialogText();
        if (n3 != 0) {
            textView.setText(this.getText(n3));
        }
        linearLayout2.addView((View)textView);
        int n4 = ACRA.getConfig().resDialogCommentPrompt();
        if (n4 != 0) {
            String string2;
            TextView textView2 = new TextView((Context)this);
            textView2.setText(this.getText(n4));
            textView2.setPadding(textView2.getPaddingLeft(), 10, textView2.getPaddingRight(), textView2.getPaddingBottom());
            linearLayout2.addView((View)textView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.userComment = new EditText((Context)this);
            this.userComment.setLines(2);
            if (bundle != null && (string2 = bundle.getString(STATE_COMMENT)) != null) {
                this.userComment.setText((CharSequence)string2);
            }
            linearLayout2.addView((View)this.userComment);
        }
        if ((n2 = ACRA.getConfig().resDialogEmailPrompt()) != 0) {
            TextView textView3 = new TextView((Context)this);
            textView3.setText(this.getText(n2));
            textView3.setPadding(textView3.getPaddingLeft(), 10, textView3.getPaddingRight(), textView3.getPaddingBottom());
            linearLayout2.addView((View)textView3);
            this.userEmail = new EditText((Context)this);
            this.userEmail.setSingleLine();
            this.userEmail.setInputType(33);
            this.prefs = this.getSharedPreferences(ACRA.getConfig().sharedPreferencesName(), ACRA.getConfig().sharedPreferencesMode());
            String string3 = null;
            if (bundle != null) {
                string3 = bundle.getString(STATE_EMAIL);
            }
            if (string3 != null) {
                this.userEmail.setText((CharSequence)string3);
            } else {
                this.userEmail.setText((CharSequence)this.prefs.getString("acra.user.email", ""));
            }
            linearLayout2.addView((View)this.userEmail);
        }
        return linearLayout;
    }

    private void cancelReports() {
        ACRA.getErrorReporter().deletePendingNonApprovedReports(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendCrash() {
        String string2;
        String string3 = this.userComment != null ? this.userComment.getText().toString() : "";
        if (this.prefs != null && this.userEmail != null) {
            string2 = this.userEmail.getText().toString();
            SharedPreferences.Editor editor = this.prefs.edit();
            editor.putString("acra.user.email", string2);
            editor.commit();
        } else {
            string2 = "";
        }
        CrashReportPersister crashReportPersister = new CrashReportPersister(this.getApplicationContext());
        try {
            Log.d((String)ACRA.LOG_TAG, (String)("Add user comment to " + this.mReportFileName));
            CrashReportData crashReportData = crashReportPersister.load(this.mReportFileName);
            crashReportData.put(ReportField.USER_COMMENT, string3);
            crashReportData.put(ReportField.USER_EMAIL, string2);
            crashReportPersister.store(crashReportData, this.mReportFileName);
        }
        catch (IOException iOException) {
            Log.w((String)ACRA.LOG_TAG, (String)"User comment not added: ", (Throwable)iOException);
        }
        Log.v((String)ACRA.LOG_TAG, (String)"About to start SenderWorker from CrashReportDialog");
        ACRA.getErrorReporter().startSendingReports(false, true);
        int n2 = ACRA.getConfig().resDialogOkToast();
        if (n2 != 0) {
            ToastSender.sendToast(this.getApplicationContext(), n2, 1);
        }
    }

    protected void cancelNotification() {
        ((NotificationManager)this.getSystemService("notification")).cancel(666);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onClick(DialogInterface dialogInterface, int n2) {
        if (n2 == -1) {
            this.sendCrash();
        } else {
            this.cancelReports();
        }
        this.finish();
    }

    protected void onCreate(Bundle bundle) {
        int n2;
        super.onCreate(bundle);
        if (this.getIntent().getBooleanExtra("FORCE_CANCEL", false)) {
            ACRA.log.d(ACRA.LOG_TAG, "Forced reports deletion.");
            this.cancelReports();
            this.finish();
            return;
        }
        this.mReportFileName = this.getIntent().getStringExtra("REPORT_FILE_NAME");
        Log.d((String)ACRA.LOG_TAG, (String)("Opening CrashReportDialog for " + this.mReportFileName));
        if (this.mReportFileName == null) {
            this.finish();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        int n3 = ACRA.getConfig().resDialogTitle();
        if (n3 != 0) {
            builder.setTitle(n3);
        }
        if ((n2 = ACRA.getConfig().resDialogIcon()) != 0) {
            builder.setIcon(n2);
        }
        builder.setView(this.buildCustomView(bundle));
        builder.setPositiveButton(17039370, (DialogInterface.OnClickListener)this);
        builder.setNegativeButton(0x1040000, (DialogInterface.OnClickListener)this);
        this.cancelNotification();
        this.mDialog = builder.create();
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        this.mDialog.show();
    }

    public void onDismiss(DialogInterface dialogInterface) {
        this.finish();
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (this.userComment != null && this.userComment.getText() != null) {
            bundle.putString(STATE_COMMENT, this.userComment.getText().toString());
        }
        if (this.userEmail != null && this.userEmail.getText() != null) {
            bundle.putString(STATE_EMAIL, this.userEmail.getText().toString());
        }
    }
}

