/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.preference.PreferenceManager;
import org.acra.ACRAConfiguration;
import org.acra.ACRAConfigurationException;
import org.acra.ErrorReporter;
import org.acra.annotation.ReportsCrashes;
import org.acra.log.ACRALog;
import org.acra.log.AndroidLogDelegate;

public class ACRA {
    public static final boolean DEV_LOGGING = false;
    public static final String LOG_TAG = ACRA.class.getSimpleName();
    public static final String PREF_ALWAYS_ACCEPT = "acra.alwaysaccept";
    public static final String PREF_DISABLE_ACRA = "acra.disable";
    public static final String PREF_ENABLE_ACRA = "acra.enable";
    public static final String PREF_ENABLE_DEVICE_ID = "acra.deviceid.enable";
    public static final String PREF_ENABLE_SYSTEM_LOGS = "acra.syslog.enable";
    public static final String PREF_LAST_VERSION_NR = "acra.lastVersionNr";
    public static final String PREF_USER_EMAIL_ADDRESS = "acra.user.email";
    private static ACRAConfiguration configProxy;
    private static ErrorReporter errorReporterSingleton;
    public static ACRALog log;
    private static Application mApplication;
    private static SharedPreferences.OnSharedPreferenceChangeListener mPrefListener;
    private static ReportsCrashes mReportsCrashes;

    static {
        log = new AndroidLogDelegate();
    }

    /*
     * Enabled aggressive block sorting
     */
    static void checkCrashResources() throws ACRAConfigurationException {
        ACRAConfiguration aCRAConfiguration = ACRA.getConfig();
        switch (2.$SwitchMap$org$acra$ReportingInteractionMode[aCRAConfiguration.mode().ordinal()]) {
            case 1: {
                if (aCRAConfiguration.resToastText() != 0) return;
                throw new ACRAConfigurationException("TOAST mode: you have to define the resToastText parameter in your application @ReportsCrashes() annotation.");
            }
            case 2: {
                if (aCRAConfiguration.resNotifTickerText() != 0 && aCRAConfiguration.resNotifTitle() != 0 && aCRAConfiguration.resNotifText() != 0 && aCRAConfiguration.resDialogText() != 0) return;
                throw new ACRAConfigurationException("NOTIFICATION mode: you have to define at least the resNotifTickerText, resNotifTitle, resNotifText, resDialogText parameters in your application @ReportsCrashes() annotation.");
            }
            default: {
                return;
            }
            case 3: 
        }
        if (aCRAConfiguration.resDialogText() != 0) return;
        throw new ACRAConfigurationException("DIALOG mode: you have to define at least the resDialogText parameters in your application @ReportsCrashes() annotation.");
    }

    public static SharedPreferences getACRASharedPreferences() {
        ACRAConfiguration aCRAConfiguration = ACRA.getConfig();
        if (!"".equals(aCRAConfiguration.sharedPreferencesName())) {
            return mApplication.getSharedPreferences(aCRAConfiguration.sharedPreferencesName(), aCRAConfiguration.sharedPreferencesMode());
        }
        return PreferenceManager.getDefaultSharedPreferences((Context)mApplication);
    }

    static Application getApplication() {
        return mApplication;
    }

    public static ACRAConfiguration getConfig() {
        if (configProxy == null) {
            if (mApplication == null) {
                log.w(LOG_TAG, "Calling ACRA.getConfig() before ACRA.init() gives you an empty configuration instance. You might prefer calling ACRA.getNewDefaultConfig(Application) to get an instance with default values taken from a @ReportsCrashes annotation.");
            }
            configProxy = ACRA.getNewDefaultConfig(mApplication);
        }
        return configProxy;
    }

    public static ErrorReporter getErrorReporter() {
        if (errorReporterSingleton == null) {
            throw new IllegalStateException("Cannot access ErrorReporter before ACRA#init");
        }
        return errorReporterSingleton;
    }

    public static ACRAConfiguration getNewDefaultConfig(Application application) {
        if (application != null) {
            return new ACRAConfiguration(application.getClass().getAnnotation(ReportsCrashes.class));
        }
        return new ACRAConfiguration(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void init(Application application) {
        if (mApplication != null) {
            log.w(LOG_TAG, "ACRA#init called more than once. Won't do anything more.");
            return;
        }
        mApplication = application;
        mReportsCrashes = mApplication.getClass().getAnnotation(ReportsCrashes.class);
        if (mReportsCrashes == null) {
            log.e(LOG_TAG, "ACRA#init called but no ReportsCrashes annotation on Application " + mApplication.getPackageName());
            return;
        }
        SharedPreferences sharedPreferences = ACRA.getACRASharedPreferences();
        try {
            ACRA.checkCrashResources();
            log.d(LOG_TAG, "ACRA is enabled for " + mApplication.getPackageName() + ", intializing...");
            boolean bl2 = !ACRA.shouldDisableACRA(sharedPreferences);
            ErrorReporter errorReporter = new ErrorReporter(mApplication, sharedPreferences, bl2);
            errorReporter.setDefaultReportSenders();
            errorReporterSingleton = errorReporter;
        }
        catch (ACRAConfigurationException aCRAConfigurationException) {
            log.w(LOG_TAG, "Error : ", aCRAConfigurationException);
        }
        mPrefListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
                if (ACRA.PREF_DISABLE_ACRA.equals(string2) || ACRA.PREF_ENABLE_ACRA.equals(string2)) {
                    boolean bl2 = !ACRA.shouldDisableACRA(sharedPreferences);
                    ACRA.getErrorReporter().setEnabled(bl2);
                }
            }
        };
        sharedPreferences.registerOnSharedPreferenceChangeListener(mPrefListener);
    }

    static boolean isDebuggable() {
        PackageManager packageManager = mApplication.getPackageManager();
        try {
            int n2 = packageManager.getApplicationInfo((String)ACRA.mApplication.getPackageName(), (int)0).flags;
            int n3 = n2 & 2;
            boolean bl2 = false;
            if (n3 > 0) {
                bl2 = true;
            }
            return bl2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static void setConfig(ACRAConfiguration aCRAConfiguration) {
        configProxy = aCRAConfiguration;
    }

    public static void setLog(ACRALog aCRALog) {
        log = aCRALog;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldDisableACRA(SharedPreferences sharedPreferences) {
        boolean bl2 = true;
        try {
            if (!sharedPreferences.getBoolean(PREF_ENABLE_ACRA, true)) {
                return sharedPreferences.getBoolean(PREF_DISABLE_ACRA, bl2);
            }
            bl2 = false;
            return sharedPreferences.getBoolean(PREF_DISABLE_ACRA, bl2);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

