/*
 * Decompiled with CFR 0.152.
 */
package javax.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.meta.TypeQualifier;
import javax.annotation.meta.TypeQualifierValidator;
import javax.annotation.meta.When;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@TypeQualifier(applicableTo="Ljava/lang/Number;")
public @interface Nonnegative {
    public When when() default When.ALWAYS;

    public static class Checker
    implements TypeQualifierValidator<Nonnegative> {
        /*
         * Enabled aggressive block sorting
         */
        @Override
        public When forConstantValue(Nonnegative nonnegative, Object object) {
            boolean bl2 = true;
            if (!(object instanceof Number)) {
                return When.NEVER;
            }
            Number number = (Number)object;
            if (number instanceof Long) {
                if (number.longValue() >= 0L) {
                    bl2 = false;
                }
            } else if (number instanceof Double) {
                if (!(number.doubleValue() < 0.0)) {
                    bl2 = false;
                }
            } else if (number instanceof Float) {
                if (!(number.floatValue() < 0.0f)) {
                    bl2 = false;
                }
            } else if (number.intValue() >= 0) {
                bl2 = false;
            }
            if (bl2) {
                return When.NEVER;
            }
            return When.ALWAYS;
        }
    }
}

