/*
 * Decompiled with CFR 0.152.
 */
package fr.castorflex.android.smoothprogressbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import fr.castorflex.android.smoothprogressbar.R;

public class SmoothProgressDrawable
extends Drawable
implements Animatable {
    private static final long FRAME_DURATION = 16L;
    private static final float OFFSET_PER_FRAME = 0.01f;
    private Rect mBounds;
    private int[] mColors;
    private int mColorsIndex;
    private float mCurrentOffset;
    private Interpolator mInterpolator;
    private boolean mMirrorMode;
    private boolean mNewTurn;
    private Paint mPaint;
    private boolean mReversed;
    private boolean mRunning = false;
    private int mSectionsCount;
    private int mSeparatorLength;
    private float mSpeed;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            SmoothProgressDrawable.access$016(SmoothProgressDrawable.this, 0.01f * SmoothProgressDrawable.this.mSpeed);
            if (SmoothProgressDrawable.this.mCurrentOffset >= 1.0f / (float)SmoothProgressDrawable.this.mSectionsCount) {
                SmoothProgressDrawable.access$302(SmoothProgressDrawable.this, true);
                SmoothProgressDrawable.access$002(SmoothProgressDrawable.this, 0.0f);
            }
            SmoothProgressDrawable.this.scheduleSelf(SmoothProgressDrawable.this.mUpdater, 16L + SystemClock.uptimeMillis());
            SmoothProgressDrawable.this.invalidateSelf();
        }
    };

    private SmoothProgressDrawable(Interpolator interpolator, int n2, int n3, int[] nArray, int n4, float f2, boolean bl2, boolean bl3) {
        this.mInterpolator = interpolator;
        this.mSectionsCount = n2;
        this.mSeparatorLength = n3;
        this.mSpeed = f2;
        this.mReversed = bl2;
        this.mColors = nArray;
        this.mColorsIndex = 0;
        this.mMirrorMode = bl3;
        this.mPaint = new Paint();
        this.mPaint.setStrokeWidth((float)n4);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setDither(false);
        this.mPaint.setAntiAlias(false);
    }

    static /* synthetic */ float access$002(SmoothProgressDrawable smoothProgressDrawable, float f2) {
        smoothProgressDrawable.mCurrentOffset = f2;
        return f2;
    }

    static /* synthetic */ float access$016(SmoothProgressDrawable smoothProgressDrawable, float f2) {
        float f3;
        smoothProgressDrawable.mCurrentOffset = f3 = f2 + smoothProgressDrawable.mCurrentOffset;
        return f3;
    }

    static /* synthetic */ boolean access$302(SmoothProgressDrawable smoothProgressDrawable, boolean bl2) {
        smoothProgressDrawable.mNewTurn = bl2;
        return bl2;
    }

    private int decrementColor(int n2) {
        int n3 = n2 - 1;
        if (n3 < 0) {
            n3 = -1 + this.mColors.length;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawLine(Canvas canvas, int n2, float f2, float f3, float f4, float f5, int n3) {
        this.mPaint.setColor(this.mColors[n3]);
        if (!this.mMirrorMode) {
            canvas.drawLine(f2, f3, f4, f5, this.mPaint);
        } else if (this.mReversed) {
            canvas.drawLine(f2 + (float)n2, f3, f4 + (float)n2, f5, this.mPaint);
            canvas.drawLine((float)n2 - f2, f3, (float)n2 - f4, f5, this.mPaint);
        } else {
            canvas.drawLine(f2, f3, f4, f5, this.mPaint);
            canvas.drawLine((float)(n2 * 2) - f2, f3, (float)(n2 * 2) - f4, f5, this.mPaint);
        }
        canvas.save();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawStrokes(Canvas canvas) {
        float f2 = 0.0f;
        int n2 = this.mBounds.width();
        if (this.mMirrorMode) {
            n2 /= 2;
        }
        int n3 = n2 + this.mSeparatorLength + this.mSectionsCount;
        int n4 = this.mBounds.centerY();
        float f3 = 1.0f / (float)this.mSectionsCount;
        if (this.mNewTurn) {
            this.mColorsIndex = this.decrementColor(this.mColorsIndex);
            this.mNewTurn = false;
        }
        int n5 = this.mColorsIndex;
        int n6 = 0;
        while (n6 <= this.mSectionsCount) {
            float f4;
            float f5 = f3 * (float)n6 + this.mCurrentOffset;
            float f6 = Math.max(0.0f, f5 - f3);
            float f7 = (f4 = (float)((int)(Math.abs(this.mInterpolator.getInterpolation(f6) - this.mInterpolator.getInterpolation(Math.min(f5, 1.0f))) * (float)n3))) + f6 < (float)n3 ? Math.min(f4, (float)this.mSeparatorLength) : 0.0f;
            float f8 = f4 > f7 ? f4 - f7 : 0.0f;
            float f9 = f2 + f8;
            if (f9 > f2) {
                this.drawLine(canvas, n2, Math.min((float)n2, f2), n4, Math.min((float)n2, f9), n4, n5);
            }
            f2 = f9 + f7;
            n5 = this.incrementColor(n5);
            ++n6;
        }
        return;
    }

    private int incrementColor(int n2) {
        int n3 = n2 + 1;
        if (n3 >= this.mColors.length) {
            n3 = 0;
        }
        return n3;
    }

    public void draw(Canvas canvas) {
        this.mBounds = this.getBounds();
        canvas.clipRect(this.mBounds);
        int n2 = this.mBounds.width();
        if (this.mReversed) {
            canvas.translate((float)n2, 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        this.drawStrokes(canvas);
    }

    public int getOpacity() {
        return -2;
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void scheduleSelf(Runnable runnable, long l2) {
        this.mRunning = true;
        super.scheduleSelf(runnable, l2);
    }

    public void setAlpha(int n2) {
        this.mPaint.setAlpha(n2);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.scheduleSelf(this.mUpdater, 16L + SystemClock.uptimeMillis());
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
    }

    public static class Builder {
        private int[] mColors;
        private Interpolator mInterpolator;
        private boolean mMirrorMode;
        private boolean mReversed;
        private int mSectionsCount;
        private float mSpeed;
        private int mStrokeSeparatorLength;
        private int mStrokeWidth;

        public Builder(Context context) {
            this.initValues(context);
        }

        private void initValues(Context context) {
            Resources resources = context.getResources();
            this.mInterpolator = new AccelerateInterpolator();
            this.mSectionsCount = resources.getInteger(R.integer.spb_default_sections_count);
            int[] nArray = new int[]{resources.getColor(R.color.spb_default_color)};
            this.mColors = nArray;
            this.mSpeed = Float.parseFloat(resources.getString(R.string.spb_default_speed));
            this.mReversed = resources.getBoolean(R.bool.spb_default_reversed);
            this.mStrokeSeparatorLength = resources.getDimensionPixelSize(R.dimen.spb_default_stroke_separator_length);
            this.mStrokeWidth = resources.getDimensionPixelOffset(R.dimen.spb_default_stroke_width);
        }

        public SmoothProgressDrawable build() {
            return new SmoothProgressDrawable(this.mInterpolator, this.mSectionsCount, this.mStrokeSeparatorLength, this.mColors, this.mStrokeWidth, this.mSpeed, this.mReversed, this.mMirrorMode);
        }

        public Builder color(int n2) {
            this.mColors = new int[]{n2};
            return this;
        }

        public Builder colors(int[] nArray) {
            if (nArray == null || nArray.length == 0) {
                throw new IllegalArgumentException("Your color array must not be empty");
            }
            this.mColors = nArray;
            return this;
        }

        public Builder interpolator(Interpolator interpolator) {
            if (interpolator == null) {
                throw new IllegalArgumentException("Interpolator can't be null");
            }
            this.mInterpolator = interpolator;
            return this;
        }

        public Builder mirrorMode(boolean bl2) {
            this.mMirrorMode = bl2;
            return this;
        }

        public Builder reversed(boolean bl2) {
            this.mReversed = bl2;
            return this;
        }

        public Builder sectionsCount(int n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("SectionsCount must be > 0");
            }
            this.mSectionsCount = n2;
            return this;
        }

        public Builder separatorLength(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("SeparatorLength must be >= 0");
            }
            this.mStrokeSeparatorLength = n2;
            return this;
        }

        public Builder speed(float f2) {
            if (f2 < 0.0f) {
                throw new IllegalArgumentException("Speed must be >= 0");
            }
            this.mSpeed = f2;
            return this;
        }

        public Builder width(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("The width must be >= 0");
            }
            this.mStrokeWidth = n2;
            return this;
        }
    }
}

