/*
 * Decompiled with CFR 0.152.
 */
package fr.castorflex.android.smoothprogressbar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ProgressBar;
import fr.castorflex.android.smoothprogressbar.R;
import fr.castorflex.android.smoothprogressbar.SmoothProgressDrawable;

public class SmoothProgressBar
extends ProgressBar {
    private static final int INTERPOLATOR_ACCELERATE = 0;
    private static final int INTERPOLATOR_ACCELERATEDECELERATE = 2;
    private static final int INTERPOLATOR_DECELERATE = 3;
    private static final int INTERPOLATOR_LINEAR = 1;

    public SmoothProgressBar(Context context) {
        this(context, null);
    }

    public SmoothProgressBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.spbStyle);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SmoothProgressBar(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        AccelerateInterpolator accelerateInterpolator;
        Resources resources = context.getResources();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SmoothProgressBar, n2, 0);
        int n3 = typedArray.getColor(1, resources.getColor(R.color.spb_default_color));
        int n4 = typedArray.getInteger(4, resources.getInteger(R.integer.spb_default_sections_count));
        int n5 = typedArray.getDimensionPixelSize(3, resources.getDimensionPixelSize(R.dimen.spb_default_stroke_separator_length));
        int n6 = typedArray.getDimensionPixelSize(2, resources.getDimensionPixelSize(R.dimen.spb_default_stroke_width));
        String string2 = typedArray.getString(5);
        int n7 = typedArray.getInteger(6, resources.getInteger(R.integer.spb_default_interpolator));
        boolean bl2 = typedArray.getBoolean(7, resources.getBoolean(R.bool.spb_default_reversed));
        boolean bl3 = typedArray.getBoolean(8, resources.getBoolean(R.bool.spb_default_mirror_mode));
        int n8 = typedArray.getResourceId(9, 0);
        typedArray.recycle();
        switch (n7) {
            default: {
                accelerateInterpolator = new AccelerateInterpolator();
                break;
            }
            case 2: {
                accelerateInterpolator = new AccelerateDecelerateInterpolator();
                break;
            }
            case 3: {
                accelerateInterpolator = new DecelerateInterpolator();
                break;
            }
            case 1: {
                accelerateInterpolator = new LinearInterpolator();
            }
        }
        int[] nArray = null;
        if (n8 != 0) {
            nArray = resources.getIntArray(n8);
        }
        SmoothProgressDrawable.Builder builder = new SmoothProgressDrawable.Builder(context);
        SmoothProgressDrawable.Builder builder2 = builder.interpolator((Interpolator)accelerateInterpolator).sectionsCount(n4).separatorLength(n5).width(n6).reversed(bl2).mirrorMode(bl3);
        if (string2 != null) {
            builder2.speed(Float.parseFloat(string2));
        }
        if (nArray != null && nArray.length > 0) {
            builder2.colors(nArray);
        } else {
            builder2.color(n3);
        }
        this.setIndeterminateDrawable(builder2.build());
    }
}

