/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class EventHandler {
    private final int hashCode;
    private final Method method;
    private final Object target;
    private boolean valid = true;

    EventHandler(Object object, Method method) {
        if (object == null) {
            throw new NullPointerException("EventHandler target cannot be null.");
        }
        if (method == null) {
            throw new NullPointerException("EventHandler method cannot be null.");
        }
        this.target = object;
        this.method = method;
        method.setAccessible(true);
        this.hashCode = 31 * (31 + method.hashCode()) + object.hashCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block6: {
            block5: {
                if (this == object) break block5;
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                EventHandler eventHandler = (EventHandler)object;
                if (!this.method.equals(eventHandler.method) || this.target != eventHandler.target) break block6;
            }
            return true;
        }
        return false;
    }

    public void handleEvent(Object object) throws InvocationTargetException {
        if (!this.valid) {
            throw new IllegalStateException(this.toString() + " has been invalidated and can no longer handle events.");
        }
        try {
            this.method.invoke(this.target, object);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)invocationTargetException.getCause();
            }
            throw invocationTargetException;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "[EventHandler " + this.method + "]";
    }
}

