/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto;

import com.squareup.otto.DeadEvent;
import com.squareup.otto.EventHandler;
import com.squareup.otto.EventProducer;
import com.squareup.otto.HandlerFinder;
import com.squareup.otto.ThreadEnforcer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class Bus {
    public static final String DEFAULT_IDENTIFIER = "default";
    private final ThreadEnforcer enforcer;
    private final ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>> eventsToDispatch;
    private final Map<Class<?>, Set<Class<?>>> flattenHierarchyCache;
    private final HandlerFinder handlerFinder;
    private final ConcurrentMap<Class<?>, Set<EventHandler>> handlersByType = new ConcurrentHashMap();
    private final String identifier;
    private final ThreadLocal<Boolean> isDispatching;
    private final ConcurrentMap<Class<?>, EventProducer> producersByType = new ConcurrentHashMap();

    public Bus() {
        this(DEFAULT_IDENTIFIER);
    }

    public Bus(ThreadEnforcer threadEnforcer) {
        this(threadEnforcer, DEFAULT_IDENTIFIER);
    }

    public Bus(ThreadEnforcer threadEnforcer, String string2) {
        this(threadEnforcer, string2, HandlerFinder.ANNOTATED);
    }

    Bus(ThreadEnforcer threadEnforcer, String string2, HandlerFinder handlerFinder) {
        this.eventsToDispatch = new ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>>(){

            @Override
            protected ConcurrentLinkedQueue<EventWithHandler> initialValue() {
                return new ConcurrentLinkedQueue<EventWithHandler>();
            }
        };
        this.isDispatching = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        this.flattenHierarchyCache = new HashMap();
        this.enforcer = threadEnforcer;
        this.identifier = string2;
        this.handlerFinder = handlerFinder;
    }

    public Bus(String string2) {
        this(ThreadEnforcer.MAIN, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dispatchProducerResultToHandler(EventHandler eventHandler, EventProducer eventProducer) {
        Object object;
        try {
            Object object2;
            object = object2 = eventProducer.produceEvent();
            if (object == null) {
                return;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Bus.throwRuntimeException("Producer " + eventProducer + " threw an exception.", invocationTargetException);
            return;
        }
        this.dispatch(object, eventHandler);
    }

    private Set<Class<?>> getClassesFor(Class<?> clazz) {
        LinkedList linkedList = new LinkedList();
        HashSet hashSet = new HashSet();
        linkedList.add(clazz);
        while (!linkedList.isEmpty()) {
            Class clazz2 = (Class)linkedList.remove(0);
            hashSet.add(clazz2);
            Class clazz3 = clazz2.getSuperclass();
            if (clazz3 == null) continue;
            linkedList.add(clazz3);
        }
        return hashSet;
    }

    private static void throwRuntimeException(String string2, InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getCause();
        if (throwable != null) {
            throw new RuntimeException(string2, throwable);
        }
        throw new RuntimeException(string2);
    }

    protected void dispatch(Object object, EventHandler eventHandler) {
        try {
            eventHandler.handleEvent(object);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Bus.throwRuntimeException("Could not dispatch event: " + object.getClass() + " to handler " + eventHandler, invocationTargetException);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dispatchQueuedEvents() {
        if (this.isDispatching.get().booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        while (true) {
            EventWithHandler eventWithHandler;
            try {
                eventWithHandler = this.eventsToDispatch.get().poll();
                if (eventWithHandler == null) {
                    this.isDispatching.set(false);
                    return;
                }
            }
            catch (Throwable throwable) {
                this.isDispatching.set(false);
                throw throwable;
            }
            {
                if (!eventWithHandler.handler.isValid()) continue;
                this.dispatch(eventWithHandler.event, eventWithHandler.handler);
                continue;
            }
            break;
        }
    }

    protected void enqueueEvent(Object object, EventHandler eventHandler) {
        this.eventsToDispatch.get().offer(new EventWithHandler(object, eventHandler));
    }

    Set<Class<?>> flattenHierarchy(Class<?> clazz) {
        Set<Class<?>> set = this.flattenHierarchyCache.get(clazz);
        if (set == null) {
            set = this.getClassesFor(clazz);
            this.flattenHierarchyCache.put(clazz, set);
        }
        return set;
    }

    Set<EventHandler> getHandlersForEventType(Class<?> clazz) {
        return (Set)this.handlersByType.get(clazz);
    }

    EventProducer getProducerForEventType(Class<?> clazz) {
        return (EventProducer)this.producersByType.get(clazz);
    }

    public void post(Object object) {
        if (object == null) {
            throw new NullPointerException("Event to post must not be null.");
        }
        this.enforcer.enforce(this);
        Set<Class<?>> set = this.flattenHierarchy(object.getClass());
        boolean bl2 = false;
        Iterator<Class<?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Set<EventHandler> set2 = this.getHandlersForEventType(iterator.next());
            if (set2 == null || set2.isEmpty()) continue;
            bl2 = true;
            Iterator<EventHandler> iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                this.enqueueEvent(object, iterator2.next());
            }
        }
        if (!bl2 && !(object instanceof DeadEvent)) {
            this.post(new DeadEvent(this, object));
        }
        this.dispatchQueuedEvents();
    }

    public void register(Object object) {
        if (object == null) {
            throw new NullPointerException("Object to register must not be null.");
        }
        this.enforcer.enforce(this);
        Map<Class<?>, EventProducer> map = this.handlerFinder.findAllProducers(object);
        for (Class<?> clazz : map.keySet()) {
            EventProducer eventProducer;
            EventProducer eventProducer2 = this.producersByType.putIfAbsent(clazz, eventProducer = map.get(clazz));
            if (eventProducer2 != null) {
                throw new IllegalArgumentException("Producer method for type " + clazz + " found on type " + eventProducer.target.getClass() + ", but already registered by type " + eventProducer2.target.getClass() + ".");
            }
            Set set = (Set)this.handlersByType.get(clazz);
            if (set == null || set.isEmpty()) continue;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.dispatchProducerResultToHandler((EventHandler)iterator.next(), eventProducer);
            }
        }
        Map<Class<?>, Set<EventHandler>> map2 = this.handlerFinder.findAllSubscribers(object);
        for (Class<?> clazz : map2.keySet()) {
            CopyOnWriteArraySet<EventHandler> copyOnWriteArraySet;
            CopyOnWriteArraySet<EventHandler> copyOnWriteArraySet2 = (CopyOnWriteArraySet<EventHandler>)this.handlersByType.get(clazz);
            if (copyOnWriteArraySet2 == null && (copyOnWriteArraySet2 = (Set)this.handlersByType.putIfAbsent(clazz, copyOnWriteArraySet = new CopyOnWriteArraySet<EventHandler>())) == null) {
                copyOnWriteArraySet2 = copyOnWriteArraySet;
            }
            copyOnWriteArraySet2.addAll(map2.get(clazz));
        }
        block3: for (Map.Entry<Class<?>, Set<EventHandler>> entry : map2.entrySet()) {
            Class<?> clazz = entry.getKey();
            EventProducer eventProducer = (EventProducer)this.producersByType.get(clazz);
            if (eventProducer == null || !eventProducer.isValid()) continue;
            for (EventHandler eventHandler : entry.getValue()) {
                if (!eventProducer.isValid()) continue block3;
                if (!eventHandler.isValid()) continue;
                this.dispatchProducerResultToHandler(eventHandler, eventProducer);
            }
        }
    }

    public String toString() {
        return "[Bus \"" + this.identifier + "\"]";
    }

    public void unregister(Object object) {
        if (object == null) {
            throw new NullPointerException("Object to unregister must not be null.");
        }
        this.enforcer.enforce(this);
        for (Map.Entry<Class<?>, EventProducer> entry : this.handlerFinder.findAllProducers(object).entrySet()) {
            Class<?> clazz = entry.getKey();
            EventProducer eventProducer = this.getProducerForEventType(clazz);
            EventProducer eventProducer2 = entry.getValue();
            if (eventProducer2 == null || !eventProducer2.equals(eventProducer)) {
                throw new IllegalArgumentException("Missing event producer for an annotated method. Is " + object.getClass() + " registered?");
            }
            ((EventProducer)this.producersByType.remove(clazz)).invalidate();
        }
        for (Map.Entry<Class<?>, Set<EventHandler>> entry : this.handlerFinder.findAllSubscribers(object).entrySet()) {
            Set<EventHandler> set = this.getHandlersForEventType(entry.getKey());
            Collection collection = entry.getValue();
            if (set == null || !set.containsAll(collection)) {
                throw new IllegalArgumentException("Missing event handler for an annotated method. Is " + object.getClass() + " registered?");
            }
            for (EventHandler eventHandler : set) {
                if (!collection.contains(eventHandler)) continue;
                eventHandler.invalidate();
            }
            set.removeAll(collection);
        }
    }

    static class EventWithHandler {
        final Object event;
        final EventHandler handler;

        public EventWithHandler(Object object, EventHandler eventHandler) {
            this.event = object;
            this.handler = eventHandler;
        }
    }
}

