/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto;

import com.squareup.otto.EventHandler;
import com.squareup.otto.EventProducer;
import com.squareup.otto.Produce;
import com.squareup.otto.Subscribe;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class AnnotatedHandlerFinder {
    private static final Map<Class<?>, Map<Class<?>, Method>> PRODUCERS_CACHE = new HashMap();
    private static final Map<Class<?>, Map<Class<?>, Set<Method>>> SUBSCRIBERS_CACHE = new HashMap();

    private AnnotatedHandlerFinder() {
    }

    static Map<Class<?>, EventProducer> findAllProducers(Object object) {
        Map<Class<?>, Method> map;
        Class<?> clazz = object.getClass();
        HashMap hashMap = new HashMap();
        if (!PRODUCERS_CACHE.containsKey(clazz)) {
            AnnotatedHandlerFinder.loadAnnotatedMethods(clazz);
        }
        if (!(map = PRODUCERS_CACHE.get(clazz)).isEmpty()) {
            for (Map.Entry<Class<?>, Method> entry : map.entrySet()) {
                EventProducer eventProducer = new EventProducer(object, entry.getValue());
                hashMap.put(entry.getKey(), eventProducer);
            }
        }
        return hashMap;
    }

    static Map<Class<?>, Set<EventHandler>> findAllSubscribers(Object object) {
        Map<Class<?>, Set<Method>> map;
        Class<?> clazz = object.getClass();
        HashMap hashMap = new HashMap();
        if (!SUBSCRIBERS_CACHE.containsKey(clazz)) {
            AnnotatedHandlerFinder.loadAnnotatedMethods(clazz);
        }
        if (!(map = SUBSCRIBERS_CACHE.get(clazz)).isEmpty()) {
            for (Map.Entry<Class<?>, Set<Method>> entry : map.entrySet()) {
                HashSet<EventHandler> hashSet = new HashSet<EventHandler>();
                Iterator<Method> iterator = entry.getValue().iterator();
                while (iterator.hasNext()) {
                    hashSet.add(new EventHandler(object, iterator.next()));
                }
                hashMap.put(entry.getKey(), hashSet);
            }
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void loadAnnotatedMethods(Class<?> clazz) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n2 = methodArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                PRODUCERS_CACHE.put(clazz, hashMap2);
                SUBSCRIBERS_CACHE.put(clazz, hashMap);
                return;
            }
            Method method = methodArray[n3];
            if (method.isAnnotationPresent(Subscribe.class)) {
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation but requires " + classArray.length + " arguments.  Methods must require a single argument.");
                }
                Class<?> clazz2 = classArray[0];
                if (clazz2.isInterface()) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation on " + clazz2 + " which is an interface.  Subscription must be on a concrete class type.");
                }
                if ((1 & method.getModifiers()) == 0) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation on " + clazz2 + " but is not 'public'.");
                }
                HashSet<Method> hashSet = (HashSet<Method>)hashMap.get(clazz2);
                if (hashSet == null) {
                    hashSet = new HashSet<Method>();
                    hashMap.put(clazz2, hashSet);
                }
                hashSet.add(method);
            } else if (method.isAnnotationPresent(Produce.class)) {
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 0) {
                    throw new IllegalArgumentException("Method " + method + "has @Produce annotation but requires " + classArray.length + " arguments.  Methods must require zero arguments.");
                }
                if (method.getReturnType() == Void.class) {
                    throw new IllegalArgumentException("Method " + method + " has a return type of void.  Must declare a non-void type.");
                }
                Class<?> clazz3 = method.getReturnType();
                if (clazz3.isInterface()) {
                    throw new IllegalArgumentException("Method " + method + " has @Produce annotation on " + clazz3 + " which is an interface.  Producers must return a concrete class type.");
                }
                if (clazz3.equals(Void.TYPE)) {
                    throw new IllegalArgumentException("Method " + method + " has @Produce annotation but has no return type.");
                }
                if ((1 & method.getModifiers()) == 0) {
                    throw new IllegalArgumentException("Method " + method + " has @Produce annotation on " + clazz3 + " but is not 'public'.");
                }
                if (hashMap2.containsKey(clazz3)) {
                    throw new IllegalArgumentException("Producer for type " + clazz3 + " has already been registered.");
                }
                hashMap2.put(clazz3, method);
            }
            ++n3;
        }
    }
}

