/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.utility;

import java.util.BitSet;

public class IntAllocator {
    private final BitSet freeSet;
    private final int hiRange;
    private int lastIndex = 0;
    private final int loRange;
    private final int numberOfBits;

    public IntAllocator(int n2, int n3) {
        this.loRange = n2;
        this.hiRange = n3 + 1;
        this.numberOfBits = this.hiRange - this.loRange;
        this.freeSet = new BitSet(this.numberOfBits);
        this.freeSet.set(0, this.numberOfBits);
    }

    private void stringInterval(StringBuilder stringBuilder, int n2, int n3) {
        stringBuilder.append(n2 + this.loRange);
        if (n2 + 1 != n3) {
            stringBuilder.append("..").append(n3 - 1 + this.loRange);
        }
    }

    public int allocate() {
        int n2 = this.freeSet.nextSetBit(this.lastIndex);
        if (n2 < 0) {
            n2 = this.freeSet.nextSetBit(0);
        }
        if (n2 < 0) {
            return -1;
        }
        this.lastIndex = n2;
        this.freeSet.clear(n2);
        return n2 + this.loRange;
    }

    public void free(int n2) {
        this.freeSet.set(n2 - this.loRange);
    }

    public boolean reserve(int n2) {
        int n3 = n2 - this.loRange;
        if (this.freeSet.get(n3)) {
            this.freeSet.clear(n3);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("IntAllocator{allocated = [");
        int n2 = this.freeSet.nextClearBit(0);
        if (n2 < this.numberOfBits) {
            int n3 = this.freeSet.nextSetBit(n2 + 1);
            if (n3 < 0) {
                n3 = this.numberOfBits;
            }
            this.stringInterval(stringBuilder, n2, n3);
            int n4 = this.freeSet.nextClearBit(n3 + 1);
            while (n4 < this.numberOfBits) {
                int n5 = this.freeSet.nextSetBit(n4);
                if (n5 < 0) {
                    n5 = this.numberOfBits;
                }
                this.stringInterval(stringBuilder.append(", "), n4, n5);
                int n6 = n5;
                n4 = this.freeSet.nextClearBit(n6 + 1);
            }
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }
}

