/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.utility;

import java.util.concurrent.TimeoutException;

public class BlockingCell<T> {
    private static final long INFINITY = -1L;
    private static final long NANOS_IN_MILLI = 1000000L;
    private boolean _filled = false;
    private T _value;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T get() throws InterruptedException {
        synchronized (this) {
            while (true) {
                if (this._filled) {
                    T t2 = this._value;
                    return t2;
                }
                this.wait();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T get(long l2) throws InterruptedException, TimeoutException {
        synchronized (this) {
            T t2;
            if (l2 == -1L) {
                T t3;
                t2 = t3 = this.get();
            } else {
                long l3;
                if (l2 < 0L) {
                    throw new AssertionError((Object)"Timeout cannot be less than zero");
                }
                long l4 = l2 + System.currentTimeMillis();
                while (!this._filled && (l3 = System.currentTimeMillis()) < l4) {
                    this.wait(l4 - l3);
                }
                if (!this._filled) {
                    throw new TimeoutException();
                }
                t2 = this._value;
            }
            return t2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(T t2) {
        synchronized (this) {
            if (this._filled) {
                throw new AssertionError((Object)"BlockingCell can only be set once");
            }
            this._value = t2;
            this._filled = true;
            this.notifyAll();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setIfUnset(T t2) {
        synchronized (this) {
            block4: {
                boolean bl2 = this._filled;
                if (!bl2) break block4;
                return false;
            }
            this.set(t2);
            return true;
        }
    }

    public T uninterruptibleGet() {
        synchronized (this) {
            while (true) {
                T t2;
                try {
                    t2 = this.get();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                return t2;
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T uninterruptibleGet(int n2) throws TimeoutException {
        synchronized (this) {
            long l2 = System.nanoTime() / 1000000L;
            long l3 = l2 + (long)n2;
            while (true) {
                long l4 = l3 - l2;
                try {
                    T t2 = this.get(l4);
                    return t2;
                }
                catch (InterruptedException interruptedException) {
                    if ((long)n2 == -1L || (l2 = System.nanoTime() / 1000000L) < l3) continue;
                    throw new TimeoutException();
                }
                break;
            }
        }
    }
}

