/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.jsonrpc;

import com.rabbitmq.tools.json.JSONUtil;
import com.rabbitmq.tools.jsonrpc.ProcedureDescription;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ServiceDescription {
    public static final String JSON_RPC_VERSION = "1.1";
    public String help;
    public String id;
    public String name;
    private Map<String, ProcedureDescription> procedures;
    public String summary;
    public String version;

    public ServiceDescription() {
    }

    public ServiceDescription(Class<?> clazz) {
        this.procedures = new HashMap<String, ProcedureDescription>();
        Method[] methodArray = clazz.getMethods();
        int n2 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addProcedure(new ProcedureDescription(methodArray[i2]));
        }
    }

    public ServiceDescription(Map<String, Object> map) {
        JSONUtil.tryFill(this, map);
    }

    private void addProcedure(ProcedureDescription procedureDescription) {
        this.procedures.put(procedureDescription.name + "/" + procedureDescription.arity(), procedureDescription);
    }

    public ProcedureDescription getProcedure(String string2, int n2) {
        ProcedureDescription procedureDescription = this.procedures.get(string2 + "/" + n2);
        if (procedureDescription == null) {
            throw new IllegalArgumentException("Procedure not found: " + string2 + ", arity " + n2);
        }
        return procedureDescription;
    }

    public Collection<ProcedureDescription> getProcs() {
        return this.procedures.values();
    }

    public void setProcs(Collection<Map<String, Object>> collection) {
        this.procedures = new HashMap<String, ProcedureDescription>();
        Iterator<Map<String, Object>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addProcedure(new ProcedureDescription(iterator.next()));
        }
    }
}

