/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.jsonrpc;

import com.rabbitmq.tools.json.JSONUtil;
import com.rabbitmq.tools.jsonrpc.ParameterDescription;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ProcedureDescription {
    public String help;
    public boolean idempotent;
    private Method method;
    public String name;
    private ParameterDescription[] params;
    private String returnType;
    public String summary;

    public ProcedureDescription() {
    }

    public ProcedureDescription(Method method) {
        this.method = method;
        this.name = method.getName();
        this.summary = "";
        this.help = "";
        this.idempotent = false;
        Class<?>[] classArray = method.getParameterTypes();
        this.params = new ParameterDescription[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            this.params[i2] = new ParameterDescription(i2, classArray[i2]);
        }
        this.returnType = ParameterDescription.lookup(method.getReturnType());
    }

    public ProcedureDescription(Map<String, Object> map) {
        JSONUtil.tryFill(this, map);
        List list = (List)map.get("params");
        this.params = new ParameterDescription[list.size()];
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ParameterDescription parameterDescription = new ParameterDescription((Map)iterator.next());
            ParameterDescription[] parameterDescriptionArray = this.params;
            int n3 = n2 + 1;
            parameterDescriptionArray[n2] = parameterDescription;
            n2 = n3;
        }
    }

    public int arity() {
        if (this.params == null) {
            return 0;
        }
        return this.params.length;
    }

    public ParameterDescription[] getParams() {
        return this.params;
    }

    public String getReturn() {
        return this.returnType;
    }

    public Method internal_getMethod() {
        return this.method;
    }

    public ParameterDescription[] internal_getParams() {
        return this.params;
    }

    public void setReturn(String string2) {
        this.returnType = string2;
    }
}

