/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.jsonrpc;

import com.rabbitmq.tools.json.JSONUtil;
import java.util.Collection;
import java.util.Map;

public class ParameterDescription {
    public String name;
    public String type;

    public ParameterDescription() {
    }

    public ParameterDescription(int n2, Class<?> clazz) {
        this.name = "param" + n2;
        this.type = ParameterDescription.lookup(clazz);
    }

    public ParameterDescription(Map<String, Object> map) {
        JSONUtil.tryFill(this, map);
    }

    public static String lookup(Class<?> clazz) {
        if (clazz == Void.class) {
            return "nil";
        }
        if (clazz == Boolean.class) {
            return "bit";
        }
        if (clazz == Integer.class) {
            return "num";
        }
        if (clazz == Double.class) {
            return "num";
        }
        if (clazz == String.class) {
            return "str";
        }
        if (clazz.isArray()) {
            return "arr";
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return "obj";
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return "arr";
        }
        return "any";
    }
}

