/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.jsonrpc;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.StringRpcServer;
import com.rabbitmq.tools.json.JSONReader;
import com.rabbitmq.tools.json.JSONWriter;
import com.rabbitmq.tools.jsonrpc.ServiceDescription;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonRpcServer
extends StringRpcServer {
    public Class<?> interfaceClass;
    public Object interfaceInstance;
    public ServiceDescription serviceDescription;

    public JsonRpcServer(Channel channel, Class<?> clazz, Object object) throws IOException {
        super(channel);
        this.init(clazz, object);
    }

    public JsonRpcServer(Channel channel, String string2, Class<?> clazz, Object object) throws IOException {
        super(channel, string2);
        this.init(clazz, object);
    }

    public static String errorResponse(Object object, int n2, String string2, Object object2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", "JSONRPCError");
        hashMap.put("code", n2);
        hashMap.put("message", string2);
        hashMap.put("error", object2);
        return JsonRpcServer.response(object, "error", hashMap);
    }

    private void init(Class<?> clazz, Object object) {
        this.interfaceClass = clazz;
        this.interfaceInstance = object;
        this.serviceDescription = new ServiceDescription(clazz);
    }

    public static String response(Object object, String string2, Object object2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("version", "1.1");
        if (object != null) {
            hashMap.put("id", object);
        }
        hashMap.put(string2, object2);
        return new JSONWriter().write(hashMap);
    }

    public static String resultResponse(Object object, Object object2) {
        return JsonRpcServer.response(object, "result", object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doCall(String string2) {
        Object[] objectArray;
        String string3;
        Object v2;
        try {
            Map map = (Map)new JSONReader().read(string2);
            if (map == null) {
                return JsonRpcServer.errorResponse(null, 400, "Bad Request", null);
            }
            if (!"1.1".equals(map.get("version"))) {
                return JsonRpcServer.errorResponse(null, 505, "JSONRPC version not supported", null);
            }
            v2 = map.get("id");
            string3 = (String)map.get("method");
            objectArray = ((List)map.get("params")).toArray();
        }
        catch (ClassCastException classCastException) {
            return JsonRpcServer.errorResponse(null, 400, "Bad Request", null);
        }
        if (string3.equals("system.describe")) {
            return JsonRpcServer.resultResponse(v2, this.serviceDescription);
        }
        if (string3.startsWith("system.")) {
            return JsonRpcServer.errorResponse(v2, 403, "System methods forbidden", null);
        }
        try {
            Object object = this.matchingMethod(string3, objectArray).invoke(this.interfaceInstance, objectArray);
            return JsonRpcServer.resultResponse(v2, object);
        }
        catch (Throwable throwable) {
            return JsonRpcServer.errorResponse(v2, 500, "Internal Server Error", throwable);
        }
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    @Override
    public String handleStringCall(String string2, AMQP.BasicProperties basicProperties) {
        return this.doCall(string2);
    }

    public Method matchingMethod(String string2, Object[] objectArray) {
        return this.serviceDescription.getProcedure(string2, objectArray.length).internal_getMethod();
    }
}

