/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.jsonrpc;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.RpcClient;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.tools.json.JSONReader;
import com.rabbitmq.tools.json.JSONWriter;
import com.rabbitmq.tools.jsonrpc.JsonRpcException;
import com.rabbitmq.tools.jsonrpc.ParameterDescription;
import com.rabbitmq.tools.jsonrpc.ServiceDescription;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class JsonRpcClient
extends RpcClient
implements InvocationHandler {
    private ServiceDescription serviceDescription;

    public JsonRpcClient(Channel channel, String string2, String string3) throws IOException, JsonRpcException, TimeoutException {
        this(channel, string2, string3, -1);
    }

    public JsonRpcClient(Channel channel, String string2, String string3, int n2) throws IOException, JsonRpcException, TimeoutException {
        super(channel, string2, string3, n2);
        this.retrieveServiceDescription();
    }

    public static Object checkReply(Map<String, Object> map) throws JsonRpcException {
        if (map.containsKey("error")) {
            throw new JsonRpcException((Map)map.get("error"));
        }
        return map.get("result");
    }

    public static Object coerce(String string2, String string3) throws NumberFormatException {
        if ("bit".equals(string3)) {
            if (Boolean.getBoolean(string2)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if ("num".equals(string3)) {
            try {
                Integer n2 = new Integer(string2);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return new Double(string2);
            }
        }
        if ("str".equals(string3)) {
            return string2;
        }
        if ("arr".equals(string3) || "obj".equals(string3) || "any".equals(string3)) {
            return new JSONReader().read(string2);
        }
        if ("nil".equals(string3)) {
            return null;
        }
        throw new IllegalArgumentException("Bad type: " + string3);
    }

    private void retrieveServiceDescription() throws IOException, JsonRpcException, TimeoutException {
        this.serviceDescription = new ServiceDescription((Map)this.call("system.describe", null));
    }

    public Object call(String string2, Object[] objectArray) throws IOException, JsonRpcException, TimeoutException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", null);
        hashMap.put("method", string2);
        hashMap.put("version", "1.1");
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        hashMap.put("params", objectArray);
        String string3 = new JSONWriter().write(hashMap);
        try {
            String string4 = this.stringCall(string3);
            Object object = JsonRpcClient.checkReply((Map)new JSONReader().read(string4));
            return object;
        }
        catch (ShutdownSignalException shutdownSignalException) {
            throw new IOException(shutdownSignalException.getMessage());
        }
    }

    public Object call(String[] stringArray) throws NumberFormatException, IOException, JsonRpcException, TimeoutException {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("First string argument must be method name");
        }
        String string2 = stringArray[0];
        int n2 = -1 + stringArray.length;
        ParameterDescription[] parameterDescriptionArray = this.serviceDescription.getProcedure(string2, n2).getParams();
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < parameterDescriptionArray.length; ++i2) {
            objectArray[i2] = JsonRpcClient.coerce(stringArray[i2 + 1], parameterDescriptionArray[i2].type);
        }
        return this.call(string2, objectArray);
    }

    public Object createProxy(Class<?> clazz) throws IllegalArgumentException {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        return this.call(method.getName(), objectArray);
    }
}

