/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.json;

import com.rabbitmq.tools.json.JSONSerializable;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class JSONWriter {
    static char[] hex = "0123456789ABCDEF".toCharArray();
    private StringBuilder buf = new StringBuilder();
    private int indentLevel = 0;
    private boolean indentMode = false;

    public JSONWriter() {
    }

    public JSONWriter(boolean bl2) {
        this.indentMode = bl2;
    }

    private void add(char c2) {
        this.buf.append(c2);
    }

    private void add(Object object) {
        this.buf.append(object);
    }

    private void add(String string2, Object object) {
        this.add('\"');
        this.add(string2);
        this.add("\":");
        this.value(object);
    }

    private void array(Object object) {
        this.add('[');
        int n2 = Array.getLength(object);
        if (n2 > 0) {
            this.value(Array.get(object, 0));
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            this.add(',');
            this.value(Array.get(object, i2));
        }
        this.add(']');
    }

    private void array(Iterator<?> iterator) {
        this.add('[');
        if (iterator.hasNext()) {
            this.value(iterator.next());
        }
        while (iterator.hasNext()) {
            this.add(',');
            this.value(iterator.next());
        }
        this.add(']');
    }

    private void bean(Object object) {
        this.writeLimited(object.getClass(), object, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void bool(boolean bl2) {
        String string2 = bl2 ? "true" : "false";
        this.add(string2);
    }

    private void map(Map<String, Object> map) {
        this.add('{');
        this.indentLevel = 2 + this.indentLevel;
        this.newline();
        Iterator<String> iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            this.mapEntry(iterator.next(), map);
        }
        while (iterator.hasNext()) {
            this.add(',');
            this.newline();
            String string2 = iterator.next();
            this.value(string2);
            this.add(':');
            this.value(map.get(string2));
        }
        this.indentLevel = -2 + this.indentLevel;
        this.newline();
        this.add('}');
    }

    private void mapEntry(Object object, Map<String, Object> map) {
        this.value(object);
        this.add(':');
        this.value(map.get(object));
    }

    private void newline() {
        if (this.indentMode) {
            this.add('\n');
            for (int i2 = 0; i2 < this.indentLevel; ++i2) {
                this.add(' ');
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void string(Object object) {
        this.add('\"');
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(object.toString());
        char c2 = stringCharacterIterator.first();
        while (true) {
            if (c2 == '\uffff') {
                this.add('\"');
                return;
            }
            if (c2 == '\"') {
                this.add("\\\"");
            } else if (c2 == '\\') {
                this.add("\\\\");
            } else if (c2 == '/') {
                this.add("\\/");
            } else if (c2 == '\b') {
                this.add("\\b");
            } else if (c2 == '\f') {
                this.add("\\f");
            } else if (c2 == '\n') {
                this.add("\\n");
            } else if (c2 == '\r') {
                this.add("\\r");
            } else if (c2 == '\t') {
                this.add("\\t");
            } else if (Character.isISOControl(c2)) {
                this.unicode(c2);
            } else {
                this.add(c2);
            }
            c2 = stringCharacterIterator.next();
        }
    }

    private void unicode(char n2) {
        this.add("\\u");
        int n3 = n2;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n4 = (0xF000 & n3) >> 12;
            this.add(hex[n4]);
            n3 <<= 4;
        }
    }

    private void value(Object object) {
        if (object == null) {
            this.add("null");
            return;
        }
        if (object instanceof JSONSerializable) {
            ((JSONSerializable)object).jsonSerialize(this);
            return;
        }
        if (object instanceof Class) {
            this.string(object);
            return;
        }
        if (object instanceof Boolean) {
            this.bool((Boolean)object);
            return;
        }
        if (object instanceof Number) {
            this.add(object);
            return;
        }
        if (object instanceof String) {
            this.string(object);
            return;
        }
        if (object instanceof Character) {
            this.string(object);
            return;
        }
        if (object instanceof Map) {
            this.map((Map)object);
            return;
        }
        if (object.getClass().isArray()) {
            this.array(object);
            return;
        }
        if (object instanceof Collection) {
            this.array(((Collection)object).iterator());
            return;
        }
        this.bean(object);
    }

    public boolean getIndentMode() {
        return this.indentMode;
    }

    public void setIndentMode(boolean bl2) {
        this.indentMode = bl2;
    }

    public Object write(double d2) {
        return this.write(new Double(d2));
    }

    public String write(char c2) {
        return this.write(new Character(c2));
    }

    public String write(long l2) {
        return this.write(new Long(l2));
    }

    public String write(Object object) {
        this.buf.setLength(0);
        this.value(object);
        return this.buf.toString();
    }

    public String write(boolean bl2) {
        return this.write((Object)bl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeLimited(Class<?> clazz, Object object, String[] stringArray) {
        BeanInfo beanInfo;
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>();
            for (String string2 : stringArray) {
                hashSet.add(string2);
            }
        }
        this.add('{');
        this.indentLevel = 2 + this.indentLevel;
        this.newline();
        try {
            BeanInfo beanInfo2;
            beanInfo = beanInfo2 = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            beanInfo = null;
        }
        boolean bl2 = false;
        if (beanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                Method method;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i2];
                String string3 = propertyDescriptor.getName();
                if (hashSet == null && string3.equals("class") || hashSet != null && !hashSet.contains(string3) || (method = propertyDescriptor.getReadMethod()) == null || Modifier.isStatic(method.getModifiers())) continue;
                try {
                    Object object2 = method.invoke(object, (Object[])null);
                    if (bl2) {
                        this.add(',');
                        this.newline();
                    }
                    bl2 = true;
                    this.add(string3, object2);
                    continue;
                }
                catch (Exception exception) {}
            }
        }
        Field[] fieldArray = object.getClass().getDeclaredFields();
        int n2 = 0;
        while (true) {
            if (n2 >= fieldArray.length) {
                this.indentLevel = -2 + this.indentLevel;
                this.newline();
                this.add('}');
                return;
            }
            Field field = fieldArray[n2];
            int n3 = field.getModifiers();
            String string4 = field.getName();
            if ((hashSet == null || hashSet.contains(string4)) && !Modifier.isStatic(n3)) {
                try {
                    Object object3 = field.get(object);
                    if (bl2) {
                        this.add(',');
                        this.newline();
                    }
                    bl2 = true;
                    this.add(string4, object3);
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }
}

