/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.json;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JSONReader {
    private static final Object ARRAY_END;
    private static final Object COLON;
    private static final Object COMMA;
    private static final Object OBJECT_END;
    private static Map<Character, Character> escapes;
    private StringBuilder buf = new StringBuilder();
    private char c;
    private CharacterIterator it;
    private Object token;

    static {
        OBJECT_END = new Object();
        ARRAY_END = new Object();
        COLON = new Object();
        COMMA = new Object();
        escapes = new HashMap<Character, Character>();
        escapes.put(new Character('\"'), new Character('\"'));
        escapes.put(new Character('\\'), new Character('\\'));
        escapes.put(new Character('/'), new Character('/'));
        escapes.put(new Character('b'), new Character('\b'));
        escapes.put(new Character('f'), new Character('\f'));
        escapes.put(new Character('n'), new Character('\n'));
        escapes.put(new Character('r'), new Character('\r'));
        escapes.put(new Character('t'), new Character('\t'));
    }

    private void add() {
        this.add(this.c);
    }

    private void add(char c2) {
        this.buf.append(c2);
        this.next();
    }

    private void addDigits() {
        while (Character.isDigit(this.c)) {
            this.add();
        }
    }

    private Object array() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = this.read();
        while (this.token != ARRAY_END) {
            arrayList.add(object);
            if (this.read() != COMMA) continue;
            object = this.read();
        }
        return arrayList;
    }

    private char next() {
        this.c = this.it.next();
        return this.c;
    }

    private Object number() {
        this.buf.setLength(0);
        if (this.c == '-') {
            this.add();
        }
        this.addDigits();
        if (this.c == '.') {
            this.add();
            this.addDigits();
        }
        if (this.c == 'e' || this.c == 'E') {
            this.add();
            if (this.c == '+' || this.c == '-') {
                this.add();
            }
            this.addDigits();
        }
        String string2 = this.buf.toString();
        try {
            Integer n2 = new Integer(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return new Double(string2);
        }
    }

    private Object object() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = (String)this.read();
        while (this.token != OBJECT_END) {
            this.read();
            if (this.token == OBJECT_END) continue;
            hashMap.put(string2, this.read());
            if (this.read() != COMMA) continue;
            string2 = (String)this.read();
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object read() {
        Object object;
        this.skipWhiteSpace();
        if (this.c == '\"' || this.c == '\'') {
            char c2 = this.c;
            this.next();
            object = this.string(c2);
        } else if (this.c == '[') {
            this.next();
            object = this.array();
        } else if (this.c == ']') {
            object = ARRAY_END;
            this.next();
        } else if (this.c == ',') {
            object = COMMA;
            this.next();
        } else if (this.c == '{') {
            this.next();
            object = this.object();
        } else if (this.c == '}') {
            object = OBJECT_END;
            this.next();
        } else if (this.c == ':') {
            object = COLON;
            this.next();
        } else if (this.c == 't' && this.next() == 'r' && this.next() == 'u' && this.next() == 'e') {
            object = Boolean.TRUE;
            this.next();
        } else if (this.c == 'f' && this.next() == 'a' && this.next() == 'l' && this.next() == 's' && this.next() == 'e') {
            object = Boolean.FALSE;
            this.next();
        } else if (this.c == 'n' && this.next() == 'u' && this.next() == 'l' && this.next() == 'l') {
            this.next();
            object = null;
        } else {
            if (!Character.isDigit(this.c) && this.c != '-') {
                throw new IllegalStateException("Found invalid token while parsing JSON (around character " + (this.it.getIndex() - this.it.getBeginIndex()) + "): " + null);
            }
            object = this.number();
        }
        this.token = object;
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void skipWhiteSpace() {
        boolean bl2;
        do {
            bl2 = true;
            if (Character.isWhitespace(this.c)) {
                this.next();
                continue;
            }
            if (this.c != '/') return;
            if (this.next() != '/') return;
            while (this.c != '\n') {
                this.next();
            }
        } while (bl2);
    }

    private Object string(char c2) {
        this.buf.setLength(0);
        while (this.c != c2) {
            if (this.c == '\\') {
                this.next();
                if (this.c == 'u') {
                    this.add(this.unicode());
                    continue;
                }
                Character c3 = escapes.get(new Character(this.c));
                if (c3 != null) {
                    this.add(c3.charValue());
                    continue;
                }
                this.add();
                continue;
            }
            this.add();
        }
        this.next();
        return this.buf.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private char unicode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            switch (this.next()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n2 = -48 + ((n2 << 4) + this.c);
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    n2 = 10 + (-97 + ((n2 << 4) + this.c));
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    n2 = 10 + (-65 + ((n2 << 4) + this.c));
                    break;
                }
            }
            ++n3;
        }
        return (char)n2;
    }

    public Object read(String string2) {
        this.it = new StringCharacterIterator(string2);
        this.c = this.it.first();
        return this.read();
    }
}

