/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools;

import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.utility.BlockingCell;
import com.rabbitmq.utility.Utility;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Tracer
implements Runnable {
    private static final String DEFAULT_CONNECT_HOST = "localhost";
    private static final int DEFAULT_CONNECT_PORT = 5672;
    private static final int DEFAULT_LISTEN_PORT = 5673;
    private static final String PROP_PREFIX = "com.rabbitmq.tools.Tracer.";
    private final String idLabel;
    private final DataInputStream iis;
    private final Socket inSock;
    private final DataOutputStream ios;
    private final Logger logger;
    private final DataInputStream ois;
    private final DataOutputStream oos;
    private final Socket outSock;
    private final Properties props;
    private final BlockingCell<Exception> reportEnd;
    private final AtomicBoolean started;

    private Tracer(int n2, String string2, String string3, int n3, Logger logger, BlockingCell<Exception> blockingCell, Properties properties) throws IOException {
        this(new ServerSocket(n2).accept(), string2, string3, n3, logger, blockingCell, properties);
    }

    public Tracer(int n2, String string2, String string3, int n3, Logger logger, Properties properties) throws IOException {
        this(n2, string2, string3, n3, logger, new BlockingCell<Exception>(), properties);
    }

    public Tracer(String string2) throws IOException {
        this(5673, string2, DEFAULT_CONNECT_HOST, 5672, (Logger)new AsyncLogger(System.out), new BlockingCell<Exception>(), System.getProperties());
    }

    public Tracer(String string2, Properties properties) throws IOException {
        this(5673, string2, DEFAULT_CONNECT_HOST, 5672, (Logger)new AsyncLogger(System.out), new BlockingCell<Exception>(), properties);
    }

    private Tracer(Socket socket, String string2, String string3, int n2, Logger logger) throws IOException {
        this(socket, string2, string3, n2, logger, new BlockingCell<Exception>(), System.getProperties());
    }

    private Tracer(Socket socket, String string2, String string3, int n2, Logger logger, BlockingCell<Exception> blockingCell, Properties properties) throws IOException {
        this.props = properties;
        this.inSock = socket;
        this.outSock = new Socket(string3, n2);
        this.idLabel = ": <" + string2 + "> ";
        this.iis = new DataInputStream(this.inSock.getInputStream());
        this.ios = new DataOutputStream(this.inSock.getOutputStream());
        this.ois = new DataInputStream(this.outSock.getInputStream());
        this.oos = new DataOutputStream(this.outSock.getOutputStream());
        this.logger = logger;
        this.reportEnd = blockingCell;
        this.started = new AtomicBoolean(false);
    }

    private static boolean getBoolProperty(String string2, Properties properties) {
        return Boolean.parseBoolean(properties.getProperty(PROP_PREFIX + string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        int n2 = stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : 5673;
        String string2 = stringArray.length > 1 ? stringArray[1] : DEFAULT_CONNECT_HOST;
        int n3 = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 5672;
        System.out.println("Usage: Tracer [<listenport> [<connecthost> [<connectport>]]]");
        System.out.println("   Serially traces connections on the <listenport>, logging\n   frames received and passing them to the connect host and port.");
        System.out.println("Invoked as: Tracer " + n2 + " " + string2 + " " + n3);
        Properties properties = System.getProperties();
        Tracer.printBoolProperty("WITHHOLD_INBOUND_HEARTBEATS", properties);
        Tracer.printBoolProperty("WITHHOLD_OUTBOUND_HEARTBEATS", properties);
        Tracer.printBoolProperty("NO_ASSEMBLE_FRAMES", properties);
        Tracer.printBoolProperty("NO_DECODE_FRAMES", properties);
        Tracer.printBoolProperty("SUPPRESS_COMMAND_BODIES", properties);
        AsyncLogger asyncLogger = new AsyncLogger(System.out);
        try {
            ServerSocket serverSocket = new ServerSocket(n2);
            int n4 = 0;
            while (true) {
                Socket socket = serverSocket.accept();
                StringBuilder stringBuilder = new StringBuilder().append("Tracer-");
                int n5 = n4 + 1;
                new Tracer(socket, stringBuilder.append(n4).toString(), string2, n3, asyncLogger).start();
                n4 = n5;
            }
        }
        catch (Exception exception) {
            asyncLogger.stop();
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private static void printBoolProperty(String string2, Properties properties) {
        StringBuilder stringBuilder = new StringBuilder(100);
        System.out.println(stringBuilder.append(PROP_PREFIX).append(string2).append(" = ").append(Tracer.getBoolProperty(string2, properties)).toString());
    }

    private void reportAndLogNonNullException(Exception exception) {
        if (exception != null) {
            this.reportEnd.setIfUnset(exception);
            this.logException(exception);
        }
    }

    private void waitAndLogException(BlockingCell<Exception> blockingCell) {
        this.reportAndLogNonNullException(blockingCell.uninterruptibleGet());
    }

    public void log(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.logger.log(stringBuilder.append(System.currentTimeMillis()).append(this.idLabel).append(string2).toString());
    }

    public void logException(Exception exception) {
        this.log("uncaught " + Utility.makeStackTrace(exception));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            byte[] byArray = new byte[8];
            this.iis.readFully(byArray);
            this.oos.write(byArray);
            BlockingCell<Exception> blockingCell = new BlockingCell<Exception>();
            new Thread(new DirectionHandler(blockingCell, true, this.iis, this.oos, this.props)).start();
            new Thread(new DirectionHandler(blockingCell, false, this.ois, this.ios, this.props)).start();
            this.waitAndLogException(blockingCell);
            return;
        }
        catch (Exception exception) {
            this.reportAndLogNonNullException(exception);
            return;
        }
        finally {
            try {
                this.inSock.close();
            }
            catch (Exception exception) {
                this.logException(exception);
            }
            try {
                this.outSock.close();
            }
            catch (Exception exception) {
                this.logException(exception);
            }
            this.reportEnd.setIfUnset(null);
            this.logger.stop();
        }
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.logger.start();
            new Thread(this).start();
        }
    }

    public static class AsyncLogger
    implements Logger {
        private static final int BUFFER_SIZE = 0xA00000;
        private static final int LOG_QUEUE_SIZE = 0x100000;
        private static final int MIN_FLUSH_INTERVAL = 100;
        private static final int ONE_SECOND_INTERVAL = 1000;
        private final SafeCounter countStarted;
        private final Runnable loggerRunnable;
        private volatile Thread loggerThread = null;
        private final BlockingQueue<Pr<String, LogCmd>> queue = new ArrayBlockingQueue<Pr<String, LogCmd>>(0x100000, true);

        public AsyncLogger(OutputStream outputStream) {
            this(outputStream, 1000);
        }

        public AsyncLogger(OutputStream outputStream, int n2) {
            if (n2 < 100) {
                throw new IllegalArgumentException("Flush interval (" + n2 + "ms) must be positive and at least " + 100 + "ms.");
            }
            this.countStarted = new SafeCounter();
            this.loggerRunnable = new AsyncLoggerRunnable(new PrintStream(new BufferedOutputStream(outputStream, 0xA00000), false), n2, this.queue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void log(String string2) {
            if (string2 == null) return;
            try {
                this.queue.put(new Pr<String, LogCmd>(string2, LogCmd.PRINT));
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted while logging.", interruptedException);
            }
        }

        @Override
        public boolean start() {
            if (this.countStarted.testZeroAndIncrement()) {
                this.loggerThread = new Thread(this.loggerRunnable);
                this.loggerThread.start();
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean stop() {
            if (!this.countStarted.decrementAndTestZero()) return false;
            if (this.loggerThread == null) return true;
            try {
                this.queue.put(new Pr<Object, LogCmd>(null, LogCmd.STOP));
                this.loggerThread = null;
            }
            catch (InterruptedException interruptedException) {
                this.loggerThread.interrupt();
                throw new RuntimeException("Interrupted while stopping.", interruptedException);
            }
            return true;
        }

        private class AsyncLoggerRunnable
        implements Runnable {
            private final int flushInterval;
            private final PrintStream ps;
            private final BlockingQueue<Pr<String, LogCmd>> queue;

            public AsyncLoggerRunnable(PrintStream printStream, int n2, BlockingQueue<Pr<String, LogCmd>> blockingQueue) {
                this.flushInterval = n2;
                this.ps = printStream;
                this.queue = blockingQueue;
            }

            private void drainCurrentQueue() {
                int n2 = this.queue.size();
                while (true) {
                    int n3 = n2 - 1;
                    if (n2 <= 0) break;
                    Pr pr = (Pr)this.queue.poll();
                    if (pr != null && pr.left() != null) {
                        this.ps.println((String)pr.left());
                    }
                    n2 = n3;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    long l2 = System.currentTimeMillis() + (long)this.flushInterval;
                    boolean bl2 = false;
                    while (true) {
                        long l3;
                        if (0L >= (l3 = l2 - System.currentTimeMillis())) {
                            if (bl2) {
                                this.ps.flush();
                                bl2 = false;
                            }
                            l2 += (long)this.flushInterval;
                            continue;
                        }
                        Pr<String, LogCmd> pr = this.queue.poll(l3, TimeUnit.MILLISECONDS);
                        if (pr == null) continue;
                        if (pr.left() != null) {
                            this.ps.println(pr.left());
                            bl2 = true;
                        }
                        if (pr.right() == LogCmd.STOP) break;
                    }
                    this.drainCurrentQueue();
                    this.ps.println("Stopped.");
                    this.ps.flush();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    AsyncLogger.this.countStarted.reset();
                    this.drainCurrentQueue();
                    this.ps.println("Interrupted.");
                    this.ps.flush();
                    return;
                }
            }
        }

        private static final class LogCmd
        extends Enum<LogCmd> {
            private static final /* synthetic */ LogCmd[] $VALUES;
            public static final /* enum */ LogCmd PRINT;
            public static final /* enum */ LogCmd STOP;

            static {
                STOP = new LogCmd();
                PRINT = new LogCmd();
                LogCmd[] logCmdArray = new LogCmd[]{STOP, PRINT};
                $VALUES = logCmdArray;
            }

            public static LogCmd valueOf(String string2) {
                return Enum.valueOf(LogCmd.class, string2);
            }

            public static LogCmd[] values() {
                return (LogCmd[])$VALUES.clone();
            }
        }

        private static class Pr<L, R> {
            private final L left;
            private final R right;

            public Pr(L l2, R r2) {
                this.left = l2;
                this.right = r2;
            }

            public L left() {
                return this.left;
            }

            public R right() {
                return this.right;
            }
        }
    }

    private class DirectionHandler
    implements Runnable {
        private final Map<Integer, AMQCommand> commands;
        private final String directionIndicator;
        private final DataInputStream inStream;
        private final boolean noAssembleFrames;
        private final boolean noDecodeFrames;
        private final DataOutputStream outStream;
        private final boolean silentMode;
        private final boolean suppressCommandBodies;
        private final BlockingCell<Exception> waitCell;
        private final boolean writeHeartBeats;

        /*
         * Enabled aggressive block sorting
         */
        public DirectionHandler(BlockingCell<Exception> blockingCell, boolean bl2, DataInputStream dataInputStream, DataOutputStream dataOutputStream, Properties properties) {
            this.waitCell = blockingCell;
            this.silentMode = Tracer.getBoolProperty("SILENT_MODE", properties);
            this.noDecodeFrames = Tracer.getBoolProperty("NO_DECODE_FRAMES", properties);
            this.noAssembleFrames = Tracer.getBoolProperty("NO_ASSEMBLE_FRAMES", properties);
            this.suppressCommandBodies = Tracer.getBoolProperty("SUPPRESS_COMMAND_BODIES", properties);
            boolean bl3 = bl2 && !Tracer.getBoolProperty("WITHHOLD_INBOUND_HEARTBEATS", properties) || !bl2 && !Tracer.getBoolProperty("WITHHOLD_OUTBOUND_HEARTBEATS", properties);
            this.writeHeartBeats = bl3;
            String string2 = bl2 ? " -> " : " <- ";
            this.directionIndicator = string2;
            this.inStream = dataInputStream;
            this.outStream = dataOutputStream;
            this.commands = new HashMap<Integer, AMQCommand>();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void doFrame() throws IOException {
            Frame frame = this.readFrame();
            if (frame == null) return;
            if (this.silentMode) {
                frame.writeTo(this.outStream);
                return;
            } else {
                if (frame.type == 8) {
                    if (this.writeHeartBeats) {
                        frame.writeTo(this.outStream);
                        this.report(frame.channel, frame);
                        return;
                    }
                    this.report(frame.channel, "(withheld) " + frame.toString());
                    return;
                }
                frame.writeTo(this.outStream);
                if (this.noDecodeFrames) {
                    this.report(frame.channel, frame);
                    return;
                }
                if (this.noAssembleFrames) {
                    this.reportFrame(frame);
                    return;
                }
                AMQCommand aMQCommand = this.commands.get(frame.channel);
                if (aMQCommand == null) {
                    aMQCommand = new AMQCommand();
                    this.commands.put(frame.channel, aMQCommand);
                }
                if (!aMQCommand.handleFrame(frame)) return;
                this.report(frame.channel, aMQCommand.toString(this.suppressCommandBodies));
                this.commands.remove(frame.channel);
                return;
            }
        }

        private Frame readFrame() throws IOException {
            return Frame.readFrom(this.inStream);
        }

        private void report(int n2, Object object) {
            StringBuilder stringBuilder = new StringBuilder("ch#").append(n2).append(this.directionIndicator).append(object);
            Tracer.this.log(stringBuilder.toString());
        }

        private void reportFrame(Frame frame) throws IOException {
            switch (frame.type) {
                default: {
                    this.report(frame.channel, frame);
                    return;
                }
                case 1: {
                    this.report(frame.channel, AMQImpl.readMethodFrom(frame.getInputStream()));
                    return;
                }
                case 2: 
            }
            AMQContentHeader aMQContentHeader = AMQImpl.readContentHeaderFrom(frame.getInputStream());
            long l2 = aMQContentHeader.getBodySize();
            StringBuilder stringBuilder = new StringBuilder("Expected body size: ").append(l2).append("; ").append(aMQContentHeader);
            this.report(frame.channel, stringBuilder);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.doFrame();
                }
            }
            catch (Exception exception) {
                this.waitCell.setIfUnset(exception);
                return;
            }
            finally {
                this.waitCell.setIfUnset(null);
            }
        }
    }

    public static interface Logger {
        public void log(String var1);

        public boolean start();

        public boolean stop();
    }

    private static class SafeCounter {
        private int count = 0;
        private final Object countMonitor = new Object();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean decrementAndTestZero() {
            Object object = this.countMonitor;
            synchronized (object) {
                if (this.count == 0) {
                    return false;
                }
                int n2 = this.count = -1 + this.count;
                boolean bl2 = false;
                if (n2 != 0) return bl2;
                return true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void reset() {
            Object object = this.countMonitor;
            synchronized (object) {
                this.count = 0;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean testZeroAndIncrement() {
            Object object = this.countMonitor;
            synchronized (object) {
                int n2 = this.count;
                this.count = 1 + this.count;
                if (n2 != 0) return false;
                return true;
            }
        }
    }
}

