/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.SetQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class WorkPool<K, W> {
    private final Set<K> inProgress;
    private final Object monitor = new Object();
    private final Map<K, LinkedList<W>> pool;
    private final SetQueue<K> ready = new SetQueue();

    public WorkPool() {
        this.inProgress = new HashSet<K>();
        this.pool = new HashMap<K, LinkedList<W>>();
    }

    private void dormantToReady(K k2) {
        this.ready.addIfNotPresent(k2);
    }

    private static <W> int drainTo(LinkedList<W> linkedList, Collection<W> collection, int n2) {
        int n3 = 0;
        W w2;
        while (n3 < n2 && (w2 = linkedList.poll()) != null) {
            collection.add(w2);
            ++n3;
        }
        return n3;
    }

    private void inProgressToDormant(K k2) {
        this.inProgress.remove(k2);
    }

    private void inProgressToReady(K k2) {
        this.inProgress.remove(k2);
        this.ready.addIfNotPresent(k2);
    }

    private boolean isDormant(K k2) {
        return !this.isInProgress(k2) && !this.isReady(k2) && this.isRegistered(k2);
    }

    private boolean isInProgress(K k2) {
        return this.inProgress.contains(k2);
    }

    private boolean isReady(K k2) {
        return this.ready.contains(k2);
    }

    private boolean isRegistered(K k2) {
        return this.pool.containsKey(k2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean moreWorkItems(K k2) {
        LinkedList<W> linkedList = this.pool.get(k2);
        return linkedList != null && !linkedList.isEmpty();
    }

    private K readyToInProgress() {
        K k2 = this.ready.poll();
        if (k2 != null) {
            this.inProgress.add(k2);
        }
        return k2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addWorkItem(K k2, W w2) {
        Object object = this.monitor;
        synchronized (object) {
            Queue queue = this.pool.get(k2);
            if (queue != null) {
                queue.offer(w2);
                if (this.isDormant(k2)) {
                    this.dormantToReady(k2);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean finishWorkBlock(K k2) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.isRegistered(k2)) {
                return false;
            }
            if (!this.inProgress.contains(k2)) {
                throw new IllegalStateException("Client " + k2 + " not in progress");
            }
            if (this.moreWorkItems(k2)) {
                this.inProgressToReady(k2);
                return true;
            }
            this.inProgressToDormant(k2);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public K nextWorkBlock(Collection<W> collection, int n2) {
        Object object = this.monitor;
        synchronized (object) {
            K k2 = this.readyToInProgress();
            if (k2 != null) {
                WorkPool.drainTo(this.pool.get(k2), collection, n2);
            }
            return k2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerKey(K k2) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.pool.containsKey(k2)) {
                this.pool.put(k2, new LinkedList());
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterAllKeys() {
        Object object = this.monitor;
        synchronized (object) {
            this.pool.clear();
            this.ready.clear();
            this.inProgress.clear();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterKey(K k2) {
        Object object = this.monitor;
        synchronized (object) {
            this.pool.remove(k2);
            this.ready.remove(k2);
            this.inProgress.remove(k2);
            return;
        }
    }
}

