/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.impl.Frame;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ValueWriter {
    private static final int COPY_BUFFER_SIZE = 4096;
    private final DataOutputStream out;

    public ValueWriter(DataOutputStream dataOutputStream) {
        this.out = dataOutputStream;
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n2 = inputStream.read(byArray);
        while (-1 != n2) {
            outputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeArray(List<?> list) throws IOException {
        if (list == null) {
            this.out.write(0);
            return;
        } else {
            this.out.writeInt((int)Frame.arraySize(list));
            Iterator<?> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.writeFieldValue(iterator.next());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeArray(Object[] objectArray) throws IOException {
        if (objectArray == null) {
            this.out.write(0);
            return;
        } else {
            this.out.writeInt((int)Frame.arraySize(objectArray));
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.writeFieldValue(objectArray[i2]);
            }
        }
    }

    public final void writeFieldValue(Object object) throws IOException {
        if (object instanceof String) {
            this.writeOctet(83);
            this.writeLongstr((String)object);
            return;
        }
        if (object instanceof LongString) {
            this.writeOctet(83);
            this.writeLongstr((LongString)object);
            return;
        }
        if (object instanceof Integer) {
            this.writeOctet(73);
            this.writeLong((Integer)object);
            return;
        }
        if (object instanceof BigDecimal) {
            this.writeOctet(68);
            BigDecimal bigDecimal = (BigDecimal)object;
            this.writeOctet(bigDecimal.scale());
            if (bigDecimal.unscaledValue().bitLength() > 32) {
                throw new IllegalArgumentException("BigDecimal too large to be encoded");
            }
            this.writeLong(bigDecimal.unscaledValue().intValue());
            return;
        }
        if (object instanceof Date) {
            this.writeOctet(84);
            this.writeTimestamp((Date)object);
            return;
        }
        if (object instanceof Map) {
            this.writeOctet(70);
            this.writeTable((Map)object);
            return;
        }
        if (object instanceof Byte) {
            this.writeOctet(98);
            this.out.writeByte(((Byte)object).byteValue());
            return;
        }
        if (object instanceof Double) {
            this.writeOctet(100);
            this.out.writeDouble((Double)object);
            return;
        }
        if (object instanceof Float) {
            this.writeOctet(102);
            this.out.writeFloat(((Float)object).floatValue());
            return;
        }
        if (object instanceof Long) {
            this.writeOctet(108);
            this.out.writeLong((Long)object);
            return;
        }
        if (object instanceof Short) {
            this.writeOctet(115);
            this.out.writeShort(((Short)object).shortValue());
            return;
        }
        if (object instanceof Boolean) {
            this.writeOctet(116);
            this.out.writeBoolean((Boolean)object);
            return;
        }
        if (object instanceof byte[]) {
            this.writeOctet(120);
            this.writeLong(((byte[])object).length);
            this.out.write((byte[])object);
            return;
        }
        if (object == null) {
            this.writeOctet(86);
            return;
        }
        if (object instanceof List) {
            this.writeOctet(65);
            this.writeArray((List)object);
            return;
        }
        if (object instanceof Object[]) {
            this.writeOctet(65);
            this.writeArray((Object[])object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type: " + object.getClass().getName());
    }

    public final void writeLong(int n2) throws IOException {
        this.out.writeInt(n2);
    }

    public final void writeLonglong(long l2) throws IOException {
        this.out.writeLong(l2);
    }

    public final void writeLongstr(LongString longString) throws IOException {
        this.writeLong((int)longString.length());
        ValueWriter.copy(longString.getStream(), this.out);
    }

    public final void writeLongstr(String string2) throws IOException {
        byte[] byArray = string2.getBytes("utf-8");
        this.writeLong(byArray.length);
        this.out.write(byArray);
    }

    public final void writeOctet(byte by2) throws IOException {
        this.out.writeByte(by2);
    }

    public final void writeOctet(int n2) throws IOException {
        this.out.writeByte(n2);
    }

    public final void writeShort(int n2) throws IOException {
        this.out.writeShort(n2);
    }

    public final void writeShortstr(String string2) throws IOException {
        byte[] byArray = string2.getBytes("utf-8");
        int n2 = byArray.length;
        if (n2 > 255) {
            throw new IllegalArgumentException("Short string too long; utf-8 encoded length = " + n2 + ", max = 255.");
        }
        this.out.writeByte(byArray.length);
        this.out.write(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void writeTable(Map<String, Object> map) throws IOException {
        if (map == null) {
            this.out.writeInt(0);
            return;
        } else {
            this.out.writeInt((int)Frame.tableSize(map));
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.writeShortstr(entry.getKey());
                this.writeFieldValue(entry.getValue());
            }
        }
    }

    public final void writeTimestamp(Date date) throws IOException {
        this.writeLonglong(date.getTime() / 1000L);
    }
}

