/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.MalformedFrameException;
import com.rabbitmq.client.impl.LongStringHelper;
import com.rabbitmq.client.impl.TruncatedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueReader {
    private static final long INT_MASK = 0xFFFFFFFFL;
    private final DataInputStream in;

    public ValueReader(DataInputStream dataInputStream) {
        this.in = dataInputStream;
    }

    private static final List<Object> readArray(DataInputStream dataInputStream) throws IOException {
        DataInputStream dataInputStream2 = new DataInputStream(new TruncatedInputStream(dataInputStream, ValueReader.unsignedExtend(dataInputStream.readInt())));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (dataInputStream2.available() > 0) {
            arrayList.add(ValueReader.readFieldValue(dataInputStream2));
        }
        return arrayList;
    }

    private static final byte[] readBytes(DataInputStream dataInputStream) throws IOException {
        long l2 = ValueReader.unsignedExtend(dataInputStream.readInt());
        if (l2 < Integer.MAX_VALUE) {
            byte[] byArray = new byte[(int)l2];
            dataInputStream.readFully(byArray);
            return byArray;
        }
        throw new UnsupportedOperationException("Very long byte vectors and strings not currently supported");
    }

    private static final Object readFieldValue(DataInputStream dataInputStream) throws IOException {
        switch (dataInputStream.readUnsignedByte()) {
            default: {
                throw new MalformedFrameException("Unrecognised type in table");
            }
            case 83: {
                return ValueReader.readLongstr(dataInputStream);
            }
            case 73: {
                return dataInputStream.readInt();
            }
            case 68: {
                int n2 = dataInputStream.readUnsignedByte();
                byte[] byArray = new byte[4];
                dataInputStream.readFully(byArray);
                return new BigDecimal(new BigInteger(byArray), n2);
            }
            case 84: {
                return ValueReader.readTimestamp(dataInputStream);
            }
            case 70: {
                return ValueReader.readTable(dataInputStream);
            }
            case 65: {
                return ValueReader.readArray(dataInputStream);
            }
            case 98: {
                return dataInputStream.readByte();
            }
            case 100: {
                return dataInputStream.readDouble();
            }
            case 102: {
                return Float.valueOf(dataInputStream.readFloat());
            }
            case 108: {
                return dataInputStream.readLong();
            }
            case 115: {
                return dataInputStream.readShort();
            }
            case 116: {
                return dataInputStream.readBoolean();
            }
            case 120: {
                return ValueReader.readBytes(dataInputStream);
            }
            case 86: 
        }
        return null;
    }

    private static final LongString readLongstr(DataInputStream dataInputStream) throws IOException {
        return LongStringHelper.asLongString(ValueReader.readBytes(dataInputStream));
    }

    private static final String readShortstr(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[dataInputStream.readUnsignedByte()];
        dataInputStream.readFully(byArray);
        return new String(byArray, "utf-8");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Map<String, Object> readTable(DataInputStream dataInputStream) throws IOException {
        long l2 = ValueReader.unsignedExtend(dataInputStream.readInt());
        if (l2 == 0L) {
            return Collections.emptyMap();
        }
        Map<String, Object> map = new HashMap<String, Object>();
        DataInputStream dataInputStream2 = new DataInputStream(new TruncatedInputStream(dataInputStream, l2));
        while (dataInputStream2.available() > 0) {
            String string2 = ValueReader.readShortstr(dataInputStream2);
            Object object = ValueReader.readFieldValue(dataInputStream2);
            if (map.containsKey(string2)) continue;
            map.put(string2, object);
        }
        return map;
    }

    private static final Date readTimestamp(DataInputStream dataInputStream) throws IOException {
        return new Date(1000L * dataInputStream.readLong());
    }

    private static final long unsignedExtend(int n2) {
        return 0xFFFFFFFFL & (long)n2;
    }

    public final int readLong() throws IOException {
        return this.in.readInt();
    }

    public final long readLonglong() throws IOException {
        return this.in.readLong();
    }

    public final LongString readLongstr() throws IOException {
        return ValueReader.readLongstr(this.in);
    }

    public final int readOctet() throws IOException {
        return this.in.readUnsignedByte();
    }

    public final int readShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public final String readShortstr() throws IOException {
        return ValueReader.readShortstr(this.in);
    }

    public final Map<String, Object> readTable() throws IOException {
        return ValueReader.readTable(this.in);
    }

    public final Date readTimestamp() throws IOException {
        return ValueReader.readTimestamp(this.in);
    }
}

