/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class SocketFrameHandler
implements FrameHandler {
    public static final int SOCKET_CLOSING_TIMEOUT = 1;
    private final DataInputStream _inputStream;
    private final DataOutputStream _outputStream;
    private final Socket _socket;

    public SocketFrameHandler(Socket socket) throws IOException {
        this._socket = socket;
        this._inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this._outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        try {
            this._socket.setSoLinger(true, 1);
        }
        catch (Exception exception) {}
        try {
            this.flush();
        }
        catch (Exception exception) {}
        try {
            this._socket.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void flush() throws IOException {
        this._outputStream.flush();
    }

    @Override
    public InetAddress getAddress() {
        return this._socket.getInetAddress();
    }

    public DataInputStream getInputStream() {
        return this._inputStream;
    }

    @Override
    public int getPort() {
        return this._socket.getPort();
    }

    @Override
    public int getTimeout() throws SocketException {
        return this._socket.getSoTimeout();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Frame readFrame() throws IOException {
        DataInputStream dataInputStream = this._inputStream;
        synchronized (dataInputStream) {
            return Frame.readFrom(this._inputStream);
        }
    }

    @Override
    public void sendHeader() throws IOException {
        this.sendHeader(0, 9, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendHeader(int n2, int n3) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            this._outputStream.write("AMQP".getBytes("US-ASCII"));
            this._outputStream.write(1);
            this._outputStream.write(1);
            this._outputStream.write(n2);
            this._outputStream.write(n3);
            this._outputStream.flush();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendHeader(int n2, int n3, int n4) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            this._outputStream.write("AMQP".getBytes("US-ASCII"));
            this._outputStream.write(0);
            this._outputStream.write(n2);
            this._outputStream.write(n3);
            this._outputStream.write(n4);
            this._outputStream.flush();
            return;
        }
    }

    @Override
    public void setTimeout(int n2) throws SocketException {
        this._socket.setSoTimeout(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeFrame(Frame frame) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            frame.writeTo(this._outputStream);
            return;
        }
    }
}

