/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownNotifier;
import com.rabbitmq.client.ShutdownSignalException;
import java.util.ArrayList;
import java.util.List;

public class ShutdownNotifierComponent
implements ShutdownNotifier {
    private final Object monitor = new Object();
    private volatile ShutdownSignalException shutdownCause = null;
    private final List<ShutdownListener> shutdownListeners = new ArrayList<ShutdownListener>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void addShutdownListener(ShutdownListener shutdownListener) {
        Object object = this.monitor;
        // MONITORENTER : object
        ShutdownSignalException shutdownSignalException = this.shutdownCause;
        this.shutdownListeners.add(shutdownListener);
        // MONITOREXIT : object
        if (shutdownSignalException == null) return;
        shutdownListener.shutdownCompleted(shutdownSignalException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ShutdownSignalException getCloseReason() {
        Object object = this.monitor;
        synchronized (object) {
            return this.shutdownCause;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isOpen() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.shutdownCause != null) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notifyListeners() {
        ShutdownSignalException shutdownSignalException;
        ShutdownListener[] shutdownListenerArray;
        Object object = this.monitor;
        synchronized (object) {
            shutdownListenerArray = this.shutdownListeners.toArray(new ShutdownListener[this.shutdownListeners.size()]);
            shutdownSignalException = this.shutdownCause;
        }
        int n2 = shutdownListenerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ShutdownListener shutdownListener = shutdownListenerArray[n3];
            try {
                shutdownListener.shutdownCompleted(shutdownSignalException);
            }
            catch (Exception exception) {}
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeShutdownListener(ShutdownListener shutdownListener) {
        Object object = this.monitor;
        synchronized (object) {
            this.shutdownListeners.remove(shutdownListener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setShutdownCauseIfOpen(ShutdownSignalException shutdownSignalException) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isOpen()) {
                this.shutdownCause = shutdownSignalException;
                return true;
            }
            return false;
        }
    }
}

