/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.impl.ValueWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class MethodArgumentWriter {
    private byte bitAccumulator;
    private int bitMask;
    private boolean needBitFlush;
    private final ValueWriter out;

    public MethodArgumentWriter(ValueWriter valueWriter) {
        this.out = valueWriter;
        this.resetBitAccumulator();
    }

    private final void bitflush() throws IOException {
        if (this.needBitFlush) {
            this.out.writeOctet(this.bitAccumulator);
            this.resetBitAccumulator();
        }
    }

    private void resetBitAccumulator() {
        this.needBitFlush = false;
        this.bitAccumulator = 0;
        this.bitMask = 1;
    }

    public void flush() throws IOException {
        this.bitflush();
        this.out.flush();
    }

    public final void writeBit(boolean bl2) throws IOException {
        if (this.bitMask > 128) {
            this.bitflush();
        }
        if (bl2) {
            this.bitAccumulator = (byte)(this.bitAccumulator | this.bitMask);
        }
        this.bitMask <<= 1;
        this.needBitFlush = true;
    }

    public final void writeLong(int n2) throws IOException {
        this.bitflush();
        this.out.writeLong(n2);
    }

    public final void writeLonglong(long l2) throws IOException {
        this.bitflush();
        this.out.writeLonglong(l2);
    }

    public final void writeLongstr(LongString longString) throws IOException {
        this.bitflush();
        this.out.writeLongstr(longString);
    }

    public final void writeLongstr(String string2) throws IOException {
        this.bitflush();
        this.out.writeLongstr(string2);
    }

    public final void writeOctet(byte by2) throws IOException {
        this.bitflush();
        this.out.writeOctet(by2);
    }

    public final void writeOctet(int n2) throws IOException {
        this.bitflush();
        this.out.writeOctet(n2);
    }

    public final void writeShort(int n2) throws IOException {
        this.bitflush();
        this.out.writeShort(n2);
    }

    public final void writeShortstr(String string2) throws IOException {
        this.bitflush();
        this.out.writeShortstr(string2);
    }

    public final void writeTable(Map<String, Object> map) throws IOException {
        this.bitflush();
        this.out.writeTable(map);
    }

    public final void writeTimestamp(Date date) throws IOException {
        this.bitflush();
        this.out.writeTimestamp(date);
    }
}

