/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.impl.ValueReader;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class MethodArgumentReader {
    private int bits;
    private final ValueReader in;
    private int nextBitMask;

    public MethodArgumentReader(ValueReader valueReader) {
        this.in = valueReader;
        this.clearBits();
    }

    private void clearBits() {
        this.bits = 0;
        this.nextBitMask = 256;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean readBit() throws IOException {
        boolean bl2 = true;
        if (this.nextBitMask > 128) {
            this.bits = this.in.readOctet();
            this.nextBitMask = bl2;
        }
        if ((this.bits & this.nextBitMask) == 0) {
            bl2 = false;
        }
        this.nextBitMask <<= 1;
        return bl2;
    }

    public final int readLong() throws IOException {
        this.clearBits();
        return this.in.readLong();
    }

    public final long readLonglong() throws IOException {
        this.clearBits();
        return this.in.readLonglong();
    }

    public final LongString readLongstr() throws IOException {
        this.clearBits();
        return this.in.readLongstr();
    }

    public final int readOctet() throws IOException {
        this.clearBits();
        return this.in.readOctet();
    }

    public final int readShort() throws IOException {
        this.clearBits();
        return this.in.readShort();
    }

    public final String readShortstr() throws IOException {
        this.clearBits();
        return this.in.readShortstr();
    }

    public final Map<String, Object> readTable() throws IOException {
        this.clearBits();
        return this.in.readTable();
    }

    public final Date readTimestamp() throws IOException {
        this.clearBits();
        return this.in.readTimestamp();
    }
}

