/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class LongStringHelper {
    public static LongString asLongString(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            ByteArrayLongString byteArrayLongString = new ByteArrayLongString(string2.getBytes("utf-8"));
            return byteArrayLongString;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("utf-8 encoding support required");
        }
    }

    public static LongString asLongString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new ByteArrayLongString(byArray);
    }

    private static class ByteArrayLongString
    implements LongString {
        private byte[] bytes;

        public ByteArrayLongString(byte[] byArray) {
            this.bytes = byArray;
        }

        public boolean equals(Object object) {
            if (object instanceof LongString) {
                LongString longString = (LongString)object;
                return Arrays.equals(this.bytes, longString.getBytes());
            }
            return false;
        }

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }

        @Override
        public DataInputStream getStream() throws IOException {
            return new DataInputStream(new ByteArrayInputStream(this.bytes));
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        @Override
        public long length() {
            return this.bytes.length;
        }

        public String toString() {
            try {
                String string2 = new String(this.bytes, "utf-8");
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("utf-8 encoding support required");
            }
        }
    }
}

