/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class HeartbeatSender {
    private ScheduledExecutorService executor;
    private final FrameHandler frameHandler;
    private ScheduledFuture<?> future;
    private volatile long lastActivityTime;
    private final Object monitor = new Object();
    private boolean shutdown = false;

    HeartbeatSender(FrameHandler frameHandler) {
        this.frameHandler = frameHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ScheduledExecutorService createExecutorIfNecessary() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.executor != null) return this.executor;
            this.executor = Executors.newSingleThreadScheduledExecutor();
            return this.executor;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHeartbeat(int n2) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            if (n2 > 0) {
                long l2 = TimeUnit.SECONDS.toNanos(n2) / 2L;
                this.future = this.createExecutorIfNecessary().scheduleAtFixedRate(new HeartbeatRunnable(l2), l2, l2, TimeUnit.NANOSECONDS);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown() {
        Object object = this.monitor;
        // MONITORENTER : object
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        ScheduledExecutorService scheduledExecutorService = this.executor;
        ScheduledExecutorService scheduledExecutorService2 = null;
        if (scheduledExecutorService != null) {
            scheduledExecutorService2 = this.executor;
            this.shutdown = true;
            this.executor = null;
        }
        // MONITOREXIT : object
        if (scheduledExecutorService2 == null) return;
        scheduledExecutorService2.shutdown();
    }

    public void signalActivity() {
        this.lastActivityTime = System.nanoTime();
    }

    private final class HeartbeatRunnable
    implements Runnable {
        private final long heartbeatNanos;

        private HeartbeatRunnable(long l2) {
            this.heartbeatNanos = l2;
        }

        @Override
        public void run() {
            try {
                if (System.nanoTime() > HeartbeatSender.this.lastActivityTime + this.heartbeatNanos) {
                    HeartbeatSender.this.frameHandler.writeFrame(new Frame(8, 0));
                    HeartbeatSender.this.frameHandler.flush();
                }
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }
}

