/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.MalformedFrameException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Frame {
    private final ByteArrayOutputStream accumulator;
    public final int channel;
    private final byte[] payload;
    public final int type;

    public Frame(int n2, int n3) {
        this.type = n2;
        this.channel = n3;
        this.payload = null;
        this.accumulator = new ByteArrayOutputStream();
    }

    public Frame(int n2, int n3, byte[] byArray) {
        this.type = n2;
        this.channel = n3;
        this.payload = byArray;
        this.accumulator = null;
    }

    public static long arraySize(List<?> list) throws UnsupportedEncodingException {
        long l2 = 0L;
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            l2 += Frame.fieldValueSize(iterator.next());
        }
        return l2;
    }

    public static long arraySize(Object[] objectArray) throws UnsupportedEncodingException {
        long l2 = 0L;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 += Frame.fieldValueSize(objectArray[i2]);
        }
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static long fieldValueSize(Object object) throws UnsupportedEncodingException {
        long l2 = 1L;
        if (object instanceof String) {
            l2 += (long)Frame.longStrSize((String)object);
            return l2;
        } else {
            if (object instanceof LongString) {
                return l2 + (4L + ((LongString)object).length());
            }
            if (object instanceof Integer) {
                return l2 + 4L;
            }
            if (object instanceof BigDecimal) {
                return l2 + 5L;
            }
            if (object instanceof Date || object instanceof Timestamp) {
                return l2 + 8L;
            }
            if (object instanceof Map) {
                return l2 + (4L + Frame.tableSize((Map)object));
            }
            if (object instanceof Byte) {
                return l2 + 1L;
            }
            if (object instanceof Double) {
                return l2 + 8L;
            }
            if (object instanceof Float) {
                return l2 + 4L;
            }
            if (object instanceof Long) {
                return l2 + 8L;
            }
            if (object instanceof Short) {
                return l2 + 2L;
            }
            if (object instanceof Boolean) {
                return l2 + 1L;
            }
            if (object instanceof byte[]) {
                return l2 + (long)(4 + ((byte[])object).length);
            }
            if (object instanceof List) {
                return l2 + (4L + Frame.arraySize((List)object));
            }
            if (object instanceof Object[]) {
                return l2 + (4L + Frame.arraySize((Object[])object));
            }
            if (object == null) return l2;
            throw new IllegalArgumentException("invalid value in table");
        }
    }

    public static Frame fromBodyFragment(int n2, byte[] byArray, int n3, int n4) throws IOException {
        Frame frame = new Frame(3, n2);
        frame.getOutputStream().write(byArray, n3, n4);
        return frame;
    }

    private static int longStrSize(String string2) throws UnsupportedEncodingException {
        return 4 + string2.getBytes("utf-8").length;
    }

    /*
     * Unable to fully structure code
     */
    public static void protocolVersionMismatch(DataInputStream var0) throws IOException {
        block10: {
            for (byte var10_4 : new byte[]{77, 81, 80}) {
                var11_5 = var0.readUnsignedByte();
                if (var11_5 == var10_4) continue;
                throw new MalformedFrameException("Invalid AMQP protocol header from server: expected character " + var10_4 + ", got " + var11_5);
            }
            var6_6 = new int[4];
            for (var7_7 = 0; var7_7 < 4; ++var7_7) {
                var6_6[var7_7] = var0.readUnsignedByte();
                continue;
            }
            if (var6_6[0] != 1 || var6_6[1] != 1 || var6_6[2] != 8 || var6_6[3] != 0) break block10;
            var5_8 = new MalformedFrameException("AMQP protocol version mismatch; we are version 0-9-1, server is 0-8");
lbl14:
            // 3 sources

            throw var5_8;
        }
        var8_9 = "";
        for (var9_10 = 0; var9_10 < 4; ++var9_10) {
            if (var9_10 == 0) ** GOTO lbl22
            var8_9 = var8_9 + ",";
lbl22:
            // 2 sources

            var8_9 = var8_9 + var6_6[var9_10];
            continue;
        }
        try {
            var5_8 = new MalformedFrameException("AMQP protocol version mismatch; we are version 0-9-1, server sent signature " + var8_9);
            ** GOTO lbl14
        }
        catch (IOException var4_11) {
            var5_8 = new MalformedFrameException("Invalid AMQP protocol header from server");
            ** continue;
        }
    }

    public static Frame readFrom(DataInputStream dataInputStream) throws IOException {
        int n2;
        block3: {
            try {
                n2 = dataInputStream.readUnsignedByte();
                if (n2 != 65) break block3;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                return null;
            }
            Frame.protocolVersionMismatch(dataInputStream);
        }
        int n3 = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(byArray);
        int n4 = dataInputStream.readUnsignedByte();
        if (n4 != 206) {
            throw new MalformedFrameException("Bad frame end marker: " + n4);
        }
        return new Frame(n2, n3, byArray);
    }

    private static int shortStrSize(String string2) throws UnsupportedEncodingException {
        return 1 + string2.getBytes("utf-8").length;
    }

    public static long tableSize(Map<String, Object> map) throws UnsupportedEncodingException {
        long l2 = 0L;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            l2 = l2 + (long)Frame.shortStrSize(entry.getKey()) + Frame.fieldValueSize(entry.getValue());
        }
        return l2;
    }

    public DataInputStream getInputStream() {
        return new DataInputStream(new ByteArrayInputStream(this.getPayload()));
    }

    public DataOutputStream getOutputStream() {
        return new DataOutputStream(this.accumulator);
    }

    public byte[] getPayload() {
        if (this.payload != null) {
            return this.payload;
        }
        return this.accumulator.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Frame(type=").append(this.type).append(", channel=").append(this.channel).append(", ");
        if (this.accumulator == null) {
            stringBuilder.append(this.payload.length).append(" bytes of payload)");
            return stringBuilder.toString();
        }
        stringBuilder.append(this.accumulator.size()).append(" bytes of accumulator)");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeShort(this.channel);
        if (this.accumulator != null) {
            dataOutputStream.writeInt(this.accumulator.size());
            this.accumulator.writeTo(dataOutputStream);
        } else {
            dataOutputStream.writeInt(this.payload.length);
            dataOutputStream.write(this.payload);
        }
        dataOutputStream.write(206);
    }
}

