/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.impl.ExceptionHandler;
import java.io.IOException;

public class DefaultExceptionHandler
implements ExceptionHandler {
    @Override
    public void handleBlockedListenerException(Connection connection, Throwable throwable) {
        this.handleConnectionKiller(connection, throwable, "BlockedListener");
    }

    protected void handleChannelKiller(Channel channel, Throwable throwable, String string2) {
        System.err.println("DefaultExceptionHandler: " + string2 + " threw an exception for channel " + channel + ":");
        throwable.printStackTrace();
        try {
            channel.close(200, "Closed due to exception from " + string2);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Failure during close of channel " + channel + " after " + throwable + ":");
            iOException.printStackTrace();
            channel.getConnection().abort(541, "Internal error closing channel for " + string2);
            return;
        }
        catch (AlreadyClosedException alreadyClosedException) {
            return;
        }
    }

    @Override
    public void handleConfirmListenerException(Channel channel, Throwable throwable) {
        this.handleChannelKiller(channel, throwable, "ConfirmListener.handle{N,A}ck");
    }

    protected void handleConnectionKiller(Connection connection, Throwable throwable, String string2) {
        System.err.println("DefaultExceptionHandler: " + string2 + " threw an exception for connection " + connection + ":");
        throwable.printStackTrace();
        try {
            connection.close(200, "Closed due to exception from " + string2);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Failure during close of connection " + connection + " after " + throwable + ":");
            iOException.printStackTrace();
            connection.abort(541, "Internal error closing connection for " + string2);
            return;
        }
        catch (AlreadyClosedException alreadyClosedException) {
            return;
        }
    }

    @Override
    public void handleConsumerException(Channel channel, Throwable throwable, Consumer consumer, String string2, String string3) {
        this.handleChannelKiller(channel, throwable, "Consumer " + consumer + " (" + string2 + ")" + " method " + string3 + " for channel " + channel);
    }

    @Override
    public void handleFlowListenerException(Channel channel, Throwable throwable) {
        this.handleChannelKiller(channel, throwable, "FlowListener.handleFlow");
    }

    @Override
    public void handleReturnListenerException(Channel channel, Throwable throwable) {
        this.handleChannelKiller(channel, throwable, "ReturnListener.handleReturn");
    }

    @Override
    public void handleUnexpectedConnectionDriverException(Connection connection, Throwable throwable) {
    }
}

