/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.impl.ValueWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class ContentHeaderPropertyWriter {
    public int bitCount;
    public int flagWord;
    private final ValueWriter out;

    public ContentHeaderPropertyWriter(DataOutputStream dataOutputStream) {
        this.out = new ValueWriter(dataOutputStream);
        this.flagWord = 0;
        this.bitCount = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void emitFlagWord(boolean bl2) throws IOException {
        ValueWriter valueWriter = this.out;
        int n2 = bl2 ? 1 | this.flagWord : this.flagWord;
        valueWriter.writeShort(n2);
        this.flagWord = 0;
        this.bitCount = 0;
    }

    public void finishPresence() throws IOException {
        this.emitFlagWord(false);
    }

    public void writeLong(Integer n2) throws IOException {
        this.out.writeLong(n2);
    }

    public void writeLonglong(Long l2) throws IOException {
        this.out.writeLonglong(l2);
    }

    public void writeLongstr(LongString longString) throws IOException {
        this.out.writeLongstr(longString);
    }

    public void writeLongstr(String string2) throws IOException {
        this.out.writeLongstr(string2);
    }

    public void writeOctet(int n2) throws IOException {
        this.out.writeOctet(n2);
    }

    public void writeOctet(Integer n2) throws IOException {
        this.out.writeOctet(n2);
    }

    public void writePresence(boolean bl2) throws IOException {
        if (this.bitCount == 15) {
            this.emitFlagWord(true);
        }
        if (bl2) {
            int n2 = 15 - this.bitCount;
            this.flagWord |= 1 << n2;
        }
        this.bitCount = 1 + this.bitCount;
    }

    public void writeShort(Integer n2) throws IOException {
        this.out.writeShort(n2);
    }

    public void writeShortstr(String string2) throws IOException {
        this.out.writeShortstr(string2);
    }

    public void writeTable(Map<String, Object> map) throws IOException {
        this.out.writeTable(map);
    }

    public void writeTimestamp(Date date) throws IOException {
        this.out.writeTimestamp(date);
    }
}

