/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.impl.ValueReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class ContentHeaderPropertyReader {
    public int bitCount;
    public int flagWord;
    private final ValueReader in;

    public ContentHeaderPropertyReader(DataInputStream dataInputStream) throws IOException {
        this.in = new ValueReader(dataInputStream);
        this.flagWord = 1;
        this.bitCount = 15;
    }

    private boolean isContinuationBitSet() {
        return (1 & this.flagWord) != 0;
    }

    public void finishPresence() throws IOException {
        if (this.isContinuationBitSet()) {
            throw new IOException("Unexpected continuation flag word");
        }
    }

    public void readFlagWord() throws IOException {
        if (!this.isContinuationBitSet()) {
            throw new IOException("Attempted to read flag word when none advertised");
        }
        this.flagWord = this.in.readShort();
        this.bitCount = 0;
    }

    public Integer readLong() throws IOException {
        return this.in.readLong();
    }

    public Long readLonglong() throws IOException {
        return this.in.readLonglong();
    }

    public LongString readLongstr() throws IOException {
        return this.in.readLongstr();
    }

    public int readOctet() throws IOException {
        return this.in.readOctet();
    }

    public boolean readPresence() throws IOException {
        if (this.bitCount == 15) {
            this.readFlagWord();
        }
        int n2 = 15 - this.bitCount;
        this.bitCount = 1 + this.bitCount;
        return (this.flagWord & 1 << n2) != 0;
    }

    public Integer readShort() throws IOException {
        return this.in.readShort();
    }

    public String readShortstr() throws IOException {
        return this.in.readShortstr();
    }

    public Map<String, Object> readTable() throws IOException {
        return this.in.readTable();
    }

    public Date readTimestamp() throws IOException {
        return this.in.readTimestamp();
    }
}

