/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ConsumerWorkService;
import com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

final class ConsumerDispatcher {
    private final Channel channel;
    private final AMQConnection connection;
    private volatile CountDownLatch shutdownConsumersComplete;
    private volatile boolean shutdownConsumersDriven = false;
    private volatile ShutdownSignalException shutdownSignal = null;
    private volatile boolean shuttingDown = false;
    private final ConsumerWorkService workService;

    public ConsumerDispatcher(AMQConnection aMQConnection, Channel channel, ConsumerWorkService consumerWorkService) {
        this.connection = aMQConnection;
        this.channel = channel;
        consumerWorkService.registerKey(channel);
        this.workService = consumerWorkService;
    }

    private void checkShutdown() {
        if (this.shutdownSignal != null) {
            throw Utility.fixStackTrace(this.shutdownSignal);
        }
    }

    private void execute(Runnable runnable) {
        this.checkShutdown();
        this.workService.addWork(this.channel, runnable);
    }

    private void executeUnlessShuttingDown(Runnable runnable) {
        if (!this.shuttingDown) {
            this.execute(runnable);
        }
    }

    private void notifyConsumerOfShutdown(String string2, Consumer consumer, ShutdownSignalException shutdownSignalException) {
        try {
            consumer.handleShutdownSignal(string2, shutdownSignalException);
            return;
        }
        catch (Throwable throwable) {
            this.connection.getExceptionHandler().handleConsumerException(this.channel, throwable, consumer, string2, "handleShutdownSignal");
            return;
        }
    }

    private void notifyConsumersOfShutdown(Map<String, Consumer> map, ShutdownSignalException shutdownSignalException) {
        for (Map.Entry<String, Consumer> entry : map.entrySet()) {
            this.notifyConsumerOfShutdown(entry.getKey(), entry.getValue(), shutdownSignalException);
        }
    }

    private void shutdown(ShutdownSignalException shutdownSignalException) {
        this.shutdownSignal = shutdownSignalException;
    }

    public void handleCancel(final Consumer consumer, final String string2) {
        this.executeUnlessShuttingDown(new Runnable(){

            @Override
            public void run() {
                try {
                    consumer.handleCancel(string2);
                    return;
                }
                catch (Throwable throwable) {
                    ConsumerDispatcher.this.connection.getExceptionHandler().handleConsumerException(ConsumerDispatcher.this.channel, throwable, consumer, string2, "handleCancel");
                    return;
                }
            }
        });
    }

    public void handleCancelOk(final Consumer consumer, final String string2) {
        this.executeUnlessShuttingDown(new Runnable(){

            @Override
            public void run() {
                try {
                    consumer.handleCancelOk(string2);
                    return;
                }
                catch (Throwable throwable) {
                    ConsumerDispatcher.this.connection.getExceptionHandler().handleConsumerException(ConsumerDispatcher.this.channel, throwable, consumer, string2, "handleCancelOk");
                    return;
                }
            }
        });
    }

    public void handleConsumeOk(final Consumer consumer, final String string2) {
        this.executeUnlessShuttingDown(new Runnable(){

            @Override
            public void run() {
                try {
                    consumer.handleConsumeOk(string2);
                    return;
                }
                catch (Throwable throwable) {
                    ConsumerDispatcher.this.connection.getExceptionHandler().handleConsumerException(ConsumerDispatcher.this.channel, throwable, consumer, string2, "handleConsumeOk");
                    return;
                }
            }
        });
    }

    public void handleDelivery(final Consumer consumer, final String string2, final Envelope envelope, final AMQP.BasicProperties basicProperties, final byte[] byArray) throws IOException {
        this.executeUnlessShuttingDown(new Runnable(){

            @Override
            public void run() {
                try {
                    consumer.handleDelivery(string2, envelope, basicProperties, byArray);
                    return;
                }
                catch (Throwable throwable) {
                    ConsumerDispatcher.this.connection.getExceptionHandler().handleConsumerException(ConsumerDispatcher.this.channel, throwable, consumer, string2, "handleDelivery");
                    return;
                }
            }
        });
    }

    public void handleRecoverOk(final Consumer consumer, final String string2) {
        this.executeUnlessShuttingDown(new Runnable(){

            @Override
            public void run() {
                consumer.handleRecoverOk(string2);
            }
        });
    }

    public CountDownLatch handleShutdownSignal(final Map<String, Consumer> map, final ShutdownSignalException shutdownSignalException) {
        if (!this.shutdownConsumersDriven) {
            CountDownLatch countDownLatch;
            this.shutdownConsumersComplete = countDownLatch = new CountDownLatch(1);
            this.shutdownConsumersDriven = true;
            this.execute(new Runnable(){

                @Override
                public void run() {
                    ConsumerDispatcher.this.notifyConsumersOfShutdown(map, shutdownSignalException);
                    ConsumerDispatcher.this.shutdown(shutdownSignalException);
                    ConsumerDispatcher.this.workService.stopWork(ConsumerDispatcher.this.channel);
                    countDownLatch.countDown();
                }
            });
        }
        return this.shutdownConsumersComplete;
    }

    public void quiesce() {
        this.shuttingDown = true;
    }
}

