/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.UnexpectedFrameError;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.Method;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class CommandAssembler {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private int bodyLength;
    private final List<byte[]> bodyN;
    private AMQContentHeader contentHeader;
    private Method method;
    private long remainingBodyBytes;
    private CAState state;

    /*
     * Enabled aggressive block sorting
     */
    public CommandAssembler(Method method, AMQContentHeader aMQContentHeader, byte[] byArray) {
        this.method = method;
        this.contentHeader = aMQContentHeader;
        this.bodyN = new ArrayList<byte[]>(2);
        this.bodyLength = 0;
        this.remainingBodyBytes = 0L;
        this.appendBodyFragment(byArray);
        if (method == null) {
            this.state = CAState.EXPECTING_METHOD;
            return;
        }
        if (aMQContentHeader != null) {
            this.remainingBodyBytes = aMQContentHeader.getBodySize() - (long)this.bodyLength;
            this.updateContentBodyState();
            return;
        }
        CAState cAState = method.hasContent() ? CAState.EXPECTING_CONTENT_HEADER : CAState.COMPLETE;
        this.state = cAState;
    }

    private void appendBodyFragment(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        this.bodyN.add(byArray);
        this.bodyLength += byArray.length;
    }

    private byte[] coalesceContentBody() {
        if (this.bodyLength == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (this.bodyN.size() == 1) {
            return this.bodyN.get(0);
        }
        byte[] byArray = new byte[this.bodyLength];
        int n2 = 0;
        for (byte[] byArray2 : this.bodyN) {
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        this.bodyN.clear();
        this.bodyN.add(byArray);
        return byArray;
    }

    private void consumeBodyFrame(Frame frame) {
        if (frame.type == 3) {
            byte[] byArray = frame.getPayload();
            this.remainingBodyBytes -= (long)byArray.length;
            this.updateContentBodyState();
            if (this.remainingBodyBytes < 0L) {
                throw new UnsupportedOperationException("%%%%%% FIXME unimplemented");
            }
            this.appendBodyFragment(byArray);
            return;
        }
        throw new UnexpectedFrameError(frame, 3);
    }

    private void consumeHeaderFrame(Frame frame) throws IOException {
        if (frame.type == 2) {
            this.contentHeader = AMQImpl.readContentHeaderFrom(frame.getInputStream());
            this.remainingBodyBytes = this.contentHeader.getBodySize();
            this.updateContentBodyState();
            return;
        }
        throw new UnexpectedFrameError(frame, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void consumeMethodFrame(Frame frame) throws IOException {
        if (frame.type != 1) {
            throw new UnexpectedFrameError(frame, 1);
        }
        this.method = AMQImpl.readMethodFrom(frame.getInputStream());
        CAState cAState = this.method.hasContent() ? CAState.EXPECTING_CONTENT_HEADER : CAState.COMPLETE;
        this.state = cAState;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateContentBodyState() {
        CAState cAState = this.remainingBodyBytes > 0L ? CAState.EXPECTING_CONTENT_BODY : CAState.COMPLETE;
        this.state = cAState;
    }

    public byte[] getContentBody() {
        synchronized (this) {
            byte[] byArray = this.coalesceContentBody();
            return byArray;
        }
    }

    public AMQContentHeader getContentHeader() {
        synchronized (this) {
            AMQContentHeader aMQContentHeader = this.contentHeader;
            return aMQContentHeader;
        }
    }

    public Method getMethod() {
        synchronized (this) {
            Method method = this.method;
            return method;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleFrame(Frame frame) throws IOException {
        synchronized (this) {
            switch (1.$SwitchMap$com$rabbitmq$client$impl$CommandAssembler$CAState[this.state.ordinal()]) {
                default: {
                    throw new AssertionError((Object)("Bad Command State " + (Object)((Object)this.state)));
                }
                case 1: {
                    this.consumeMethodFrame(frame);
                    return this.isComplete();
                }
                case 2: {
                    this.consumeHeaderFrame(frame);
                    return this.isComplete();
                }
                case 3: {
                    this.consumeBodyFrame(frame);
                }
            }
            return this.isComplete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isComplete() {
        synchronized (this) {
            CAState cAState = this.state;
            CAState cAState2 = CAState.COMPLETE;
            if (cAState != cAState2) return false;
            return true;
        }
    }

    private static final class CAState
    extends Enum<CAState> {
        private static final /* synthetic */ CAState[] $VALUES;
        public static final /* enum */ CAState COMPLETE;
        public static final /* enum */ CAState EXPECTING_CONTENT_BODY;
        public static final /* enum */ CAState EXPECTING_CONTENT_HEADER;
        public static final /* enum */ CAState EXPECTING_METHOD;

        static {
            EXPECTING_METHOD = new CAState();
            EXPECTING_CONTENT_HEADER = new CAState();
            EXPECTING_CONTENT_BODY = new CAState();
            COMPLETE = new CAState();
            CAState[] cAStateArray = new CAState[]{EXPECTING_METHOD, EXPECTING_CONTENT_HEADER, EXPECTING_CONTENT_BODY, COMPLETE};
            $VALUES = cAStateArray;
        }

        public static CAState valueOf(String string2) {
            return Enum.valueOf(CAState.class, string2);
        }

        public static CAState[] values() {
            return (CAState[])$VALUES.clone();
        }
    }
}

