/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.FlowListener;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.MessageProperties;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.UnexpectedMethodError;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.ConsumerDispatcher;
import com.rabbitmq.client.impl.ConsumerWorkService;
import com.rabbitmq.client.impl.ExceptionHandler;
import com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;

public class ChannelN
extends AMQChannel
implements Channel {
    private static final String UNSPECIFIED_OUT_OF_BAND = "";
    private final Map<String, Consumer> _consumers = Collections.synchronizedMap(new HashMap());
    private final Collection<ConfirmListener> confirmListeners;
    private volatile Consumer defaultConsumer = null;
    private final ConsumerDispatcher dispatcher;
    private volatile CountDownLatch finishedShutdownFlag = null;
    private final Collection<FlowListener> flowListeners;
    private long nextPublishSeqNo = 0L;
    private volatile boolean onlyAcksReceived = true;
    private final Collection<ReturnListener> returnListeners = new CopyOnWriteArrayList<ReturnListener>();
    private volatile SortedSet<Long> unconfirmedSet;

    public ChannelN(AMQConnection aMQConnection, int n2, ConsumerWorkService consumerWorkService) {
        super(aMQConnection, n2);
        this.flowListeners = new CopyOnWriteArrayList<FlowListener>();
        this.confirmListeners = new CopyOnWriteArrayList<ConfirmListener>();
        this.unconfirmedSet = Collections.synchronizedSortedSet(new TreeSet());
        this.dispatcher = new ConsumerDispatcher(aMQConnection, this, consumerWorkService);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void asyncShutdown(Command command) throws IOException {
        ShutdownSignalException shutdownSignalException = new ShutdownSignalException(false, false, command, this);
        Object object = this._channelMutex;
        synchronized (object) {
            this.processShutdownSignal(shutdownSignalException, true, false);
            this.quiescingTransmit(new AMQImpl.Channel.CloseOk());
        }
        this.notifyListeners();
        return;
        {
            finally {
                this.releaseChannel();
                this.notifyOutstandingRpc(shutdownSignalException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void broadcastShutdownSignal(ShutdownSignalException shutdownSignalException) {
        HashMap<String, Consumer> hashMap;
        Map<String, Consumer> map = this._consumers;
        synchronized (map) {
            hashMap = new HashMap<String, Consumer>(this._consumers);
        }
        this.finishedShutdownFlag = this.dispatcher.handleShutdownSignal(hashMap, shutdownSignalException);
    }

    private void callConfirmListeners(Command command, AMQImpl.Basic.Ack ack) {
        try {
            Iterator<ConfirmListener> iterator = this.confirmListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().handleAck(ack.getDeliveryTag(), ack.getMultiple());
            }
        }
        catch (Throwable throwable) {
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleConfirmListenerException(this, throwable);
        }
    }

    private void callConfirmListeners(Command command, AMQImpl.Basic.Nack nack) {
        try {
            Iterator<ConfirmListener> iterator = this.confirmListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().handleNack(nack.getDeliveryTag(), nack.getMultiple());
            }
        }
        catch (Throwable throwable) {
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleConfirmListenerException(this, throwable);
        }
    }

    private void callFlowListeners(Command command, AMQImpl.Channel.Flow flow) {
        try {
            Iterator<FlowListener> iterator = this.flowListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().handleFlow(flow.getActive());
            }
        }
        catch (Throwable throwable) {
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleFlowListenerException(this, throwable);
        }
    }

    private void callReturnListeners(Command command, AMQImpl.Basic.Return return_) {
        try {
            Iterator<ReturnListener> iterator = this.returnListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().handleReturn(return_.getReplyCode(), return_.getReplyText(), return_.getExchange(), return_.getRoutingKey(), (AMQP.BasicProperties)command.getContentHeader(), command.getContentBody());
            }
        }
        catch (Throwable throwable) {
            ((AMQConnection)this.getConnection()).getExceptionHandler().handleReturnListenerException(this, throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishProcessShutdownSignal() {
        this.dispatcher.quiesce();
        this.broadcastShutdownSignal(this.getCloseReason());
        SortedSet<Long> sortedSet = this.unconfirmedSet;
        synchronized (sortedSet) {
            this.unconfirmedSet.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleAckNack(long l2, boolean bl2, boolean bl3) {
        if (bl2) {
            this.unconfirmedSet.headSet(1L + l2).clear();
        } else {
            this.unconfirmedSet.remove(l2);
        }
        SortedSet<Long> sortedSet = this.unconfirmedSet;
        synchronized (sortedSet) {
            boolean bl4 = this.onlyAcksReceived && !bl3;
            this.onlyAcksReceived = bl4;
            if (this.unconfirmedSet.isEmpty()) {
                this.unconfirmedSet.notifyAll();
            }
            return;
        }
    }

    private void releaseChannel() {
        ((AMQConnection)this.getConnection()).disconnectChannel(this);
    }

    private void startProcessShutdownSignal(ShutdownSignalException shutdownSignalException, boolean bl2, boolean bl3) {
        super.processShutdownSignal(shutdownSignalException, bl2, bl3);
    }

    @Override
    public void abort() throws IOException {
        this.abort(200, "OK");
    }

    @Override
    public void abort(int n2, String string2) throws IOException {
        this.close(n2, string2, true, null, true);
    }

    @Override
    public void addConfirmListener(ConfirmListener confirmListener) {
        this.confirmListeners.add(confirmListener);
    }

    @Override
    public void addFlowListener(FlowListener flowListener) {
        this.flowListeners.add(flowListener);
    }

    @Override
    public void addReturnListener(ReturnListener returnListener) {
        this.returnListeners.add(returnListener);
    }

    @Override
    public void asyncRpc(Method method) throws IOException {
        this.transmit(method);
    }

    @Override
    public void basicAck(long l2, boolean bl2) throws IOException {
        this.transmit(new AMQImpl.Basic.Ack(l2, bl2));
    }

    @Override
    public void basicCancel(final String string2) throws IOException {
        final Consumer consumer = this._consumers.get(string2);
        if (consumer == null) {
            throw new IOException("Unknown consumerTag");
        }
        AMQChannel.BlockingRpcContinuation<Consumer> blockingRpcContinuation = new AMQChannel.BlockingRpcContinuation<Consumer>(){

            @Override
            public Consumer transformReply(AMQCommand aMQCommand) {
                aMQCommand.getMethod();
                ChannelN.this._consumers.remove(string2);
                ChannelN.this.dispatcher.handleCancelOk(consumer, string2);
                return consumer;
            }
        };
        this.rpc(new AMQImpl.Basic.Cancel(string2, false), blockingRpcContinuation);
        try {
            blockingRpcContinuation.getReply();
            return;
        }
        catch (ShutdownSignalException shutdownSignalException) {
            throw ChannelN.wrap(shutdownSignalException);
        }
    }

    @Override
    public String basicConsume(String string2, Consumer consumer) throws IOException {
        return this.basicConsume(string2, false, consumer);
    }

    @Override
    public String basicConsume(String string2, boolean bl2, Consumer consumer) throws IOException {
        return this.basicConsume(string2, bl2, UNSPECIFIED_OUT_OF_BAND, consumer);
    }

    @Override
    public String basicConsume(String string2, boolean bl2, String string3, Consumer consumer) throws IOException {
        return this.basicConsume(string2, bl2, string3, false, false, null, consumer);
    }

    @Override
    public String basicConsume(String string2, boolean bl2, String string3, boolean bl3, boolean bl4, Map<String, Object> map, final Consumer consumer) throws IOException {
        AMQChannel.BlockingRpcContinuation<String> blockingRpcContinuation = new AMQChannel.BlockingRpcContinuation<String>(){

            @Override
            public String transformReply(AMQCommand aMQCommand) {
                String string2 = ((AMQImpl.Basic.ConsumeOk)aMQCommand.getMethod()).getConsumerTag();
                ChannelN.this._consumers.put(string2, consumer);
                ChannelN.this.dispatcher.handleConsumeOk(consumer, string2);
                return string2;
            }
        };
        this.rpc(new AMQP.Basic.Consume.Builder().queue(string2).consumerTag(string3).noLocal(bl3).noAck(bl2).exclusive(bl4).arguments(map).build(), blockingRpcContinuation);
        try {
            String string4 = (String)blockingRpcContinuation.getReply();
            return string4;
        }
        catch (ShutdownSignalException shutdownSignalException) {
            throw ChannelN.wrap(shutdownSignalException);
        }
    }

    @Override
    public GetResponse basicGet(String string2, boolean bl2) throws IOException {
        AMQCommand aMQCommand = this.exnWrappingRpc(new AMQP.Basic.Get.Builder().queue(string2).noAck(bl2).build());
        Method method = aMQCommand.getMethod();
        if (method instanceof AMQImpl.Basic.GetOk) {
            AMQImpl.Basic.GetOk getOk = (AMQImpl.Basic.GetOk)method;
            return new GetResponse(new Envelope(getOk.getDeliveryTag(), getOk.getRedelivered(), getOk.getExchange(), getOk.getRoutingKey()), (AMQP.BasicProperties)aMQCommand.getContentHeader(), aMQCommand.getContentBody(), getOk.getMessageCount());
        }
        if (method instanceof AMQImpl.Basic.GetEmpty) {
            return null;
        }
        throw new UnexpectedMethodError(method);
    }

    @Override
    public void basicNack(long l2, boolean bl2, boolean bl3) throws IOException {
        this.transmit(new AMQImpl.Basic.Nack(l2, bl2, bl3));
    }

    @Override
    public void basicPublish(String string2, String string3, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        this.basicPublish(string2, string3, false, basicProperties, byArray);
    }

    @Override
    public void basicPublish(String string2, String string3, boolean bl2, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        this.basicPublish(string2, string3, bl2, false, basicProperties, byArray);
    }

    @Override
    public void basicPublish(String string2, String string3, boolean bl2, boolean bl3, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        if (this.nextPublishSeqNo > 0L) {
            this.unconfirmedSet.add(this.getNextPublishSeqNo());
            this.nextPublishSeqNo = 1L + this.nextPublishSeqNo;
        }
        AMQP.BasicProperties basicProperties2 = basicProperties;
        if (basicProperties == null) {
            basicProperties2 = MessageProperties.MINIMAL_BASIC;
        }
        this.transmit(new AMQCommand(new AMQP.Basic.Publish.Builder().exchange(string2).routingKey(string3).mandatory(bl2).immediate(bl3).build(), basicProperties2, byArray));
    }

    @Override
    public void basicQos(int n2) throws IOException {
        this.basicQos(0, n2, false);
    }

    @Override
    public void basicQos(int n2, int n3, boolean bl2) throws IOException {
        this.exnWrappingRpc(new AMQImpl.Basic.Qos(n2, n3, bl2));
    }

    @Override
    public AMQImpl.Basic.RecoverOk basicRecover() throws IOException {
        return this.basicRecover(true);
    }

    @Override
    public AMQImpl.Basic.RecoverOk basicRecover(boolean bl2) throws IOException {
        return (AMQImpl.Basic.RecoverOk)this.exnWrappingRpc(new AMQImpl.Basic.Recover(bl2)).getMethod();
    }

    @Override
    public void basicRecoverAsync(boolean bl2) throws IOException {
        this.transmit(new AMQImpl.Basic.RecoverAsync(bl2));
    }

    @Override
    public void basicReject(long l2, boolean bl2) throws IOException {
        this.transmit(new AMQImpl.Basic.Reject(l2, bl2));
    }

    @Override
    public void clearConfirmListeners() {
        this.confirmListeners.clear();
    }

    @Override
    public void clearFlowListeners() {
        this.flowListeners.clear();
    }

    @Override
    public void clearReturnListeners() {
        this.returnListeners.clear();
    }

    @Override
    public void close() throws IOException {
        this.close(200, "OK");
    }

    @Override
    public void close(int n2, String string2) throws IOException {
        this.close(n2, string2, true, null, false);
    }

    /*
     * Exception decompiling
     */
    public void close(int var1_1, String var2_2, boolean var3_3, Throwable var4_4, boolean var5_5) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [9 : 126->129)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public AMQImpl.Confirm.SelectOk confirmSelect() throws IOException {
        if (this.nextPublishSeqNo == 0L) {
            this.nextPublishSeqNo = 1L;
        }
        return (AMQImpl.Confirm.SelectOk)this.exnWrappingRpc(new AMQImpl.Confirm.Select(false)).getMethod();
    }

    @Override
    public AMQImpl.Exchange.BindOk exchangeBind(String string2, String string3, String string4) throws IOException {
        return this.exchangeBind(string2, string3, string4, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.BindOk exchangeBind(String string2, String string3, String string4, Map<String, Object> map) throws IOException {
        return (AMQImpl.Exchange.BindOk)this.exnWrappingRpc(new AMQP.Exchange.Bind.Builder().destination(string2).source(string3).routingKey(string4).arguments(map).build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string2, String string3) throws IOException {
        return this.exchangeDeclare(string2, string3, false, false, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string2, String string3, boolean bl2) throws IOException {
        return this.exchangeDeclare(string2, string3, bl2, false, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string2, String string3, boolean bl2, boolean bl3, Map<String, Object> map) throws IOException {
        return this.exchangeDeclare(string2, string3, bl2, bl3, false, (Map)map);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String string2, String string3, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        return (AMQImpl.Exchange.DeclareOk)this.exnWrappingRpc(new AMQP.Exchange.Declare.Builder().exchange(string2).type(string3).durable(bl2).autoDelete(bl3).internal(bl4).arguments(map).build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclarePassive(String string2) throws IOException {
        return (AMQImpl.Exchange.DeclareOk)this.exnWrappingRpc(new AMQP.Exchange.Declare.Builder().exchange(string2).type(UNSPECIFIED_OUT_OF_BAND).passive().build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeleteOk exchangeDelete(String string2) throws IOException {
        return this.exchangeDelete(string2, false);
    }

    @Override
    public AMQImpl.Exchange.DeleteOk exchangeDelete(String string2, boolean bl2) throws IOException {
        return (AMQImpl.Exchange.DeleteOk)this.exnWrappingRpc(new AMQP.Exchange.Delete.Builder().exchange(string2).ifUnused(bl2).build()).getMethod();
    }

    @Override
    public AMQImpl.Exchange.UnbindOk exchangeUnbind(String string2, String string3, String string4) throws IOException {
        return this.exchangeUnbind(string2, string3, string4, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.UnbindOk exchangeUnbind(String string2, String string3, String string4, Map<String, Object> map) throws IOException {
        return (AMQImpl.Exchange.UnbindOk)this.exnWrappingRpc(new AMQP.Exchange.Unbind.Builder().destination(string2).source(string3).routingKey(string4).arguments(map).build()).getMethod();
    }

    @Override
    public AMQImpl.Channel.FlowOk flow(boolean bl2) throws IOException {
        return (AMQImpl.Channel.FlowOk)this.exnWrappingRpc(new AMQImpl.Channel.Flow(bl2)).getMethod();
    }

    @Override
    public Consumer getDefaultConsumer() {
        return this.defaultConsumer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AMQImpl.Channel.FlowOk getFlow() {
        boolean bl2;
        if (!this._blockContent) {
            bl2 = true;
            return new AMQImpl.Channel.FlowOk(bl2);
        }
        bl2 = false;
        return new AMQImpl.Channel.FlowOk(bl2);
    }

    @Override
    public long getNextPublishSeqNo() {
        return this.nextPublishSeqNo;
    }

    CountDownLatch getShutdownLatch() {
        return this.finishedShutdownFlag;
    }

    public void open() throws IOException {
        this.exnWrappingRpc(new AMQImpl.Channel.Open(UNSPECIFIED_OUT_OF_BAND));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processAsync(Command command) throws IOException {
        Consumer consumer;
        AMQImpl.Basic.Deliver deliver;
        block19: {
            Consumer consumer2;
            block18: {
                Method method;
                block17: {
                    method = command.getMethod();
                    if (method instanceof AMQImpl.Channel.Close) {
                        this.asyncShutdown(command);
                        return true;
                    }
                    if (!this.isOpen()) {
                        if (!(method instanceof AMQImpl.Channel.CloseOk)) return true;
                        return false;
                    }
                    if (!(method instanceof AMQImpl.Basic.Deliver)) break block17;
                    deliver = (AMQImpl.Basic.Deliver)method;
                    consumer2 = this._consumers.get(deliver.getConsumerTag());
                    if (consumer2 != null) break block18;
                    if (this.defaultConsumer == null) {
                        throw new IllegalStateException("Unsolicited delivery - see Channel.setDefaultConsumer to handle this case.");
                    }
                    consumer = this.defaultConsumer;
                    break block19;
                }
                if (method instanceof AMQImpl.Basic.Return) {
                    this.callReturnListeners(command, (AMQImpl.Basic.Return)method);
                    return true;
                }
                if (method instanceof AMQImpl.Channel.Flow) {
                    AMQImpl.Channel.Flow flow = (AMQImpl.Channel.Flow)method;
                    Object object = this._channelMutex;
                    synchronized (object) {
                        boolean bl2 = !flow.getActive();
                        this._blockContent = bl2;
                        boolean bl3 = !this._blockContent;
                        this.transmit(new AMQImpl.Channel.FlowOk(bl3));
                        this._channelMutex.notifyAll();
                    }
                    this.callFlowListeners(command, flow);
                    return true;
                }
                if (method instanceof AMQImpl.Basic.Ack) {
                    AMQImpl.Basic.Ack ack = (AMQImpl.Basic.Ack)method;
                    this.callConfirmListeners(command, ack);
                    this.handleAckNack(ack.getDeliveryTag(), ack.getMultiple(), false);
                    return true;
                }
                if (method instanceof AMQImpl.Basic.Nack) {
                    AMQImpl.Basic.Nack nack = (AMQImpl.Basic.Nack)method;
                    this.callConfirmListeners(command, nack);
                    this.handleAckNack(nack.getDeliveryTag(), nack.getMultiple(), true);
                    return true;
                }
                if (method instanceof AMQImpl.Basic.RecoverOk) {
                    Iterator<Map.Entry<String, Consumer>> iterator = this._consumers.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Consumer> entry = iterator.next();
                        this.dispatcher.handleRecoverOk(entry.getValue(), entry.getKey());
                    }
                    return false;
                }
                if (!(method instanceof AMQImpl.Basic.Cancel)) return false;
                String string2 = ((AMQImpl.Basic.Cancel)method).getConsumerTag();
                Consumer consumer3 = this._consumers.remove(string2);
                if (consumer3 == null) {
                    consumer3 = this.defaultConsumer;
                }
                if (consumer3 == null) return true;
                try {
                    this.dispatcher.handleCancel(consumer3, string2);
                    return true;
                }
                catch (Throwable throwable) {
                    ((AMQConnection)this.getConnection()).getExceptionHandler().handleConsumerException(this, throwable, consumer3, string2, "handleCancel");
                    return true;
                }
            }
            consumer = consumer2;
        }
        Envelope envelope = new Envelope(deliver.getDeliveryTag(), deliver.getRedelivered(), deliver.getExchange(), deliver.getRoutingKey());
        try {
            ConsumerDispatcher consumerDispatcher = this.dispatcher;
            String string3 = deliver.getConsumerTag();
            AMQP.BasicProperties basicProperties = (AMQP.BasicProperties)command.getContentHeader();
            byte[] byArray = command.getContentBody();
            consumerDispatcher.handleDelivery(consumer, string3, envelope, basicProperties, byArray);
            return true;
        }
        catch (Throwable throwable) {
            ExceptionHandler exceptionHandler = ((AMQConnection)this.getConnection()).getExceptionHandler();
            String string4 = deliver.getConsumerTag();
            exceptionHandler.handleConsumerException(this, throwable, consumer, string4, "handleDelivery");
            return true;
        }
    }

    @Override
    public void processShutdownSignal(ShutdownSignalException shutdownSignalException, boolean bl2, boolean bl3) {
        this.startProcessShutdownSignal(shutdownSignalException, bl2, bl3);
        this.finishProcessShutdownSignal();
    }

    @Override
    public AMQImpl.Queue.BindOk queueBind(String string2, String string3, String string4) throws IOException {
        return this.queueBind(string2, string3, string4, (Map)null);
    }

    @Override
    public AMQImpl.Queue.BindOk queueBind(String string2, String string3, String string4, Map<String, Object> map) throws IOException {
        return (AMQImpl.Queue.BindOk)this.exnWrappingRpc(new AMQP.Queue.Bind.Builder().queue(string2).exchange(string3).routingKey(string4).arguments(map).build()).getMethod();
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
        return this.queueDeclare(UNSPECIFIED_OUT_OF_BAND, false, true, true, (Map)null);
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclare(String string2, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        return (AMQImpl.Queue.DeclareOk)this.exnWrappingRpc(new AMQP.Queue.Declare.Builder().queue(string2).durable(bl2).exclusive(bl3).autoDelete(bl4).arguments(map).build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclarePassive(String string2) throws IOException {
        return (AMQImpl.Queue.DeclareOk)this.exnWrappingRpc(new AMQP.Queue.Declare.Builder().queue(string2).passive().exclusive().autoDelete().build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.DeleteOk queueDelete(String string2) throws IOException {
        return this.queueDelete(string2, false, false);
    }

    @Override
    public AMQImpl.Queue.DeleteOk queueDelete(String string2, boolean bl2, boolean bl3) throws IOException {
        return (AMQImpl.Queue.DeleteOk)this.exnWrappingRpc(new AMQP.Queue.Delete.Builder().queue(string2).ifUnused(bl2).ifEmpty(bl3).build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.PurgeOk queuePurge(String string2) throws IOException {
        return (AMQImpl.Queue.PurgeOk)this.exnWrappingRpc(new AMQP.Queue.Purge.Builder().queue(string2).build()).getMethod();
    }

    @Override
    public AMQImpl.Queue.UnbindOk queueUnbind(String string2, String string3, String string4) throws IOException {
        return this.queueUnbind(string2, string3, string4, (Map)null);
    }

    @Override
    public AMQImpl.Queue.UnbindOk queueUnbind(String string2, String string3, String string4, Map<String, Object> map) throws IOException {
        return (AMQImpl.Queue.UnbindOk)this.exnWrappingRpc(new AMQP.Queue.Unbind.Builder().queue(string2).exchange(string3).routingKey(string4).arguments(map).build()).getMethod();
    }

    @Override
    public boolean removeConfirmListener(ConfirmListener confirmListener) {
        return this.confirmListeners.remove(confirmListener);
    }

    @Override
    public boolean removeFlowListener(FlowListener flowListener) {
        return this.flowListeners.remove(flowListener);
    }

    @Override
    public boolean removeReturnListener(ReturnListener returnListener) {
        return this.returnListeners.remove(returnListener);
    }

    @Override
    public AMQCommand rpc(Method method) throws IOException {
        return this.exnWrappingRpc(method);
    }

    @Override
    public void setDefaultConsumer(Consumer consumer) {
        this.defaultConsumer = consumer;
    }

    @Override
    public AMQImpl.Tx.CommitOk txCommit() throws IOException {
        return (AMQImpl.Tx.CommitOk)this.exnWrappingRpc(new AMQImpl.Tx.Commit()).getMethod();
    }

    @Override
    public AMQImpl.Tx.RollbackOk txRollback() throws IOException {
        return (AMQImpl.Tx.RollbackOk)this.exnWrappingRpc(new AMQImpl.Tx.Rollback()).getMethod();
    }

    @Override
    public AMQImpl.Tx.SelectOk txSelect() throws IOException {
        return (AMQImpl.Tx.SelectOk)this.exnWrappingRpc(new AMQImpl.Tx.Select()).getMethod();
    }

    @Override
    public boolean waitForConfirms() throws InterruptedException {
        try {
            boolean bl2 = this.waitForConfirms(0L);
            return bl2;
        }
        catch (TimeoutException timeoutException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean waitForConfirms(long l2) throws InterruptedException, TimeoutException {
        if (this.nextPublishSeqNo == 0L) {
            throw new IllegalStateException("Confirms not selected");
        }
        long l3 = System.currentTimeMillis();
        SortedSet<Long> sortedSet = this.unconfirmedSet;
        synchronized (sortedSet) {
            while (true) {
                if (this.getCloseReason() != null) {
                    throw Utility.fixStackTrace(this.getCloseReason());
                }
                if (this.unconfirmedSet.isEmpty()) {
                    boolean bl2 = this.onlyAcksReceived;
                    this.onlyAcksReceived = true;
                    return bl2;
                }
                if (l2 == 0L) {
                    this.unconfirmedSet.wait();
                    continue;
                }
                long l4 = System.currentTimeMillis() - l3;
                if (l2 <= l4) {
                    throw new TimeoutException();
                }
                this.unconfirmedSet.wait(l2 - l4);
            }
        }
    }

    @Override
    public void waitForConfirmsOrDie() throws IOException, InterruptedException {
        try {
            this.waitForConfirmsOrDie(0L);
            return;
        }
        catch (TimeoutException timeoutException) {
            return;
        }
    }

    @Override
    public void waitForConfirmsOrDie(long l2) throws IOException, InterruptedException, TimeoutException {
        try {
            if (!this.waitForConfirms(l2)) {
                this.close(200, "NACKS RECEIVED", true, null, false);
                throw new IOException("nacks received");
            }
        }
        catch (TimeoutException timeoutException) {
            this.close(406, "TIMEOUT WAITING FOR ACK");
            throw timeoutException;
        }
    }
}

