/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;
import com.rabbitmq.client.impl.ConsumerWorkService;
import com.rabbitmq.client.impl.UnknownChannelException;
import com.rabbitmq.utility.IntAllocator;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class ChannelManager {
    private static final int SHUTDOWN_TIMEOUT_SECONDS = 10;
    private final Map<Integer, ChannelN> _channelMap;
    private final int _channelMax;
    private final IntAllocator channelNumberAllocator;
    private final Object monitor = new Object();
    private final Set<CountDownLatch> shutdownSet;
    private final ConsumerWorkService workService;

    public ChannelManager(ConsumerWorkService consumerWorkService, int n2) {
        this._channelMap = new HashMap<Integer, ChannelN>();
        this.shutdownSet = new HashSet<CountDownLatch>();
        if (n2 == 0) {
            n2 = 65535;
        }
        this._channelMax = n2;
        this.channelNumberAllocator = new IntAllocator(1, n2);
        this.workService = consumerWorkService;
    }

    private ChannelN addNewChannel(AMQConnection aMQConnection, int n2) throws IOException {
        if (this._channelMap.containsKey(n2)) {
            throw new IllegalStateException("We have attempted to create a channel with a number that is already in use. This should never happen. Please report this as a bug.");
        }
        ChannelN channelN = new ChannelN(aMQConnection, n2, this.workService);
        this._channelMap.put(channelN.getChannelNumber(), channelN);
        return channelN;
    }

    private void scheduleShutdownProcessing() {
        Thread thread = new Thread(new Runnable(new HashSet<CountDownLatch>(this.shutdownSet), this.workService){
            final /* synthetic */ Set val$sdSet;
            final /* synthetic */ ConsumerWorkService val$ssWorkService;
            {
                this.val$sdSet = set;
                this.val$ssWorkService = consumerWorkService;
            }

            @Override
            public void run() {
                for (CountDownLatch countDownLatch : this.val$sdSet) {
                    try {
                        countDownLatch.await(10L, TimeUnit.SECONDS);
                    }
                    catch (Throwable throwable) {}
                }
                this.val$ssWorkService.shutdown();
            }
        }, "ConsumerWorkServiceShutdown");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChannelN createChannel(AMQConnection aMQConnection) throws IOException {
        ChannelN channelN;
        Object object = this.monitor;
        synchronized (object) {
            int n2 = this.channelNumberAllocator.allocate();
            if (n2 == -1) {
                return null;
            }
            channelN = this.addNewChannel(aMQConnection, n2);
        }
        channelN.open();
        return channelN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChannelN createChannel(AMQConnection aMQConnection, int n2) throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.channelNumberAllocator.reserve(n2)) {
                ChannelN channelN = this.addNewChannel(aMQConnection, n2);
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var3_3
                channelN.open();
                return channelN;
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChannelN getChannel(int n2) {
        Object object = this.monitor;
        synchronized (object) {
            ChannelN channelN = this._channelMap.get(n2);
            if (channelN == null) {
                throw new UnknownChannelException(n2);
            }
            return channelN;
        }
    }

    public int getChannelMax() {
        return this._channelMax;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleSignal(ShutdownSignalException shutdownSignalException) {
        HashSet<ChannelN> hashSet;
        Object object = this.monitor;
        synchronized (object) {
            hashSet = new HashSet<ChannelN>(this._channelMap.values());
        }
        Iterator iterator = hashSet.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.scheduleShutdownProcessing();
                return;
            }
            ChannelN channelN = (ChannelN)iterator.next();
            this.releaseChannelNumber(channelN);
            channelN.processShutdownSignal(shutdownSignalException, true, true);
            this.shutdownSet.add(channelN.getShutdownLatch());
            channelN.notifyListeners();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseChannelNumber(ChannelN channelN) {
        Object object = this.monitor;
        synchronized (object) {
            int n2 = channelN.getChannelNumber();
            ChannelN channelN2 = this._channelMap.remove(n2);
            if (channelN2 == null) {
                return;
            }
            if (channelN2 != channelN) {
                this._channelMap.put(n2, channelN2);
                return;
            }
            this.channelNumberAllocator.free(n2);
            return;
        }
    }
}

