/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.LongString;
import com.rabbitmq.client.UnexpectedMethodError;
import com.rabbitmq.client.UnknownClassOrMethodId;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.client.impl.MethodArgumentReader;
import com.rabbitmq.client.impl.MethodArgumentWriter;
import com.rabbitmq.client.impl.ValueReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AMQImpl
implements AMQP {
    public static AMQContentHeader readContentHeaderFrom(DataInputStream dataInputStream) throws IOException {
        short s2 = dataInputStream.readShort();
        switch (s2) {
            default: {
                throw new UnknownClassOrMethodId(s2);
            }
            case 60: 
        }
        return new AMQP.BasicProperties(dataInputStream);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Method readMethodFrom(DataInputStream dataInputStream) throws IOException {
        short s2 = dataInputStream.readShort();
        short s3 = dataInputStream.readShort();
        switch (s2) {
            case 10: {
                switch (s3) {
                    default: {
                        throw new UnknownClassOrMethodId(s2, s3);
                    }
                    case 10: {
                        return new Connection.Start(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 11: {
                        return new Connection.StartOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 20: {
                        return new Connection.Secure(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 21: {
                        return new Connection.SecureOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 30: {
                        return new Connection.Tune(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 31: {
                        return new Connection.TuneOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 40: {
                        return new Connection.Open(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 41: {
                        return new Connection.OpenOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 50: {
                        return new Connection.Close(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 51: {
                        return new Connection.CloseOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 60: {
                        return new Connection.Blocked(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 61: 
                }
                return new Connection.Unblocked(new MethodArgumentReader(new ValueReader(dataInputStream)));
            }
            case 20: {
                switch (s3) {
                    default: {
                        throw new UnknownClassOrMethodId(s2, s3);
                    }
                    case 10: {
                        return new Channel.Open(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 11: {
                        return new Channel.OpenOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 20: {
                        return new Channel.Flow(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 21: {
                        return new Channel.FlowOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 40: {
                        return new Channel.Close(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 41: 
                }
                return new Channel.CloseOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
            }
            case 30: {
                switch (s3) {
                    default: {
                        throw new UnknownClassOrMethodId(s2, s3);
                    }
                    case 10: {
                        return new Access.Request(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 11: 
                }
                return new Access.RequestOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
            }
            case 40: {
                switch (s3) {
                    default: {
                        throw new UnknownClassOrMethodId(s2, s3);
                    }
                    case 10: {
                        return new Exchange.Declare(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 11: {
                        return new Exchange.DeclareOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 20: {
                        return new Exchange.Delete(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 21: {
                        return new Exchange.DeleteOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 30: {
                        return new Exchange.Bind(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 31: {
                        return new Exchange.BindOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 40: {
                        return new Exchange.Unbind(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 51: 
                }
                return new Exchange.UnbindOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
            }
            case 50: {
                switch (s3) {
                    default: {
                        throw new UnknownClassOrMethodId(s2, s3);
                    }
                    case 10: {
                        return new Queue.Declare(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 11: {
                        return new Queue.DeclareOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 20: {
                        return new Queue.Bind(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 21: {
                        return new Queue.BindOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 30: {
                        return new Queue.Purge(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 31: {
                        return new Queue.PurgeOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 40: {
                        return new Queue.Delete(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 41: {
                        return new Queue.DeleteOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 50: {
                        return new Queue.Unbind(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 51: 
                }
                return new Queue.UnbindOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
            }
            case 60: {
                switch (s3) {
                    default: {
                        throw new UnknownClassOrMethodId(s2, s3);
                    }
                    case 10: {
                        return new Basic.Qos(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 11: {
                        return new Basic.QosOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 20: {
                        return new Basic.Consume(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 21: {
                        return new Basic.ConsumeOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 30: {
                        return new Basic.Cancel(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 31: {
                        return new Basic.CancelOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 40: {
                        return new Basic.Publish(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 50: {
                        return new Basic.Return(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 60: {
                        return new Basic.Deliver(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 70: {
                        return new Basic.Get(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 71: {
                        return new Basic.GetOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 72: {
                        return new Basic.GetEmpty(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 80: {
                        return new Basic.Ack(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 90: {
                        return new Basic.Reject(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 100: {
                        return new Basic.RecoverAsync(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 110: {
                        return new Basic.Recover(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 111: {
                        return new Basic.RecoverOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 120: 
                }
                return new Basic.Nack(new MethodArgumentReader(new ValueReader(dataInputStream)));
            }
            case 90: {
                switch (s3) {
                    default: {
                        throw new UnknownClassOrMethodId(s2, s3);
                    }
                    case 10: {
                        return new Tx.Select(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 11: {
                        return new Tx.SelectOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 20: {
                        return new Tx.Commit(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 21: {
                        return new Tx.CommitOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 30: {
                        return new Tx.Rollback(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 31: 
                }
                return new Tx.RollbackOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
            }
            case 85: {
                switch (s3) {
                    default: {
                        throw new UnknownClassOrMethodId(s2, s3);
                    }
                    case 10: {
                        return new Confirm.Select(new MethodArgumentReader(new ValueReader(dataInputStream)));
                    }
                    case 11: 
                }
                return new Confirm.SelectOk(new MethodArgumentReader(new ValueReader(dataInputStream)));
            }
        }
        throw new UnknownClassOrMethodId(s2, s3);
    }

    public static class Access {
        public static final int INDEX = 30;

        public static class Request
        extends Method
        implements AMQP.Access.Request {
            public static final int INDEX = 10;
            private final boolean active;
            private final boolean exclusive;
            private final boolean passive;
            private final boolean read;
            private final String realm;
            private final boolean write;

            public Request(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit());
            }

            public Request(String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'realm' must be non-null.");
                }
                this.realm = string2;
                this.exclusive = bl2;
                this.passive = bl3;
                this.active = bl4;
                this.write = bl5;
                this.read = bl6;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(realm=").append(this.realm).append(", exclusive=").append(this.exclusive).append(", passive=").append(this.passive).append(", active=").append(this.active).append(", write=").append(this.write).append(", read=").append(this.read).append(")");
            }

            @Override
            public boolean getActive() {
                return this.active;
            }

            @Override
            public boolean getExclusive() {
                return this.exclusive;
            }

            @Override
            public boolean getPassive() {
                return this.passive;
            }

            @Override
            public boolean getRead() {
                return this.read;
            }

            @Override
            public String getRealm() {
                return this.realm;
            }

            @Override
            public boolean getWrite() {
                return this.write;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 30;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "access.request";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.realm);
                methodArgumentWriter.writeBit(this.exclusive);
                methodArgumentWriter.writeBit(this.passive);
                methodArgumentWriter.writeBit(this.active);
                methodArgumentWriter.writeBit(this.write);
                methodArgumentWriter.writeBit(this.read);
            }
        }

        public static class RequestOk
        extends Method
        implements AMQP.Access.RequestOk {
            public static final int INDEX = 11;
            private final int ticket;

            public RequestOk(int n2) {
                this.ticket = n2;
            }

            public RequestOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(")");
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 30;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "access.request-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
            }
        }
    }

    public static class Basic {
        public static final int INDEX = 60;

        public static class Ack
        extends Method
        implements AMQP.Basic.Ack {
            public static final int INDEX = 80;
            private final long deliveryTag;
            private final boolean multiple;

            public Ack(long l2, boolean bl2) {
                this.deliveryTag = l2;
                this.multiple = bl2;
            }

            public Ack(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readLonglong(), methodArgumentReader.readBit());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(delivery-tag=").append(this.deliveryTag).append(", multiple=").append(this.multiple).append(")");
            }

            @Override
            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            @Override
            public boolean getMultiple() {
                return this.multiple;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 80;
            }

            @Override
            public String protocolMethodName() {
                return "basic.ack";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeLonglong(this.deliveryTag);
                methodArgumentWriter.writeBit(this.multiple);
            }
        }

        public static class Cancel
        extends Method
        implements AMQP.Basic.Cancel {
            public static final int INDEX = 30;
            private final String consumerTag;
            private final boolean nowait;

            public Cancel(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr(), methodArgumentReader.readBit());
            }

            public Cancel(String string2, boolean bl2) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                }
                this.consumerTag = string2;
                this.nowait = bl2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(consumer-tag=").append(this.consumerTag).append(", nowait=").append(this.nowait).append(")");
            }

            @Override
            public String getConsumerTag() {
                return this.consumerTag;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 30;
            }

            @Override
            public String protocolMethodName() {
                return "basic.cancel";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.consumerTag);
                methodArgumentWriter.writeBit(this.nowait);
            }
        }

        public static class CancelOk
        extends Method
        implements AMQP.Basic.CancelOk {
            public static final int INDEX = 31;
            private final String consumerTag;

            public CancelOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr());
            }

            public CancelOk(String string2) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                }
                this.consumerTag = string2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(consumer-tag=").append(this.consumerTag).append(")");
            }

            @Override
            public String getConsumerTag() {
                return this.consumerTag;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 31;
            }

            @Override
            public String protocolMethodName() {
                return "basic.cancel-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.consumerTag);
            }
        }

        public static class Consume
        extends Method
        implements AMQP.Basic.Consume {
            public static final int INDEX = 20;
            private final Map<String, Object> arguments;
            private final String consumerTag;
            private final boolean exclusive;
            private final boolean noAck;
            private final boolean noLocal;
            private final boolean nowait;
            private final String queue;
            private final int ticket;

            /*
             * Enabled aggressive block sorting
             */
            public Consume(int n2, String string2, String string3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map<String, Object> map) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                }
                this.ticket = n2;
                this.queue = string2;
                this.consumerTag = string3;
                this.noLocal = bl2;
                this.noAck = bl3;
                this.exclusive = bl4;
                this.nowait = bl5;
                Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
                this.arguments = map2;
            }

            public Consume(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readTable());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", consumer-tag=").append(this.consumerTag).append(", no-local=").append(this.noLocal).append(", no-ack=").append(this.noAck).append(", exclusive=").append(this.exclusive).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            @Override
            public String getConsumerTag() {
                return this.consumerTag;
            }

            @Override
            public boolean getExclusive() {
                return this.exclusive;
            }

            @Override
            public boolean getNoAck() {
                return this.noAck;
            }

            @Override
            public boolean getNoLocal() {
                return this.noLocal;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "basic.consume";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.queue);
                methodArgumentWriter.writeShortstr(this.consumerTag);
                methodArgumentWriter.writeBit(this.noLocal);
                methodArgumentWriter.writeBit(this.noAck);
                methodArgumentWriter.writeBit(this.exclusive);
                methodArgumentWriter.writeBit(this.nowait);
                methodArgumentWriter.writeTable(this.arguments);
            }
        }

        public static class ConsumeOk
        extends Method
        implements AMQP.Basic.ConsumeOk {
            public static final int INDEX = 21;
            private final String consumerTag;

            public ConsumeOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr());
            }

            public ConsumeOk(String string2) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                }
                this.consumerTag = string2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(consumer-tag=").append(this.consumerTag).append(")");
            }

            @Override
            public String getConsumerTag() {
                return this.consumerTag;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 21;
            }

            @Override
            public String protocolMethodName() {
                return "basic.consume-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.consumerTag);
            }
        }

        public static class Deliver
        extends Method
        implements AMQP.Basic.Deliver {
            public static final int INDEX = 60;
            private final String consumerTag;
            private final long deliveryTag;
            private final String exchange;
            private final boolean redelivered;
            private final String routingKey;

            public Deliver(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr(), methodArgumentReader.readLonglong(), methodArgumentReader.readBit(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr());
            }

            public Deliver(String string2, long l2, boolean bl2, String string3, String string4) {
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                if (string4 == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                }
                this.consumerTag = string2;
                this.deliveryTag = l2;
                this.redelivered = bl2;
                this.exchange = string3;
                this.routingKey = string4;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(consumer-tag=").append(this.consumerTag).append(", delivery-tag=").append(this.deliveryTag).append(", redelivered=").append(this.redelivered).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(")");
            }

            @Override
            public String getConsumerTag() {
                return this.consumerTag;
            }

            @Override
            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public boolean getRedelivered() {
                return this.redelivered;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public boolean hasContent() {
                return true;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 60;
            }

            @Override
            public String protocolMethodName() {
                return "basic.deliver";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.consumerTag);
                methodArgumentWriter.writeLonglong(this.deliveryTag);
                methodArgumentWriter.writeBit(this.redelivered);
                methodArgumentWriter.writeShortstr(this.exchange);
                methodArgumentWriter.writeShortstr(this.routingKey);
            }
        }

        public static class Get
        extends Method
        implements AMQP.Basic.Get {
            public static final int INDEX = 70;
            private final boolean noAck;
            private final String queue;
            private final int ticket;

            public Get(int n2, String string2, boolean bl2) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                this.ticket = n2;
                this.queue = string2;
                this.noAck = bl2;
            }

            public Get(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", no-ack=").append(this.noAck).append(")");
            }

            @Override
            public boolean getNoAck() {
                return this.noAck;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 70;
            }

            @Override
            public String protocolMethodName() {
                return "basic.get";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.queue);
                methodArgumentWriter.writeBit(this.noAck);
            }
        }

        public static class GetEmpty
        extends Method
        implements AMQP.Basic.GetEmpty {
            public static final int INDEX = 72;
            private final String clusterId;

            public GetEmpty(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr());
            }

            public GetEmpty(String string2) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'clusterId' must be non-null.");
                }
                this.clusterId = string2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(cluster-id=").append(this.clusterId).append(")");
            }

            @Override
            public String getClusterId() {
                return this.clusterId;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 72;
            }

            @Override
            public String protocolMethodName() {
                return "basic.get-empty";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.clusterId);
            }
        }

        public static class GetOk
        extends Method
        implements AMQP.Basic.GetOk {
            public static final int INDEX = 71;
            private final long deliveryTag;
            private final String exchange;
            private final int messageCount;
            private final boolean redelivered;
            private final String routingKey;

            public GetOk(long l2, boolean bl2, String string2, String string3, int n2) {
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.deliveryTag = l2;
                this.redelivered = bl2;
                this.exchange = string2;
                this.routingKey = string3;
                this.messageCount = n2;
            }

            public GetOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readLonglong(), methodArgumentReader.readBit(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readLong());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(delivery-tag=").append(this.deliveryTag).append(", redelivered=").append(this.redelivered).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(", message-count=").append(this.messageCount).append(")");
            }

            @Override
            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public int getMessageCount() {
                return this.messageCount;
            }

            @Override
            public boolean getRedelivered() {
                return this.redelivered;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public boolean hasContent() {
                return true;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 71;
            }

            @Override
            public String protocolMethodName() {
                return "basic.get-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeLonglong(this.deliveryTag);
                methodArgumentWriter.writeBit(this.redelivered);
                methodArgumentWriter.writeShortstr(this.exchange);
                methodArgumentWriter.writeShortstr(this.routingKey);
                methodArgumentWriter.writeLong(this.messageCount);
            }
        }

        public static class Nack
        extends Method
        implements AMQP.Basic.Nack {
            public static final int INDEX = 120;
            private final long deliveryTag;
            private final boolean multiple;
            private final boolean requeue;

            public Nack(long l2, boolean bl2, boolean bl3) {
                this.deliveryTag = l2;
                this.multiple = bl2;
                this.requeue = bl3;
            }

            public Nack(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readLonglong(), methodArgumentReader.readBit(), methodArgumentReader.readBit());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(delivery-tag=").append(this.deliveryTag).append(", multiple=").append(this.multiple).append(", requeue=").append(this.requeue).append(")");
            }

            @Override
            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            @Override
            public boolean getMultiple() {
                return this.multiple;
            }

            @Override
            public boolean getRequeue() {
                return this.requeue;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 120;
            }

            @Override
            public String protocolMethodName() {
                return "basic.nack";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeLonglong(this.deliveryTag);
                methodArgumentWriter.writeBit(this.multiple);
                methodArgumentWriter.writeBit(this.requeue);
            }
        }

        public static class Publish
        extends Method
        implements AMQP.Basic.Publish {
            public static final int INDEX = 40;
            private final String exchange;
            private final boolean immediate;
            private final boolean mandatory;
            private final String routingKey;
            private final int ticket;

            public Publish(int n2, String string2, String string3, boolean bl2, boolean bl3) {
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.ticket = n2;
                this.exchange = string2;
                this.routingKey = string3;
                this.mandatory = bl2;
                this.immediate = bl3;
            }

            public Publish(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit(), methodArgumentReader.readBit());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(", mandatory=").append(this.mandatory).append(", immediate=").append(this.immediate).append(")");
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public boolean getImmediate() {
                return this.immediate;
            }

            @Override
            public boolean getMandatory() {
                return this.mandatory;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return true;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 40;
            }

            @Override
            public String protocolMethodName() {
                return "basic.publish";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.exchange);
                methodArgumentWriter.writeShortstr(this.routingKey);
                methodArgumentWriter.writeBit(this.mandatory);
                methodArgumentWriter.writeBit(this.immediate);
            }
        }

        public static class Qos
        extends Method
        implements AMQP.Basic.Qos {
            public static final int INDEX = 10;
            private final boolean global;
            private final int prefetchCount;
            private final int prefetchSize;

            public Qos(int n2, int n3, boolean bl2) {
                this.prefetchSize = n2;
                this.prefetchCount = n3;
                this.global = bl2;
            }

            public Qos(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readLong(), methodArgumentReader.readShort(), methodArgumentReader.readBit());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(prefetch-size=").append(this.prefetchSize).append(", prefetch-count=").append(this.prefetchCount).append(", global=").append(this.global).append(")");
            }

            @Override
            public boolean getGlobal() {
                return this.global;
            }

            @Override
            public int getPrefetchCount() {
                return this.prefetchCount;
            }

            @Override
            public int getPrefetchSize() {
                return this.prefetchSize;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "basic.qos";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeLong(this.prefetchSize);
                methodArgumentWriter.writeShort(this.prefetchCount);
                methodArgumentWriter.writeBit(this.global);
            }
        }

        public static class QosOk
        extends Method
        implements AMQP.Basic.QosOk {
            public static final int INDEX = 11;

            public QosOk() {
            }

            public QosOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "basic.qos-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class Recover
        extends Method
        implements AMQP.Basic.Recover {
            public static final int INDEX = 110;
            private final boolean requeue;

            public Recover(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readBit());
            }

            public Recover(boolean bl2) {
                this.requeue = bl2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(requeue=").append(this.requeue).append(")");
            }

            @Override
            public boolean getRequeue() {
                return this.requeue;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 110;
            }

            @Override
            public String protocolMethodName() {
                return "basic.recover";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeBit(this.requeue);
            }
        }

        public static class RecoverAsync
        extends Method
        implements AMQP.Basic.RecoverAsync {
            public static final int INDEX = 100;
            private final boolean requeue;

            public RecoverAsync(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readBit());
            }

            public RecoverAsync(boolean bl2) {
                this.requeue = bl2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(requeue=").append(this.requeue).append(")");
            }

            @Override
            public boolean getRequeue() {
                return this.requeue;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 100;
            }

            @Override
            public String protocolMethodName() {
                return "basic.recover-async";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeBit(this.requeue);
            }
        }

        public static class RecoverOk
        extends Method
        implements AMQP.Basic.RecoverOk {
            public static final int INDEX = 111;

            public RecoverOk() {
            }

            public RecoverOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 111;
            }

            @Override
            public String protocolMethodName() {
                return "basic.recover-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class Reject
        extends Method
        implements AMQP.Basic.Reject {
            public static final int INDEX = 90;
            private final long deliveryTag;
            private final boolean requeue;

            public Reject(long l2, boolean bl2) {
                this.deliveryTag = l2;
                this.requeue = bl2;
            }

            public Reject(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readLonglong(), methodArgumentReader.readBit());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(delivery-tag=").append(this.deliveryTag).append(", requeue=").append(this.requeue).append(")");
            }

            @Override
            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            @Override
            public boolean getRequeue() {
                return this.requeue;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 90;
            }

            @Override
            public String protocolMethodName() {
                return "basic.reject";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeLonglong(this.deliveryTag);
                methodArgumentWriter.writeBit(this.requeue);
            }
        }

        public static class Return
        extends Method
        implements AMQP.Basic.Return {
            public static final int INDEX = 50;
            private final String exchange;
            private final int replyCode;
            private final String replyText;
            private final String routingKey;

            public Return(int n2, String string2, String string3, String string4) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'replyText' must be non-null.");
                }
                if (string4 == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.replyCode = n2;
                this.replyText = string2;
                this.exchange = string3;
                this.routingKey = string4;
            }

            public Return(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(reply-code=").append(this.replyCode).append(", reply-text=").append(this.replyText).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(")");
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public int getReplyCode() {
                return this.replyCode;
            }

            @Override
            public String getReplyText() {
                return this.replyText;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public boolean hasContent() {
                return true;
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 50;
            }

            @Override
            public String protocolMethodName() {
                return "basic.return";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.replyCode);
                methodArgumentWriter.writeShortstr(this.replyText);
                methodArgumentWriter.writeShortstr(this.exchange);
                methodArgumentWriter.writeShortstr(this.routingKey);
            }
        }
    }

    public static class Channel {
        public static final int INDEX = 20;

        public static class Close
        extends Method
        implements AMQP.Channel.Close {
            public static final int INDEX = 40;
            private final int classId;
            private final int methodId;
            private final int replyCode;
            private final String replyText;

            public Close(int n2, String string2, int n3, int n4) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'replyText' must be non-null.");
                }
                this.replyCode = n2;
                this.replyText = string2;
                this.classId = n3;
                this.methodId = n4;
            }

            public Close(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readShort(), methodArgumentReader.readShort());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(reply-code=").append(this.replyCode).append(", reply-text=").append(this.replyText).append(", class-id=").append(this.classId).append(", method-id=").append(this.methodId).append(")");
            }

            @Override
            public int getClassId() {
                return this.classId;
            }

            @Override
            public int getMethodId() {
                return this.methodId;
            }

            @Override
            public int getReplyCode() {
                return this.replyCode;
            }

            @Override
            public String getReplyText() {
                return this.replyText;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 20;
            }

            @Override
            public int protocolMethodId() {
                return 40;
            }

            @Override
            public String protocolMethodName() {
                return "channel.close";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.replyCode);
                methodArgumentWriter.writeShortstr(this.replyText);
                methodArgumentWriter.writeShort(this.classId);
                methodArgumentWriter.writeShort(this.methodId);
            }
        }

        public static class CloseOk
        extends Method
        implements AMQP.Channel.CloseOk {
            public static final int INDEX = 41;

            public CloseOk() {
            }

            public CloseOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 20;
            }

            @Override
            public int protocolMethodId() {
                return 41;
            }

            @Override
            public String protocolMethodName() {
                return "channel.close-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class Flow
        extends Method
        implements AMQP.Channel.Flow {
            public static final int INDEX = 20;
            private final boolean active;

            public Flow(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readBit());
            }

            public Flow(boolean bl2) {
                this.active = bl2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(active=").append(this.active).append(")");
            }

            @Override
            public boolean getActive() {
                return this.active;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 20;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "channel.flow";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeBit(this.active);
            }
        }

        public static class FlowOk
        extends Method
        implements AMQP.Channel.FlowOk {
            public static final int INDEX = 21;
            private final boolean active;

            public FlowOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readBit());
            }

            public FlowOk(boolean bl2) {
                this.active = bl2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(active=").append(this.active).append(")");
            }

            @Override
            public boolean getActive() {
                return this.active;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 20;
            }

            @Override
            public int protocolMethodId() {
                return 21;
            }

            @Override
            public String protocolMethodName() {
                return "channel.flow-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeBit(this.active);
            }
        }

        public static class Open
        extends Method
        implements AMQP.Channel.Open {
            public static final int INDEX = 10;
            private final String outOfBand;

            public Open(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr());
            }

            public Open(String string2) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'outOfBand' must be non-null.");
                }
                this.outOfBand = string2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(out-of-band=").append(this.outOfBand).append(")");
            }

            @Override
            public String getOutOfBand() {
                return this.outOfBand;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 20;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "channel.open";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.outOfBand);
            }
        }

        public static class OpenOk
        extends Method
        implements AMQP.Channel.OpenOk {
            public static final int INDEX = 11;
            private final LongString channelId;

            public OpenOk(LongString longString) {
                if (longString == null) {
                    throw new IllegalStateException("Invalid configuration: 'channelId' must be non-null.");
                }
                this.channelId = longString;
            }

            public OpenOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readLongstr());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(channel-id=").append(this.channelId).append(")");
            }

            @Override
            public LongString getChannelId() {
                return this.channelId;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 20;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "channel.open-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeLongstr(this.channelId);
            }
        }
    }

    public static class Confirm {
        public static final int INDEX = 85;

        public static class Select
        extends Method
        implements AMQP.Confirm.Select {
            public static final int INDEX = 10;
            private final boolean nowait;

            public Select(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readBit());
            }

            public Select(boolean bl2) {
                this.nowait = bl2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(nowait=").append(this.nowait).append(")");
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 85;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "confirm.select";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeBit(this.nowait);
            }
        }

        public static class SelectOk
        extends Method
        implements AMQP.Confirm.SelectOk {
            public static final int INDEX = 11;

            public SelectOk() {
            }

            public SelectOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 85;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "confirm.select-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }
    }

    public static class Connection {
        public static final int INDEX = 10;

        public static class Blocked
        extends Method
        implements AMQP.Connection.Blocked {
            public static final int INDEX = 60;
            private final String reason;

            public Blocked(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr());
            }

            public Blocked(String string2) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'reason' must be non-null.");
                }
                this.reason = string2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(reason=").append(this.reason).append(")");
            }

            @Override
            public String getReason() {
                return this.reason;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 60;
            }

            @Override
            public String protocolMethodName() {
                return "connection.blocked";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.reason);
            }
        }

        public static class Close
        extends Method
        implements AMQP.Connection.Close {
            public static final int INDEX = 50;
            private final int classId;
            private final int methodId;
            private final int replyCode;
            private final String replyText;

            public Close(int n2, String string2, int n3, int n4) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'replyText' must be non-null.");
                }
                this.replyCode = n2;
                this.replyText = string2;
                this.classId = n3;
                this.methodId = n4;
            }

            public Close(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readShort(), methodArgumentReader.readShort());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(reply-code=").append(this.replyCode).append(", reply-text=").append(this.replyText).append(", class-id=").append(this.classId).append(", method-id=").append(this.methodId).append(")");
            }

            @Override
            public int getClassId() {
                return this.classId;
            }

            @Override
            public int getMethodId() {
                return this.methodId;
            }

            @Override
            public int getReplyCode() {
                return this.replyCode;
            }

            @Override
            public String getReplyText() {
                return this.replyText;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 50;
            }

            @Override
            public String protocolMethodName() {
                return "connection.close";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.replyCode);
                methodArgumentWriter.writeShortstr(this.replyText);
                methodArgumentWriter.writeShort(this.classId);
                methodArgumentWriter.writeShort(this.methodId);
            }
        }

        public static class CloseOk
        extends Method
        implements AMQP.Connection.CloseOk {
            public static final int INDEX = 51;

            public CloseOk() {
            }

            public CloseOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 51;
            }

            @Override
            public String protocolMethodName() {
                return "connection.close-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class Open
        extends Method
        implements AMQP.Connection.Open {
            public static final int INDEX = 40;
            private final String capabilities;
            private final boolean insist;
            private final String virtualHost;

            public Open(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit());
            }

            public Open(String string2, String string3, boolean bl2) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'virtualHost' must be non-null.");
                }
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'capabilities' must be non-null.");
                }
                this.virtualHost = string2;
                this.capabilities = string3;
                this.insist = bl2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(virtual-host=").append(this.virtualHost).append(", capabilities=").append(this.capabilities).append(", insist=").append(this.insist).append(")");
            }

            @Override
            public String getCapabilities() {
                return this.capabilities;
            }

            @Override
            public boolean getInsist() {
                return this.insist;
            }

            @Override
            public String getVirtualHost() {
                return this.virtualHost;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 40;
            }

            @Override
            public String protocolMethodName() {
                return "connection.open";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.virtualHost);
                methodArgumentWriter.writeShortstr(this.capabilities);
                methodArgumentWriter.writeBit(this.insist);
            }
        }

        public static class OpenOk
        extends Method
        implements AMQP.Connection.OpenOk {
            public static final int INDEX = 41;
            private final String knownHosts;

            public OpenOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr());
            }

            public OpenOk(String string2) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'knownHosts' must be non-null.");
                }
                this.knownHosts = string2;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(known-hosts=").append(this.knownHosts).append(")");
            }

            @Override
            public String getKnownHosts() {
                return this.knownHosts;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 41;
            }

            @Override
            public String protocolMethodName() {
                return "connection.open-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.knownHosts);
            }
        }

        public static class Secure
        extends Method
        implements AMQP.Connection.Secure {
            public static final int INDEX = 20;
            private final LongString challenge;

            public Secure(LongString longString) {
                if (longString == null) {
                    throw new IllegalStateException("Invalid configuration: 'challenge' must be non-null.");
                }
                this.challenge = longString;
            }

            public Secure(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readLongstr());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(challenge=").append(this.challenge).append(")");
            }

            @Override
            public LongString getChallenge() {
                return this.challenge;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "connection.secure";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeLongstr(this.challenge);
            }
        }

        public static class SecureOk
        extends Method
        implements AMQP.Connection.SecureOk {
            public static final int INDEX = 21;
            private final LongString response;

            public SecureOk(LongString longString) {
                if (longString == null) {
                    throw new IllegalStateException("Invalid configuration: 'response' must be non-null.");
                }
                this.response = longString;
            }

            public SecureOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readLongstr());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(response=").append(this.response).append(")");
            }

            @Override
            public LongString getResponse() {
                return this.response;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 21;
            }

            @Override
            public String protocolMethodName() {
                return "connection.secure-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeLongstr(this.response);
            }
        }

        public static class Start
        extends Method
        implements AMQP.Connection.Start {
            public static final int INDEX = 10;
            private final LongString locales;
            private final LongString mechanisms;
            private final Map<String, Object> serverProperties;
            private final int versionMajor;
            private final int versionMinor;

            /*
             * Enabled aggressive block sorting
             */
            public Start(int n2, int n3, Map<String, Object> map, LongString longString, LongString longString2) {
                if (longString == null) {
                    throw new IllegalStateException("Invalid configuration: 'mechanisms' must be non-null.");
                }
                if (longString2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'locales' must be non-null.");
                }
                this.versionMajor = n2;
                this.versionMinor = n3;
                Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
                this.serverProperties = map2;
                this.mechanisms = longString;
                this.locales = longString2;
            }

            public Start(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readOctet(), methodArgumentReader.readOctet(), methodArgumentReader.readTable(), methodArgumentReader.readLongstr(), methodArgumentReader.readLongstr());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(version-major=").append(this.versionMajor).append(", version-minor=").append(this.versionMinor).append(", server-properties=").append(this.serverProperties).append(", mechanisms=").append(this.mechanisms).append(", locales=").append(this.locales).append(")");
            }

            @Override
            public LongString getLocales() {
                return this.locales;
            }

            @Override
            public LongString getMechanisms() {
                return this.mechanisms;
            }

            @Override
            public Map<String, Object> getServerProperties() {
                return this.serverProperties;
            }

            @Override
            public int getVersionMajor() {
                return this.versionMajor;
            }

            @Override
            public int getVersionMinor() {
                return this.versionMinor;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "connection.start";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeOctet(this.versionMajor);
                methodArgumentWriter.writeOctet(this.versionMinor);
                methodArgumentWriter.writeTable(this.serverProperties);
                methodArgumentWriter.writeLongstr(this.mechanisms);
                methodArgumentWriter.writeLongstr(this.locales);
            }
        }

        public static class StartOk
        extends Method
        implements AMQP.Connection.StartOk {
            public static final int INDEX = 11;
            private final Map<String, Object> clientProperties;
            private final String locale;
            private final String mechanism;
            private final LongString response;

            public StartOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readTable(), methodArgumentReader.readShortstr(), methodArgumentReader.readLongstr(), methodArgumentReader.readShortstr());
            }

            /*
             * Enabled aggressive block sorting
             */
            public StartOk(Map<String, Object> map, String string2, LongString longString, String string3) {
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'locale' must be non-null.");
                }
                if (longString == null) {
                    throw new IllegalStateException("Invalid configuration: 'response' must be non-null.");
                }
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'mechanism' must be non-null.");
                }
                Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
                this.clientProperties = map2;
                this.mechanism = string2;
                this.response = longString;
                this.locale = string3;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(client-properties=").append(this.clientProperties).append(", mechanism=").append(this.mechanism).append(", response=").append(this.response).append(", locale=").append(this.locale).append(")");
            }

            @Override
            public Map<String, Object> getClientProperties() {
                return this.clientProperties;
            }

            @Override
            public String getLocale() {
                return this.locale;
            }

            @Override
            public String getMechanism() {
                return this.mechanism;
            }

            @Override
            public LongString getResponse() {
                return this.response;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "connection.start-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeTable(this.clientProperties);
                methodArgumentWriter.writeShortstr(this.mechanism);
                methodArgumentWriter.writeLongstr(this.response);
                methodArgumentWriter.writeShortstr(this.locale);
            }
        }

        public static class Tune
        extends Method
        implements AMQP.Connection.Tune {
            public static final int INDEX = 30;
            private final int channelMax;
            private final int frameMax;
            private final int heartbeat;

            public Tune(int n2, int n3, int n4) {
                this.channelMax = n2;
                this.frameMax = n3;
                this.heartbeat = n4;
            }

            public Tune(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readLong(), methodArgumentReader.readShort());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(channel-max=").append(this.channelMax).append(", frame-max=").append(this.frameMax).append(", heartbeat=").append(this.heartbeat).append(")");
            }

            @Override
            public int getChannelMax() {
                return this.channelMax;
            }

            @Override
            public int getFrameMax() {
                return this.frameMax;
            }

            @Override
            public int getHeartbeat() {
                return this.heartbeat;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 30;
            }

            @Override
            public String protocolMethodName() {
                return "connection.tune";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.channelMax);
                methodArgumentWriter.writeLong(this.frameMax);
                methodArgumentWriter.writeShort(this.heartbeat);
            }
        }

        public static class TuneOk
        extends Method
        implements AMQP.Connection.TuneOk {
            public static final int INDEX = 31;
            private final int channelMax;
            private final int frameMax;
            private final int heartbeat;

            public TuneOk(int n2, int n3, int n4) {
                this.channelMax = n2;
                this.frameMax = n3;
                this.heartbeat = n4;
            }

            public TuneOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readLong(), methodArgumentReader.readShort());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(channel-max=").append(this.channelMax).append(", frame-max=").append(this.frameMax).append(", heartbeat=").append(this.heartbeat).append(")");
            }

            @Override
            public int getChannelMax() {
                return this.channelMax;
            }

            @Override
            public int getFrameMax() {
                return this.frameMax;
            }

            @Override
            public int getHeartbeat() {
                return this.heartbeat;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 31;
            }

            @Override
            public String protocolMethodName() {
                return "connection.tune-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.channelMax);
                methodArgumentWriter.writeLong(this.frameMax);
                methodArgumentWriter.writeShort(this.heartbeat);
            }
        }

        public static class Unblocked
        extends Method
        implements AMQP.Connection.Unblocked {
            public static final int INDEX = 61;

            public Unblocked() {
            }

            public Unblocked(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 61;
            }

            @Override
            public String protocolMethodName() {
                return "connection.unblocked";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }
    }

    public static class DefaultMethodVisitor
    implements MethodVisitor {
        @Override
        public Object visit(Access.Request request) throws IOException {
            throw new UnexpectedMethodError(request);
        }

        @Override
        public Object visit(Access.RequestOk requestOk) throws IOException {
            throw new UnexpectedMethodError(requestOk);
        }

        @Override
        public Object visit(Basic.Ack ack) throws IOException {
            throw new UnexpectedMethodError(ack);
        }

        @Override
        public Object visit(Basic.Cancel cancel) throws IOException {
            throw new UnexpectedMethodError(cancel);
        }

        @Override
        public Object visit(Basic.CancelOk cancelOk) throws IOException {
            throw new UnexpectedMethodError(cancelOk);
        }

        @Override
        public Object visit(Basic.Consume consume) throws IOException {
            throw new UnexpectedMethodError(consume);
        }

        @Override
        public Object visit(Basic.ConsumeOk consumeOk) throws IOException {
            throw new UnexpectedMethodError(consumeOk);
        }

        @Override
        public Object visit(Basic.Deliver deliver) throws IOException {
            throw new UnexpectedMethodError(deliver);
        }

        @Override
        public Object visit(Basic.Get get) throws IOException {
            throw new UnexpectedMethodError(get);
        }

        @Override
        public Object visit(Basic.GetEmpty getEmpty) throws IOException {
            throw new UnexpectedMethodError(getEmpty);
        }

        @Override
        public Object visit(Basic.GetOk getOk) throws IOException {
            throw new UnexpectedMethodError(getOk);
        }

        @Override
        public Object visit(Basic.Nack nack) throws IOException {
            throw new UnexpectedMethodError(nack);
        }

        @Override
        public Object visit(Basic.Publish publish) throws IOException {
            throw new UnexpectedMethodError(publish);
        }

        @Override
        public Object visit(Basic.Qos qos) throws IOException {
            throw new UnexpectedMethodError(qos);
        }

        @Override
        public Object visit(Basic.QosOk qosOk) throws IOException {
            throw new UnexpectedMethodError(qosOk);
        }

        @Override
        public Object visit(Basic.Recover recover) throws IOException {
            throw new UnexpectedMethodError(recover);
        }

        @Override
        public Object visit(Basic.RecoverAsync recoverAsync) throws IOException {
            throw new UnexpectedMethodError(recoverAsync);
        }

        @Override
        public Object visit(Basic.RecoverOk recoverOk) throws IOException {
            throw new UnexpectedMethodError(recoverOk);
        }

        @Override
        public Object visit(Basic.Reject reject) throws IOException {
            throw new UnexpectedMethodError(reject);
        }

        @Override
        public Object visit(Basic.Return return_) throws IOException {
            throw new UnexpectedMethodError(return_);
        }

        @Override
        public Object visit(Channel.Close close) throws IOException {
            throw new UnexpectedMethodError(close);
        }

        @Override
        public Object visit(Channel.CloseOk closeOk) throws IOException {
            throw new UnexpectedMethodError(closeOk);
        }

        @Override
        public Object visit(Channel.Flow flow) throws IOException {
            throw new UnexpectedMethodError(flow);
        }

        @Override
        public Object visit(Channel.FlowOk flowOk) throws IOException {
            throw new UnexpectedMethodError(flowOk);
        }

        @Override
        public Object visit(Channel.Open open) throws IOException {
            throw new UnexpectedMethodError(open);
        }

        @Override
        public Object visit(Channel.OpenOk openOk) throws IOException {
            throw new UnexpectedMethodError(openOk);
        }

        @Override
        public Object visit(Confirm.Select select) throws IOException {
            throw new UnexpectedMethodError(select);
        }

        @Override
        public Object visit(Confirm.SelectOk selectOk) throws IOException {
            throw new UnexpectedMethodError(selectOk);
        }

        @Override
        public Object visit(Connection.Blocked blocked) throws IOException {
            throw new UnexpectedMethodError(blocked);
        }

        @Override
        public Object visit(Connection.Close close) throws IOException {
            throw new UnexpectedMethodError(close);
        }

        @Override
        public Object visit(Connection.CloseOk closeOk) throws IOException {
            throw new UnexpectedMethodError(closeOk);
        }

        @Override
        public Object visit(Connection.Open open) throws IOException {
            throw new UnexpectedMethodError(open);
        }

        @Override
        public Object visit(Connection.OpenOk openOk) throws IOException {
            throw new UnexpectedMethodError(openOk);
        }

        @Override
        public Object visit(Connection.Secure secure) throws IOException {
            throw new UnexpectedMethodError(secure);
        }

        @Override
        public Object visit(Connection.SecureOk secureOk) throws IOException {
            throw new UnexpectedMethodError(secureOk);
        }

        @Override
        public Object visit(Connection.Start start) throws IOException {
            throw new UnexpectedMethodError(start);
        }

        @Override
        public Object visit(Connection.StartOk startOk) throws IOException {
            throw new UnexpectedMethodError(startOk);
        }

        @Override
        public Object visit(Connection.Tune tune) throws IOException {
            throw new UnexpectedMethodError(tune);
        }

        @Override
        public Object visit(Connection.TuneOk tuneOk) throws IOException {
            throw new UnexpectedMethodError(tuneOk);
        }

        @Override
        public Object visit(Connection.Unblocked unblocked) throws IOException {
            throw new UnexpectedMethodError(unblocked);
        }

        @Override
        public Object visit(Exchange.Bind bind) throws IOException {
            throw new UnexpectedMethodError(bind);
        }

        @Override
        public Object visit(Exchange.BindOk bindOk) throws IOException {
            throw new UnexpectedMethodError(bindOk);
        }

        @Override
        public Object visit(Exchange.Declare declare) throws IOException {
            throw new UnexpectedMethodError(declare);
        }

        @Override
        public Object visit(Exchange.DeclareOk declareOk) throws IOException {
            throw new UnexpectedMethodError(declareOk);
        }

        @Override
        public Object visit(Exchange.Delete delete) throws IOException {
            throw new UnexpectedMethodError(delete);
        }

        @Override
        public Object visit(Exchange.DeleteOk deleteOk) throws IOException {
            throw new UnexpectedMethodError(deleteOk);
        }

        @Override
        public Object visit(Exchange.Unbind unbind) throws IOException {
            throw new UnexpectedMethodError(unbind);
        }

        @Override
        public Object visit(Exchange.UnbindOk unbindOk) throws IOException {
            throw new UnexpectedMethodError(unbindOk);
        }

        @Override
        public Object visit(Queue.Bind bind) throws IOException {
            throw new UnexpectedMethodError(bind);
        }

        @Override
        public Object visit(Queue.BindOk bindOk) throws IOException {
            throw new UnexpectedMethodError(bindOk);
        }

        @Override
        public Object visit(Queue.Declare declare) throws IOException {
            throw new UnexpectedMethodError(declare);
        }

        @Override
        public Object visit(Queue.DeclareOk declareOk) throws IOException {
            throw new UnexpectedMethodError(declareOk);
        }

        @Override
        public Object visit(Queue.Delete delete) throws IOException {
            throw new UnexpectedMethodError(delete);
        }

        @Override
        public Object visit(Queue.DeleteOk deleteOk) throws IOException {
            throw new UnexpectedMethodError(deleteOk);
        }

        @Override
        public Object visit(Queue.Purge purge) throws IOException {
            throw new UnexpectedMethodError(purge);
        }

        @Override
        public Object visit(Queue.PurgeOk purgeOk) throws IOException {
            throw new UnexpectedMethodError(purgeOk);
        }

        @Override
        public Object visit(Queue.Unbind unbind) throws IOException {
            throw new UnexpectedMethodError(unbind);
        }

        @Override
        public Object visit(Queue.UnbindOk unbindOk) throws IOException {
            throw new UnexpectedMethodError(unbindOk);
        }

        @Override
        public Object visit(Tx.Commit commit) throws IOException {
            throw new UnexpectedMethodError(commit);
        }

        @Override
        public Object visit(Tx.CommitOk commitOk) throws IOException {
            throw new UnexpectedMethodError(commitOk);
        }

        @Override
        public Object visit(Tx.Rollback rollback) throws IOException {
            throw new UnexpectedMethodError(rollback);
        }

        @Override
        public Object visit(Tx.RollbackOk rollbackOk) throws IOException {
            throw new UnexpectedMethodError(rollbackOk);
        }

        @Override
        public Object visit(Tx.Select select) throws IOException {
            throw new UnexpectedMethodError(select);
        }

        @Override
        public Object visit(Tx.SelectOk selectOk) throws IOException {
            throw new UnexpectedMethodError(selectOk);
        }
    }

    public static class Exchange {
        public static final int INDEX = 40;

        public static class Bind
        extends Method
        implements AMQP.Exchange.Bind {
            public static final int INDEX = 30;
            private final Map<String, Object> arguments;
            private final String destination;
            private final boolean nowait;
            private final String routingKey;
            private final String source;
            private final int ticket;

            /*
             * Enabled aggressive block sorting
             */
            public Bind(int n2, String string2, String string3, String string4, boolean bl2, Map<String, Object> map) {
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'source' must be non-null.");
                }
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'destination' must be non-null.");
                }
                if (string4 == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                this.ticket = n2;
                this.destination = string2;
                this.source = string3;
                this.routingKey = string4;
                this.nowait = bl2;
                Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
                this.arguments = map2;
            }

            public Bind(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit(), methodArgumentReader.readTable());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", destination=").append(this.destination).append(", source=").append(this.source).append(", routing-key=").append(this.routingKey).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            @Override
            public String getDestination() {
                return this.destination;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public String getSource() {
                return this.source;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 30;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.bind";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.destination);
                methodArgumentWriter.writeShortstr(this.source);
                methodArgumentWriter.writeShortstr(this.routingKey);
                methodArgumentWriter.writeBit(this.nowait);
                methodArgumentWriter.writeTable(this.arguments);
            }
        }

        public static class BindOk
        extends Method
        implements AMQP.Exchange.BindOk {
            public static final int INDEX = 31;

            public BindOk() {
            }

            public BindOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 31;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.bind-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class Declare
        extends Method
        implements AMQP.Exchange.Declare {
            public static final int INDEX = 10;
            private final Map<String, Object> arguments;
            private final boolean autoDelete;
            private final boolean durable;
            private final String exchange;
            private final boolean internal;
            private final boolean nowait;
            private final boolean passive;
            private final int ticket;
            private final String type;

            /*
             * Enabled aggressive block sorting
             */
            public Declare(int n2, String string2, String string3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Map<String, Object> map) {
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'type' must be non-null.");
                }
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.ticket = n2;
                this.exchange = string2;
                this.type = string3;
                this.passive = bl2;
                this.durable = bl3;
                this.autoDelete = bl4;
                this.internal = bl5;
                this.nowait = bl6;
                Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
                this.arguments = map2;
            }

            public Declare(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readTable());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", exchange=").append(this.exchange).append(", type=").append(this.type).append(", passive=").append(this.passive).append(", durable=").append(this.durable).append(", auto-delete=").append(this.autoDelete).append(", internal=").append(this.internal).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            @Override
            public boolean getAutoDelete() {
                return this.autoDelete;
            }

            @Override
            public boolean getDurable() {
                return this.durable;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public boolean getInternal() {
                return this.internal;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public boolean getPassive() {
                return this.passive;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getType() {
                return this.type;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.declare";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.exchange);
                methodArgumentWriter.writeShortstr(this.type);
                methodArgumentWriter.writeBit(this.passive);
                methodArgumentWriter.writeBit(this.durable);
                methodArgumentWriter.writeBit(this.autoDelete);
                methodArgumentWriter.writeBit(this.internal);
                methodArgumentWriter.writeBit(this.nowait);
                methodArgumentWriter.writeTable(this.arguments);
            }
        }

        public static class DeclareOk
        extends Method
        implements AMQP.Exchange.DeclareOk {
            public static final int INDEX = 11;

            public DeclareOk() {
            }

            public DeclareOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.declare-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class Delete
        extends Method
        implements AMQP.Exchange.Delete {
            public static final int INDEX = 20;
            private final String exchange;
            private final boolean ifUnused;
            private final boolean nowait;
            private final int ticket;

            public Delete(int n2, String string2, boolean bl2, boolean bl3) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.ticket = n2;
                this.exchange = string2;
                this.ifUnused = bl2;
                this.nowait = bl3;
            }

            public Delete(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit(), methodArgumentReader.readBit());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", exchange=").append(this.exchange).append(", if-unused=").append(this.ifUnused).append(", nowait=").append(this.nowait).append(")");
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public boolean getIfUnused() {
                return this.ifUnused;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.delete";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.exchange);
                methodArgumentWriter.writeBit(this.ifUnused);
                methodArgumentWriter.writeBit(this.nowait);
            }
        }

        public static class DeleteOk
        extends Method
        implements AMQP.Exchange.DeleteOk {
            public static final int INDEX = 21;

            public DeleteOk() {
            }

            public DeleteOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 21;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.delete-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class Unbind
        extends Method
        implements AMQP.Exchange.Unbind {
            public static final int INDEX = 40;
            private final Map<String, Object> arguments;
            private final String destination;
            private final boolean nowait;
            private final String routingKey;
            private final String source;
            private final int ticket;

            /*
             * Enabled aggressive block sorting
             */
            public Unbind(int n2, String string2, String string3, String string4, boolean bl2, Map<String, Object> map) {
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'source' must be non-null.");
                }
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'destination' must be non-null.");
                }
                if (string4 == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                this.ticket = n2;
                this.destination = string2;
                this.source = string3;
                this.routingKey = string4;
                this.nowait = bl2;
                Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
                this.arguments = map2;
            }

            public Unbind(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit(), methodArgumentReader.readTable());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", destination=").append(this.destination).append(", source=").append(this.source).append(", routing-key=").append(this.routingKey).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            @Override
            public String getDestination() {
                return this.destination;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public String getSource() {
                return this.source;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 40;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.unbind";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.destination);
                methodArgumentWriter.writeShortstr(this.source);
                methodArgumentWriter.writeShortstr(this.routingKey);
                methodArgumentWriter.writeBit(this.nowait);
                methodArgumentWriter.writeTable(this.arguments);
            }
        }

        public static class UnbindOk
        extends Method
        implements AMQP.Exchange.UnbindOk {
            public static final int INDEX = 51;

            public UnbindOk() {
            }

            public UnbindOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 51;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.unbind-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }
    }

    public static interface MethodVisitor {
        public Object visit(Access.Request var1) throws IOException;

        public Object visit(Access.RequestOk var1) throws IOException;

        public Object visit(Basic.Ack var1) throws IOException;

        public Object visit(Basic.Cancel var1) throws IOException;

        public Object visit(Basic.CancelOk var1) throws IOException;

        public Object visit(Basic.Consume var1) throws IOException;

        public Object visit(Basic.ConsumeOk var1) throws IOException;

        public Object visit(Basic.Deliver var1) throws IOException;

        public Object visit(Basic.Get var1) throws IOException;

        public Object visit(Basic.GetEmpty var1) throws IOException;

        public Object visit(Basic.GetOk var1) throws IOException;

        public Object visit(Basic.Nack var1) throws IOException;

        public Object visit(Basic.Publish var1) throws IOException;

        public Object visit(Basic.Qos var1) throws IOException;

        public Object visit(Basic.QosOk var1) throws IOException;

        public Object visit(Basic.Recover var1) throws IOException;

        public Object visit(Basic.RecoverAsync var1) throws IOException;

        public Object visit(Basic.RecoverOk var1) throws IOException;

        public Object visit(Basic.Reject var1) throws IOException;

        public Object visit(Basic.Return var1) throws IOException;

        public Object visit(Channel.Close var1) throws IOException;

        public Object visit(Channel.CloseOk var1) throws IOException;

        public Object visit(Channel.Flow var1) throws IOException;

        public Object visit(Channel.FlowOk var1) throws IOException;

        public Object visit(Channel.Open var1) throws IOException;

        public Object visit(Channel.OpenOk var1) throws IOException;

        public Object visit(Confirm.Select var1) throws IOException;

        public Object visit(Confirm.SelectOk var1) throws IOException;

        public Object visit(Connection.Blocked var1) throws IOException;

        public Object visit(Connection.Close var1) throws IOException;

        public Object visit(Connection.CloseOk var1) throws IOException;

        public Object visit(Connection.Open var1) throws IOException;

        public Object visit(Connection.OpenOk var1) throws IOException;

        public Object visit(Connection.Secure var1) throws IOException;

        public Object visit(Connection.SecureOk var1) throws IOException;

        public Object visit(Connection.Start var1) throws IOException;

        public Object visit(Connection.StartOk var1) throws IOException;

        public Object visit(Connection.Tune var1) throws IOException;

        public Object visit(Connection.TuneOk var1) throws IOException;

        public Object visit(Connection.Unblocked var1) throws IOException;

        public Object visit(Exchange.Bind var1) throws IOException;

        public Object visit(Exchange.BindOk var1) throws IOException;

        public Object visit(Exchange.Declare var1) throws IOException;

        public Object visit(Exchange.DeclareOk var1) throws IOException;

        public Object visit(Exchange.Delete var1) throws IOException;

        public Object visit(Exchange.DeleteOk var1) throws IOException;

        public Object visit(Exchange.Unbind var1) throws IOException;

        public Object visit(Exchange.UnbindOk var1) throws IOException;

        public Object visit(Queue.Bind var1) throws IOException;

        public Object visit(Queue.BindOk var1) throws IOException;

        public Object visit(Queue.Declare var1) throws IOException;

        public Object visit(Queue.DeclareOk var1) throws IOException;

        public Object visit(Queue.Delete var1) throws IOException;

        public Object visit(Queue.DeleteOk var1) throws IOException;

        public Object visit(Queue.Purge var1) throws IOException;

        public Object visit(Queue.PurgeOk var1) throws IOException;

        public Object visit(Queue.Unbind var1) throws IOException;

        public Object visit(Queue.UnbindOk var1) throws IOException;

        public Object visit(Tx.Commit var1) throws IOException;

        public Object visit(Tx.CommitOk var1) throws IOException;

        public Object visit(Tx.Rollback var1) throws IOException;

        public Object visit(Tx.RollbackOk var1) throws IOException;

        public Object visit(Tx.Select var1) throws IOException;

        public Object visit(Tx.SelectOk var1) throws IOException;
    }

    public static class Queue {
        public static final int INDEX = 50;

        public static class Bind
        extends Method
        implements AMQP.Queue.Bind {
            public static final int INDEX = 20;
            private final Map<String, Object> arguments;
            private final String exchange;
            private final boolean nowait;
            private final String queue;
            private final String routingKey;
            private final int ticket;

            /*
             * Enabled aggressive block sorting
             */
            public Bind(int n2, String string2, String string3, String string4, boolean bl2, Map<String, Object> map) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                if (string4 == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.ticket = n2;
                this.queue = string2;
                this.exchange = string3;
                this.routingKey = string4;
                this.nowait = bl2;
                Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
                this.arguments = map2;
            }

            public Bind(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit(), methodArgumentReader.readTable());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "queue.bind";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.queue);
                methodArgumentWriter.writeShortstr(this.exchange);
                methodArgumentWriter.writeShortstr(this.routingKey);
                methodArgumentWriter.writeBit(this.nowait);
                methodArgumentWriter.writeTable(this.arguments);
            }
        }

        public static class BindOk
        extends Method
        implements AMQP.Queue.BindOk {
            public static final int INDEX = 21;

            public BindOk() {
            }

            public BindOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 21;
            }

            @Override
            public String protocolMethodName() {
                return "queue.bind-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class Declare
        extends Method
        implements AMQP.Queue.Declare {
            public static final int INDEX = 10;
            private final Map<String, Object> arguments;
            private final boolean autoDelete;
            private final boolean durable;
            private final boolean exclusive;
            private final boolean nowait;
            private final boolean passive;
            private final String queue;
            private final int ticket;

            /*
             * Enabled aggressive block sorting
             */
            public Declare(int n2, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Map<String, Object> map) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                this.ticket = n2;
                this.queue = string2;
                this.passive = bl2;
                this.durable = bl3;
                this.exclusive = bl4;
                this.autoDelete = bl5;
                this.nowait = bl6;
                Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
                this.arguments = map2;
            }

            public Declare(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readTable());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", passive=").append(this.passive).append(", durable=").append(this.durable).append(", exclusive=").append(this.exclusive).append(", auto-delete=").append(this.autoDelete).append(", nowait=").append(this.nowait).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            @Override
            public boolean getAutoDelete() {
                return this.autoDelete;
            }

            @Override
            public boolean getDurable() {
                return this.durable;
            }

            @Override
            public boolean getExclusive() {
                return this.exclusive;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public boolean getPassive() {
                return this.passive;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "queue.declare";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.queue);
                methodArgumentWriter.writeBit(this.passive);
                methodArgumentWriter.writeBit(this.durable);
                methodArgumentWriter.writeBit(this.exclusive);
                methodArgumentWriter.writeBit(this.autoDelete);
                methodArgumentWriter.writeBit(this.nowait);
                methodArgumentWriter.writeTable(this.arguments);
            }
        }

        public static class DeclareOk
        extends Method
        implements AMQP.Queue.DeclareOk {
            public static final int INDEX = 11;
            private final int consumerCount;
            private final int messageCount;
            private final String queue;

            public DeclareOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShortstr(), methodArgumentReader.readLong(), methodArgumentReader.readLong());
            }

            public DeclareOk(String string2, int n2, int n3) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                this.queue = string2;
                this.messageCount = n2;
                this.consumerCount = n3;
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(queue=").append(this.queue).append(", message-count=").append(this.messageCount).append(", consumer-count=").append(this.consumerCount).append(")");
            }

            @Override
            public int getConsumerCount() {
                return this.consumerCount;
            }

            @Override
            public int getMessageCount() {
                return this.messageCount;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "queue.declare-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShortstr(this.queue);
                methodArgumentWriter.writeLong(this.messageCount);
                methodArgumentWriter.writeLong(this.consumerCount);
            }
        }

        public static class Delete
        extends Method
        implements AMQP.Queue.Delete {
            public static final int INDEX = 40;
            private final boolean ifEmpty;
            private final boolean ifUnused;
            private final boolean nowait;
            private final String queue;
            private final int ticket;

            public Delete(int n2, String string2, boolean bl2, boolean bl3, boolean bl4) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                this.ticket = n2;
                this.queue = string2;
                this.ifUnused = bl2;
                this.ifEmpty = bl3;
                this.nowait = bl4;
            }

            public Delete(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit(), methodArgumentReader.readBit(), methodArgumentReader.readBit());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", if-unused=").append(this.ifUnused).append(", if-empty=").append(this.ifEmpty).append(", nowait=").append(this.nowait).append(")");
            }

            @Override
            public boolean getIfEmpty() {
                return this.ifEmpty;
            }

            @Override
            public boolean getIfUnused() {
                return this.ifUnused;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 40;
            }

            @Override
            public String protocolMethodName() {
                return "queue.delete";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.queue);
                methodArgumentWriter.writeBit(this.ifUnused);
                methodArgumentWriter.writeBit(this.ifEmpty);
                methodArgumentWriter.writeBit(this.nowait);
            }
        }

        public static class DeleteOk
        extends Method
        implements AMQP.Queue.DeleteOk {
            public static final int INDEX = 41;
            private final int messageCount;

            public DeleteOk(int n2) {
                this.messageCount = n2;
            }

            public DeleteOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readLong());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(message-count=").append(this.messageCount).append(")");
            }

            @Override
            public int getMessageCount() {
                return this.messageCount;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 41;
            }

            @Override
            public String protocolMethodName() {
                return "queue.delete-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeLong(this.messageCount);
            }
        }

        public static class Purge
        extends Method
        implements AMQP.Queue.Purge {
            public static final int INDEX = 30;
            private final boolean nowait;
            private final String queue;
            private final int ticket;

            public Purge(int n2, String string2, boolean bl2) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                this.ticket = n2;
                this.queue = string2;
                this.nowait = bl2;
            }

            public Purge(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readBit());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", nowait=").append(this.nowait).append(")");
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 30;
            }

            @Override
            public String protocolMethodName() {
                return "queue.purge";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.queue);
                methodArgumentWriter.writeBit(this.nowait);
            }
        }

        public static class PurgeOk
        extends Method
        implements AMQP.Queue.PurgeOk {
            public static final int INDEX = 31;
            private final int messageCount;

            public PurgeOk(int n2) {
                this.messageCount = n2;
            }

            public PurgeOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readLong());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(message-count=").append(this.messageCount).append(")");
            }

            @Override
            public int getMessageCount() {
                return this.messageCount;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 31;
            }

            @Override
            public String protocolMethodName() {
                return "queue.purge-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeLong(this.messageCount);
            }
        }

        public static class Unbind
        extends Method
        implements AMQP.Queue.Unbind {
            public static final int INDEX = 50;
            private final Map<String, Object> arguments;
            private final String exchange;
            private final String queue;
            private final String routingKey;
            private final int ticket;

            /*
             * Enabled aggressive block sorting
             */
            public Unbind(int n2, String string2, String string3, String string4, Map<String, Object> map) {
                if (string2 == null) {
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                }
                if (string4 == null) {
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                }
                if (string3 == null) {
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                }
                this.ticket = n2;
                this.queue = string2;
                this.exchange = string3;
                this.routingKey = string4;
                Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
                this.arguments = map2;
            }

            public Unbind(MethodArgumentReader methodArgumentReader) throws IOException {
                this(methodArgumentReader.readShort(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readShortstr(), methodArgumentReader.readTable());
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("(ticket=").append(this.ticket).append(", queue=").append(this.queue).append(", exchange=").append(this.exchange).append(", routing-key=").append(this.routingKey).append(", arguments=").append(this.arguments).append(")");
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 50;
            }

            @Override
            public String protocolMethodName() {
                return "queue.unbind";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
                methodArgumentWriter.writeShort(this.ticket);
                methodArgumentWriter.writeShortstr(this.queue);
                methodArgumentWriter.writeShortstr(this.exchange);
                methodArgumentWriter.writeShortstr(this.routingKey);
                methodArgumentWriter.writeTable(this.arguments);
            }
        }

        public static class UnbindOk
        extends Method
        implements AMQP.Queue.UnbindOk {
            public static final int INDEX = 51;

            public UnbindOk() {
            }

            public UnbindOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 51;
            }

            @Override
            public String protocolMethodName() {
                return "queue.unbind-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }
    }

    public static class Tx {
        public static final int INDEX = 90;

        public static class Commit
        extends Method
        implements AMQP.Tx.Commit {
            public static final int INDEX = 20;

            public Commit() {
            }

            public Commit(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 90;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "tx.commit";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class CommitOk
        extends Method
        implements AMQP.Tx.CommitOk {
            public static final int INDEX = 21;

            public CommitOk() {
            }

            public CommitOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 90;
            }

            @Override
            public int protocolMethodId() {
                return 21;
            }

            @Override
            public String protocolMethodName() {
                return "tx.commit-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class Rollback
        extends Method
        implements AMQP.Tx.Rollback {
            public static final int INDEX = 30;

            public Rollback() {
            }

            public Rollback(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 90;
            }

            @Override
            public int protocolMethodId() {
                return 30;
            }

            @Override
            public String protocolMethodName() {
                return "tx.rollback";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class RollbackOk
        extends Method
        implements AMQP.Tx.RollbackOk {
            public static final int INDEX = 31;

            public RollbackOk() {
            }

            public RollbackOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 90;
            }

            @Override
            public int protocolMethodId() {
                return 31;
            }

            @Override
            public String protocolMethodName() {
                return "tx.rollback-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class Select
        extends Method
        implements AMQP.Tx.Select {
            public static final int INDEX = 10;

            public Select() {
            }

            public Select(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 90;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "tx.select";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }

        public static class SelectOk
        extends Method
        implements AMQP.Tx.SelectOk {
            public static final int INDEX = 11;

            public SelectOk() {
            }

            public SelectOk(MethodArgumentReader methodArgumentReader) throws IOException {
                this();
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuilder stringBuilder) {
                stringBuilder.append("()");
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public int protocolClassId() {
                return 90;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "tx.select-ok";
            }

            @Override
            public Object visit(MethodVisitor methodVisitor) throws IOException {
                return methodVisitor.visit(this);
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter methodArgumentWriter) throws IOException {
            }
        }
    }
}

