/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.MissedHeartbeatException;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.ChannelManager;
import com.rabbitmq.client.impl.ChannelN;
import com.rabbitmq.client.impl.ConsumerWorkService;
import com.rabbitmq.client.impl.DefaultExceptionHandler;
import com.rabbitmq.client.impl.ExceptionHandler;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.HeartbeatSender;
import com.rabbitmq.client.impl.LongStringHelper;
import com.rabbitmq.client.impl.ShutdownNotifierComponent;
import com.rabbitmq.client.impl.Version;
import com.rabbitmq.utility.BlockingCell;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;

public class AMQConnection
extends ShutdownNotifierComponent
implements Connection {
    public static final int HANDSHAKE_TIMEOUT = 10000;
    private static final Version clientVersion = new Version(0, 9);
    private final BlockingCell<Object> _appContinuation;
    private volatile boolean _brokerInitiatedShutdown;
    private final AMQChannel _channel0 = new AMQChannel(this, 0){

        @Override
        public boolean processAsync(Command command) throws IOException {
            return this.getConnection().processControlCommand(command);
        }
    };
    private volatile ChannelManager _channelManager;
    private final Map<String, Object> _clientProperties;
    private final ExceptionHandler _exceptionHandler;
    private final FrameHandler _frameHandler;
    private volatile int _frameMax = 0;
    private volatile int _heartbeat = 0;
    private final HeartbeatSender _heartbeatSender;
    private volatile boolean _inConnectionNegotiation;
    private volatile int _missedHeartbeats = 0;
    private volatile boolean _running = false;
    private volatile Map<String, Object> _serverProperties;
    private final String _virtualHost;
    private final ConsumerWorkService _workService;
    private final Collection<BlockedListener> blockedListeners;
    private final String password;
    private final int requestedChannelMax;
    private final int requestedFrameMax;
    private final int requestedHeartbeat;
    private final SaslConfig saslConfig;
    private final String username;

    public AMQConnection(String string2, String string3, FrameHandler frameHandler, ExecutorService executorService, String string4, Map<String, Object> map, int n2, int n3, int n4, SaslConfig saslConfig) {
        this(string2, string3, frameHandler, executorService, string4, map, n2, n3, n4, saslConfig, new DefaultExceptionHandler());
    }

    public AMQConnection(String string2, String string3, FrameHandler frameHandler, ExecutorService executorService, String string4, Map<String, Object> map, int n2, int n3, int n4, SaslConfig saslConfig, ExceptionHandler exceptionHandler) {
        this._appContinuation = new BlockingCell();
        this.blockedListeners = new CopyOnWriteArrayList<BlockedListener>();
        AMQConnection.checkPreconditions();
        this.username = string2;
        this.password = string3;
        this._frameHandler = frameHandler;
        this._virtualHost = string4;
        this._exceptionHandler = exceptionHandler;
        this._clientProperties = new HashMap<String, Object>(map);
        this.requestedFrameMax = n2;
        this.requestedChannelMax = n3;
        this.requestedHeartbeat = n4;
        this.saslConfig = saslConfig;
        this._workService = new ConsumerWorkService(executorService);
        this._channelManager = null;
        this._heartbeatSender = new HeartbeatSender(frameHandler);
        this._brokerInitiatedShutdown = false;
        this._inConnectionNegotiation = true;
    }

    static /* synthetic */ boolean access$002(AMQConnection aMQConnection, boolean bl2) {
        aMQConnection._running = bl2;
        return bl2;
    }

    static /* synthetic */ int access$202(AMQConnection aMQConnection, int n2) {
        aMQConnection._missedHeartbeats = n2;
        return n2;
    }

    private static final void checkPreconditions() {
        AMQCommand.checkPreconditions();
    }

    public static final Map<String, Object> defaultClientProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("product", LongStringHelper.asLongString("RabbitMQ"));
        hashMap.put("version", LongStringHelper.asLongString("3.2.0"));
        hashMap.put("platform", LongStringHelper.asLongString("Java"));
        hashMap.put("copyright", LongStringHelper.asLongString("Copyright (C) 2007-2013 GoPivotal, Inc."));
        hashMap.put("information", LongStringHelper.asLongString("Licensed under the MPL. See http://www.rabbitmq.com/"));
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        hashMap2.put("publisher_confirms", true);
        hashMap2.put("exchange_exchange_bindings", true);
        hashMap2.put("basic.nack", true);
        hashMap2.put("consumer_cancel_notify", true);
        hashMap2.put("connection.blocked", true);
        hashMap2.put("authentication_failure_close", true);
        hashMap.put("capabilities", hashMap2);
        return hashMap;
    }

    private final void ensureIsOpen() throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException("Attempt to use closed connection", this);
        }
    }

    private void finishShutdown(ShutdownSignalException shutdownSignalException) {
        ChannelManager channelManager = this._channelManager;
        if (channelManager != null) {
            channelManager.handleSignal(shutdownSignalException);
        }
    }

    private String getHostAddress() {
        if (this.getAddress() == null) {
            return null;
        }
        return this.getAddress().getHostAddress();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleSocketTimeout() throws SocketTimeoutException {
        block5: {
            block4: {
                int n2;
                if (this._inConnectionNegotiation) {
                    throw new SocketTimeoutException("Timeout during Connection negotiation");
                }
                if (this._heartbeat == 0) break block4;
                this._missedHeartbeats = n2 = 1 + this._missedHeartbeats;
                if (n2 > 8) break block5;
            }
            return;
        }
        throw new MissedHeartbeatException("Heartbeat missing with heartbeat = " + this._heartbeat + " seconds");
    }

    private static final int negotiatedMaxValue(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return Math.max(n2, n3);
        }
        return Math.min(n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ShutdownSignalException startShutdown(Object object, boolean bl2, Throwable throwable, boolean bl3) {
        boolean bl4 = true;
        ShutdownSignalException shutdownSignalException = new ShutdownSignalException(bl4, bl2, object, this);
        shutdownSignalException.initCause(throwable);
        if (!this.setShutdownCauseIfOpen(shutdownSignalException) && bl2) {
            throw new AlreadyClosedException("Attempt to use closed connection", this);
        }
        this._heartbeatSender.shutdown();
        AMQChannel aMQChannel = this._channel0;
        if (bl2) {
            bl4 = false;
        }
        aMQChannel.processShutdownSignal(shutdownSignalException, bl4, bl3);
        return shutdownSignalException;
    }

    @Override
    public void abort() {
        this.abort(-1);
    }

    @Override
    public void abort(int n2) {
        this.abort(200, "OK", n2);
    }

    @Override
    public void abort(int n2, String string2) {
        this.abort(n2, string2, -1);
    }

    @Override
    public void abort(int n2, String string2, int n3) {
        try {
            this.close(n2, string2, true, null, n3, true);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Override
    public void addBlockedListener(BlockedListener blockedListener) {
        this.blockedListeners.add(blockedListener);
    }

    @Override
    public void clearBlockedListeners() {
        this.blockedListeners.clear();
    }

    @Override
    public void close() throws IOException {
        this.close(-1);
    }

    @Override
    public void close(int n2) throws IOException {
        this.close(200, "OK", n2);
    }

    @Override
    public void close(int n2, String string2) throws IOException {
        this.close(n2, string2, -1);
    }

    @Override
    public void close(int n2, String string2, int n3) throws IOException {
        this.close(n2, string2, true, null, n3, false);
    }

    public void close(int n2, String string2, boolean bl2, Throwable throwable) throws IOException {
        this.close(n2, string2, bl2, throwable, -1, false);
    }

    /*
     * Exception decompiling
     */
    public void close(int var1_1, String var2_2, boolean var3_3, Throwable var4_4, int var5_5, boolean var6_6) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [13 : 174->177)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Channel createChannel() throws IOException {
        this.ensureIsOpen();
        ChannelManager channelManager = this._channelManager;
        if (channelManager == null) {
            return null;
        }
        return channelManager.createChannel(this);
    }

    @Override
    public Channel createChannel(int n2) throws IOException {
        this.ensureIsOpen();
        ChannelManager channelManager = this._channelManager;
        if (channelManager == null) {
            return null;
        }
        return channelManager.createChannel(this, n2);
    }

    public final void disconnectChannel(ChannelN channelN) {
        ChannelManager channelManager = this._channelManager;
        if (channelManager != null) {
            channelManager.releaseChannelNumber(channelN);
        }
    }

    public void flush() throws IOException {
        this._frameHandler.flush();
    }

    @Override
    public InetAddress getAddress() {
        return this._frameHandler.getAddress();
    }

    @Override
    public int getChannelMax() {
        ChannelManager channelManager = this._channelManager;
        if (channelManager == null) {
            return 0;
        }
        return channelManager.getChannelMax();
    }

    @Override
    public Map<String, Object> getClientProperties() {
        return new HashMap<String, Object>(this._clientProperties);
    }

    public ExceptionHandler getExceptionHandler() {
        return this._exceptionHandler;
    }

    public FrameHandler getFrameHandler() {
        return this._frameHandler;
    }

    @Override
    public int getFrameMax() {
        return this._frameMax;
    }

    @Override
    public int getHeartbeat() {
        return this._heartbeat;
    }

    @Override
    public int getPort() {
        return this._frameHandler.getPort();
    }

    @Override
    public Map<String, Object> getServerProperties() {
        return this._serverProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleConnectionClose(Command command) {
        ShutdownSignalException shutdownSignalException = this.shutdown(command, false, null, this._inConnectionNegotiation);
        try {
            this._channel0.quiescingTransmit(new AMQP.Connection.CloseOk.Builder().build());
        }
        catch (IOException iOException) {}
        this._brokerInitiatedShutdown = true;
        SocketCloseWait socketCloseWait = new SocketCloseWait(shutdownSignalException);
        socketCloseWait.setName("AMQP Connection Closing Monitor " + this.getHostAddress() + ":" + this.getPort());
        socketCloseWait.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processControlCommand(Command command) throws IOException {
        Method method = command.getMethod();
        if (this.isOpen()) {
            if (method instanceof AMQP.Connection.Close) {
                this.handleConnectionClose(command);
                return true;
            }
            if (method instanceof AMQP.Connection.Blocked) {
                AMQP.Connection.Blocked blocked = (AMQP.Connection.Blocked)method;
                try {
                    Iterator<BlockedListener> iterator = this.blockedListeners.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().handleBlocked(blocked.getReason());
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    this.getExceptionHandler().handleBlockedListenerException(this, throwable);
                    return true;
                }
            } else {
                if (!(method instanceof AMQP.Connection.Unblocked)) {
                    return false;
                }
                try {
                    Iterator<BlockedListener> iterator = this.blockedListeners.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().handleUnblocked();
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    this.getExceptionHandler().handleBlockedListenerException(this, throwable);
                    return true;
                }
            }
        }
        if (method instanceof AMQP.Connection.Close) {
            try {
                this._channel0.quiescingTransmit(new AMQP.Connection.CloseOk.Builder().build());
                return true;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        if (!(method instanceof AMQP.Connection.CloseOk)) return true;
        this._running = false;
        if (!this._channel0.isOutstandingRpc()) return true;
        return false;
    }

    @Override
    public boolean removeBlockedListener(BlockedListener blockedListener) {
        return this.blockedListeners.remove(blockedListener);
    }

    public void setHeartbeat(int n2) {
        try {
            this._heartbeatSender.setHeartbeat(n2);
            this._heartbeat = n2;
            this._frameHandler.setTimeout(n2 * 1000 / 4);
            return;
        }
        catch (SocketException socketException) {
            return;
        }
    }

    public ShutdownSignalException shutdown(Object object, boolean bl2, Throwable throwable, boolean bl3) {
        ShutdownSignalException shutdownSignalException = this.startShutdown(object, bl2, throwable, bl3);
        this.finishShutdown(shutdownSignalException);
        return shutdownSignalException;
    }

    /*
     * Exception decompiling
     */
    public void start() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3, 4 : 203->234)] com.rabbitmq.client.ShutdownSignalException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return "amqp://" + this.username + "@" + this.getHostAddress() + ":" + this.getPort() + this._virtualHost;
    }

    public void writeFrame(Frame frame) throws IOException {
        this._frameHandler.writeFrame(frame);
        this._heartbeatSender.signalActivity();
    }

    private class MainLoop
    extends Thread {
        MainLoop(String string2) {
            super(string2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    block13: {
                        try {
                            while (AMQConnection.this._running) {
                                Frame frame = AMQConnection.this._frameHandler.readFrame();
                                if (frame != null) {
                                    ChannelManager channelManager;
                                    AMQConnection.access$202(AMQConnection.this, 0);
                                    if (frame.type == 8) continue;
                                    if (frame.channel == 0) {
                                        AMQConnection.this._channel0.handleFrame(frame);
                                        continue;
                                    }
                                    if (!AMQConnection.this.isOpen() || (channelManager = AMQConnection.this._channelManager) == null) continue;
                                    channelManager.getChannel(frame.channel).handleFrame(frame);
                                    continue;
                                }
                                break block13;
                            }
                            return;
                        }
                        catch (EOFException eOFException) {
                            if (AMQConnection.this._brokerInitiatedShutdown) return;
                            AMQConnection.this.shutdown(eOFException, false, eOFException, true);
                            return;
                        }
                        catch (Throwable throwable) {
                            AMQConnection.this._exceptionHandler.handleUnexpectedConnectionDriverException(AMQConnection.this, throwable);
                            AMQConnection.this.shutdown(throwable, false, throwable, true);
                            return;
                        }
                    }
                    AMQConnection.this.handleSocketTimeout();
                }
            }
            finally {
                AMQConnection.this._frameHandler.close();
                AMQConnection.this._appContinuation.set(null);
                AMQConnection.this.notifyListeners();
            }
        }
    }

    private class SocketCloseWait
    extends Thread {
        private final ShutdownSignalException cause;

        public SocketCloseWait(ShutdownSignalException shutdownSignalException) {
            this.cause = shutdownSignalException;
        }

        @Override
        public void run() {
            try {
                AMQConnection.this._appContinuation.uninterruptibleGet();
                return;
            }
            finally {
                AMQConnection.access$002(AMQConnection.this, false);
                AMQConnection.this._channel0.notifyOutstandingRpc(this.cause);
            }
        }
    }
}

