/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.Command;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.CommandAssembler;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.Method;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AMQCommand
implements Command {
    public static final int EMPTY_FRAME_SIZE = 8;
    private final CommandAssembler assembler;

    public AMQCommand() {
        this(null, null, null);
    }

    public AMQCommand(com.rabbitmq.client.Method method) {
        this(method, null, null);
    }

    public AMQCommand(com.rabbitmq.client.Method method, AMQContentHeader aMQContentHeader, byte[] byArray) {
        this.assembler = new CommandAssembler((Method)method, aMQContentHeader, byArray);
    }

    private static void checkEmptyFrameSize() {
        Frame frame = new Frame(3, 0, new byte[0]);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            frame.writeTo(new DataOutputStream(byteArrayOutputStream));
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"IOException while checking EMPTY_FRAME_SIZE");
        }
        int n2 = byteArrayOutputStream.toByteArray().length;
        if (8 != n2) {
            throw new AssertionError((Object)("Internal error: expected EMPTY_FRAME_SIZE(8) is not equal to computed value: " + n2));
        }
    }

    public static void checkPreconditions() {
        AMQCommand.checkEmptyFrameSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static StringBuilder contentBodyStringBuilder(byte[] byArray, boolean bl2) {
        if (!bl2) return new StringBuilder().append('\"').append(new String(byArray, "UTF-8")).append('\"');
        try {
            return new StringBuilder().append(byArray.length).append(" bytes of payload");
        }
        catch (Exception exception) {
            return new StringBuilder().append('|').append(byArray.length).append('|');
        }
    }

    @Override
    public byte[] getContentBody() {
        return this.assembler.getContentBody();
    }

    @Override
    public AMQContentHeader getContentHeader() {
        return this.assembler.getContentHeader();
    }

    @Override
    public Method getMethod() {
        return this.assembler.getMethod();
    }

    public boolean handleFrame(Frame frame) throws IOException {
        return this.assembler.handleFrame(frame);
    }

    public String toString() {
        return this.toString(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString(boolean bl2) {
        CommandAssembler commandAssembler = this.assembler;
        synchronized (commandAssembler) {
            return "" + '{' + this.assembler.getMethod() + ", " + this.assembler.getContentHeader() + ", " + AMQCommand.contentBodyStringBuilder(this.assembler.getContentBody(), bl2) + '}';
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transmit(AMQChannel aMQChannel) throws IOException {
        int n2 = aMQChannel.getChannelNumber();
        AMQConnection aMQConnection = aMQChannel.getConnection();
        CommandAssembler commandAssembler = this.assembler;
        synchronized (commandAssembler) {
            Method method = this.assembler.getMethod();
            aMQConnection.writeFrame(method.toFrame(n2));
            if (method.hasContent()) {
                byte[] byArray = this.assembler.getContentBody();
                aMQConnection.writeFrame(this.assembler.getContentHeader().toFrame(n2, byArray.length));
                int n3 = aMQConnection.getFrameMax();
                int n4 = n3 == 0 ? byArray.length : n3 - 8;
                for (int i2 = 0; i2 < byArray.length; i2 += n4) {
                    int n5 = byArray.length - i2;
                    int n6 = n5 < n4 ? n5 : n4;
                    aMQConnection.writeFrame(Frame.fromBodyFragment(n2, byArray, i2, n6));
                }
            }
        }
        aMQConnection.flush();
    }
}

