/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.client.impl.ShutdownNotifierComponent;
import com.rabbitmq.utility.BlockingValueOrException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public abstract class AMQChannel
extends ShutdownNotifierComponent {
    private RpcContinuation _activeRpc = null;
    public boolean _blockContent = false;
    protected final Object _channelMutex = new Object();
    private final int _channelNumber;
    private AMQCommand _command = new AMQCommand();
    private final AMQConnection _connection;

    public AMQChannel(AMQConnection aMQConnection, int n2) {
        this._connection = aMQConnection;
        this._channelNumber = n2;
    }

    private AMQCommand privateRpc(com.rabbitmq.client.Method method) throws IOException, ShutdownSignalException {
        SimpleBlockingRpcContinuation simpleBlockingRpcContinuation = new SimpleBlockingRpcContinuation();
        this.rpc(method, simpleBlockingRpcContinuation);
        return (AMQCommand)simpleBlockingRpcContinuation.getReply();
    }

    public static IOException wrap(ShutdownSignalException shutdownSignalException) {
        return AMQChannel.wrap(shutdownSignalException, null);
    }

    public static IOException wrap(ShutdownSignalException shutdownSignalException, String string2) {
        IOException iOException = new IOException(string2);
        iOException.initCause(shutdownSignalException);
        return iOException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueueRpc(RpcContinuation rpcContinuation) {
        Object object = this._channelMutex;
        synchronized (object) {
            RpcContinuation rpcContinuation2;
            boolean bl2 = false;
            while ((rpcContinuation2 = this._activeRpc) != null) {
                try {
                    this._channelMutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
            }
            if (bl2) {
                Thread.currentThread().interrupt();
            }
            this._activeRpc = rpcContinuation;
            return;
        }
    }

    public void ensureIsOpen() throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException("Attempt to use closed channel", this);
        }
    }

    public AMQCommand exnWrappingRpc(com.rabbitmq.client.Method method) throws IOException {
        try {
            AMQCommand aMQCommand = this.privateRpc(method);
            return aMQCommand;
        }
        catch (AlreadyClosedException alreadyClosedException) {
            throw alreadyClosedException;
        }
        catch (ShutdownSignalException shutdownSignalException) {
            throw AMQChannel.wrap(shutdownSignalException);
        }
    }

    public int getChannelNumber() {
        return this._channelNumber;
    }

    public AMQConnection getConnection() {
        return this._connection;
    }

    public void handleCompleteInboundCommand(AMQCommand aMQCommand) throws IOException {
        if (!this.processAsync(aMQCommand)) {
            this.nextOutstandingRpc().handleCommand(aMQCommand);
        }
    }

    public void handleFrame(Frame frame) throws IOException {
        AMQCommand aMQCommand = this._command;
        if (aMQCommand.handleFrame(frame)) {
            this._command = new AMQCommand();
            this.handleCompleteInboundCommand(aMQCommand);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOutstandingRpc() {
        Object object = this._channelMutex;
        synchronized (object) {
            if (this._activeRpc == null) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RpcContinuation nextOutstandingRpc() {
        Object object = this._channelMutex;
        synchronized (object) {
            RpcContinuation rpcContinuation = this._activeRpc;
            this._activeRpc = null;
            this._channelMutex.notifyAll();
            return rpcContinuation;
        }
    }

    public void notifyOutstandingRpc(ShutdownSignalException shutdownSignalException) {
        RpcContinuation rpcContinuation = this.nextOutstandingRpc();
        if (rpcContinuation != null) {
            rpcContinuation.handleShutdownSignal(shutdownSignalException);
        }
    }

    public abstract boolean processAsync(Command var1) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void processShutdownSignal(ShutdownSignalException shutdownSignalException, boolean bl2, boolean bl3) {
        try {
            Object object = this._channelMutex;
            // MONITORENTER : object
        }
        catch (Throwable throwable) {
            if (!bl3) throw throwable;
            this.notifyOutstandingRpc(shutdownSignalException);
            throw throwable;
        }
        if (!this.setShutdownCauseIfOpen(shutdownSignalException) && !bl2) {
            throw new AlreadyClosedException("Attempt to use closed channel", this);
        }
        this._channelMutex.notifyAll();
        // MONITOREXIT : object
        if (!bl3) return;
        this.notifyOutstandingRpc(shutdownSignalException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void quiescingRpc(com.rabbitmq.client.Method method, RpcContinuation rpcContinuation) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.enqueueRpc(rpcContinuation);
            this.quiescingTransmit(method);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void quiescingTransmit(com.rabbitmq.client.Method method) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.quiescingTransmit(new AMQCommand(method));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void quiescingTransmit(AMQCommand aMQCommand) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            if (((Method)aMQCommand.getMethod()).hasContent()) {
                boolean bl2;
                while (bl2 = this._blockContent) {
                    try {
                        this._channelMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    this.ensureIsOpen();
                }
            }
            aMQCommand.transmit(this);
            return;
        }
    }

    public AMQCommand rpc(com.rabbitmq.client.Method method) throws IOException, ShutdownSignalException {
        return this.privateRpc(method);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rpc(com.rabbitmq.client.Method method, RpcContinuation rpcContinuation) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingRpc(method, rpcContinuation);
            return;
        }
    }

    public String toString() {
        return "AMQChannel(" + this._connection + "," + this._channelNumber + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transmit(com.rabbitmq.client.Method method) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.transmit(new AMQCommand(method));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transmit(AMQCommand aMQCommand) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingTransmit(aMQCommand);
            return;
        }
    }

    public static abstract class BlockingRpcContinuation<T>
    implements RpcContinuation {
        public final BlockingValueOrException<T, ShutdownSignalException> _blocker = new BlockingValueOrException();

        public T getReply() throws ShutdownSignalException {
            return this._blocker.uninterruptibleGetValue();
        }

        public T getReply(int n2) throws ShutdownSignalException, TimeoutException {
            return this._blocker.uninterruptibleGetValue(n2);
        }

        @Override
        public void handleCommand(AMQCommand aMQCommand) {
            this._blocker.setValue(this.transformReply(aMQCommand));
        }

        @Override
        public void handleShutdownSignal(ShutdownSignalException shutdownSignalException) {
            this._blocker.setException(shutdownSignalException);
        }

        public abstract T transformReply(AMQCommand var1);
    }

    public static interface RpcContinuation {
        public void handleCommand(AMQCommand var1);

        public void handleShutdownSignal(ShutdownSignalException var1);
    }

    public static class SimpleBlockingRpcContinuation
    extends BlockingRpcContinuation<AMQCommand> {
        @Override
        public AMQCommand transformReply(AMQCommand aMQCommand) {
            return aMQCommand;
        }
    }
}

