/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;

public class RpcServer {
    private final Channel _channel;
    private QueueingConsumer _consumer;
    private boolean _mainloopRunning = true;
    private final String _queueName;

    public RpcServer(Channel channel) throws IOException {
        this(channel, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RpcServer(Channel channel, String string2) throws IOException {
        this._channel = channel;
        this._queueName = string2 == null || string2.equals("") ? this._channel.queueDeclare().getQueue() : string2;
        this._consumer = this.setupConsumer();
    }

    public void close() throws IOException {
        if (this._consumer != null) {
            this._channel.basicCancel(this._consumer.getConsumerTag());
            this._consumer = null;
        }
        this.terminateMainloop();
    }

    public Channel getChannel() {
        return this._channel;
    }

    public String getQueueName() {
        return this._queueName;
    }

    public byte[] handleCall(AMQP.BasicProperties basicProperties, byte[] byArray, AMQP.BasicProperties basicProperties2) {
        return this.handleCall(byArray, basicProperties2);
    }

    public byte[] handleCall(QueueingConsumer.Delivery delivery, AMQP.BasicProperties basicProperties) {
        return this.handleCall(delivery.getProperties(), delivery.getBody(), basicProperties);
    }

    public byte[] handleCall(byte[] byArray, AMQP.BasicProperties basicProperties) {
        return new byte[0];
    }

    public void handleCast(AMQP.BasicProperties basicProperties, byte[] byArray) {
        this.handleCast(byArray);
    }

    public void handleCast(QueueingConsumer.Delivery delivery) {
        this.handleCast(delivery.getProperties(), delivery.getBody());
    }

    public void handleCast(byte[] byArray) {
    }

    public ShutdownSignalException mainloop() throws IOException {
        while (true) {
            try {
                boolean bl2 = this._mainloopRunning;
                if (!bl2) break;
            }
            catch (ShutdownSignalException shutdownSignalException) {
                return shutdownSignalException;
            }
            try {
                QueueingConsumer.Delivery delivery = this._consumer.nextDelivery();
                this.processRequest(delivery);
                this._channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
            }
            catch (InterruptedException interruptedException) {}
            continue;
            break;
        }
        return null;
    }

    public void processRequest(QueueingConsumer.Delivery delivery) throws IOException {
        AMQP.BasicProperties basicProperties = delivery.getProperties();
        String string2 = basicProperties.getCorrelationId();
        String string3 = basicProperties.getReplyTo();
        if (string2 != null && string3 != null) {
            AMQP.BasicProperties basicProperties2 = new AMQP.BasicProperties.Builder().correlationId(string2).build();
            byte[] byArray = this.handleCall(delivery, basicProperties2);
            this._channel.basicPublish("", string3, basicProperties2, byArray);
            return;
        }
        this.handleCast(delivery);
    }

    protected QueueingConsumer setupConsumer() throws IOException {
        QueueingConsumer queueingConsumer = new QueueingConsumer(this._channel);
        this._channel.basicConsume(this._queueName, queueingConsumer);
        return queueingConsumer;
    }

    public void terminateMainloop() {
        this._mainloopRunning = false;
    }
}

