/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.StringRpcServer;
import com.rabbitmq.client.impl.MethodArgumentReader;
import com.rabbitmq.client.impl.MethodArgumentWriter;
import com.rabbitmq.client.impl.ValueReader;
import com.rabbitmq.client.impl.ValueWriter;
import com.rabbitmq.utility.BlockingCell;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class RpcClient {
    protected static final int NO_TIMEOUT = -1;
    private final Channel _channel;
    private DefaultConsumer _consumer;
    private final Map<String, BlockingCell<Object>> _continuationMap = new HashMap<String, BlockingCell<Object>>();
    private int _correlationId;
    private final String _exchange;
    private String _replyQueue;
    private final String _routingKey;
    private final int _timeout;

    public RpcClient(Channel channel, String string2, String string3) throws IOException {
        this(channel, string2, string3, -1);
    }

    public RpcClient(Channel channel, String string2, String string3, int n2) throws IOException {
        this._channel = channel;
        this._exchange = string2;
        this._routingKey = string3;
        if (n2 < -1) {
            throw new IllegalArgumentException("Timeout arguument must be NO_TIMEOUT(-1) or non-negative.");
        }
        this._timeout = n2;
        this._correlationId = 0;
        this._replyQueue = this.setupReplyQueue();
        this._consumer = this.setupConsumer();
    }

    static /* synthetic */ DefaultConsumer access$102(RpcClient rpcClient, DefaultConsumer defaultConsumer) {
        rpcClient._consumer = defaultConsumer;
        return defaultConsumer;
    }

    public void checkConsumer() throws IOException {
        if (this._consumer == null) {
            throw new EOFException("RpcClient is closed");
        }
    }

    public void close() throws IOException {
        if (this._consumer != null) {
            this._channel.basicCancel(this._consumer.getConsumerTag());
            this._consumer = null;
        }
    }

    public Channel getChannel() {
        return this._channel;
    }

    public Consumer getConsumer() {
        return this._consumer;
    }

    public Map<String, BlockingCell<Object>> getContinuationMap() {
        return this._continuationMap;
    }

    public int getCorrelationId() {
        return this._correlationId;
    }

    public String getExchange() {
        return this._exchange;
    }

    public String getReplyQueue() {
        return this._replyQueue;
    }

    public String getRoutingKey() {
        return this._routingKey;
    }

    public Map<String, Object> mapCall(Map<String, Object> map) throws IOException, ShutdownSignalException, TimeoutException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MethodArgumentWriter methodArgumentWriter = new MethodArgumentWriter(new ValueWriter(new DataOutputStream(byteArrayOutputStream)));
        methodArgumentWriter.writeTable(map);
        methodArgumentWriter.flush();
        return new MethodArgumentReader(new ValueReader(new DataInputStream(new ByteArrayInputStream(this.primitiveCall(byteArrayOutputStream.toByteArray()))))).readTable();
    }

    public Map<String, Object> mapCall(Object[] objectArray) throws IOException, ShutdownSignalException, TimeoutException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            hashMap.put((String)objectArray[i2], objectArray[i2 + 1]);
        }
        return this.mapCall(hashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] primitiveCall(AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException, ShutdownSignalException, TimeoutException {
        AMQP.BasicProperties basicProperties2;
        this.checkConsumer();
        BlockingCell blockingCell = new BlockingCell();
        Map<String, BlockingCell<Object>> map = this._continuationMap;
        synchronized (map) {
            this._correlationId = 1 + this._correlationId;
            String string2 = "" + this._correlationId;
            AMQP.BasicProperties.Builder builder = basicProperties == null ? new AMQP.BasicProperties.Builder() : basicProperties.builder();
            basicProperties2 = builder.correlationId(string2).replyTo(this._replyQueue).build();
            this._continuationMap.put(string2, blockingCell);
        }
        this.publish(basicProperties2, byArray);
        Object t2 = blockingCell.uninterruptibleGet(this._timeout);
        if (t2 instanceof ShutdownSignalException) {
            ShutdownSignalException shutdownSignalException = (ShutdownSignalException)t2;
            ShutdownSignalException shutdownSignalException2 = new ShutdownSignalException(shutdownSignalException.isHardError(), shutdownSignalException.isInitiatedByApplication(), shutdownSignalException.getReason(), shutdownSignalException.getReference());
            shutdownSignalException2.initCause(shutdownSignalException);
            throw shutdownSignalException2;
        }
        return (byte[])t2;
    }

    public byte[] primitiveCall(byte[] byArray) throws IOException, ShutdownSignalException, TimeoutException {
        return this.primitiveCall(null, byArray);
    }

    public void publish(AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        this._channel.basicPublish(this._exchange, this._routingKey, basicProperties, byArray);
    }

    protected DefaultConsumer setupConsumer() throws IOException {
        DefaultConsumer defaultConsumer = new DefaultConsumer(this._channel){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleDelivery(String string2, Envelope envelope, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
                Map map = RpcClient.this._continuationMap;
                synchronized (map) {
                    String string3 = basicProperties.getCorrelationId();
                    BlockingCell blockingCell = (BlockingCell)RpcClient.this._continuationMap.get(string3);
                    RpcClient.this._continuationMap.remove(string3);
                    blockingCell.set(byArray);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleShutdownSignal(String string2, ShutdownSignalException shutdownSignalException) {
                Map map = RpcClient.this._continuationMap;
                synchronized (map) {
                    Iterator iterator = RpcClient.this._continuationMap.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            RpcClient.access$102(RpcClient.this, null);
                            return;
                        }
                        ((BlockingCell)iterator.next().getValue()).set(shutdownSignalException);
                    }
                }
            }
        };
        this._channel.basicConsume(this._replyQueue, true, defaultConsumer);
        return defaultConsumer;
    }

    protected String setupReplyQueue() throws IOException {
        return this._channel.queueDeclare("", false, true, true, null).getQueue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String stringCall(String string2) throws IOException, ShutdownSignalException, TimeoutException {
        byte[] byArray;
        try {
            byte[] byArray2 = string2.getBytes(StringRpcServer.STRING_ENCODING);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            byArray = string2.getBytes();
        }
        byte[] byArray3 = this.primitiveCall(byArray);
        try {
            return new String(byArray3, StringRpcServer.STRING_ENCODING);
        }
        catch (IOException iOException) {
            return new String(byArray3);
        }
    }
}

