/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.LongString;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.SaslMechanism;
import com.rabbitmq.client.impl.LongStringHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class JDKSaslConfig
implements SaslConfig {
    private static final String[] DEFAULT_PREFERRED_MECHANISMS = new String[]{"PLAIN"};
    private final CallbackHandler callbackHandler;
    private final ConnectionFactory factory;
    private final List<String> mechanisms;

    public JDKSaslConfig(ConnectionFactory connectionFactory) {
        this(connectionFactory, DEFAULT_PREFERRED_MECHANISMS);
    }

    public JDKSaslConfig(ConnectionFactory connectionFactory, String[] stringArray) {
        this.factory = connectionFactory;
        this.callbackHandler = new UsernamePasswordCallbackHandler(connectionFactory);
        this.mechanisms = Arrays.asList(stringArray);
    }

    @Override
    public SaslMechanism getSaslMechanism(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        for (String string2 : this.mechanisms) {
            SaslClient saslClient;
            if (!hashSet.contains(string2)) continue;
            try {
                saslClient = Sasl.createSaslClient(new String[]{string2}, null, "AMQP", this.factory.getHost(), null, this.callbackHandler);
                if (saslClient == null) continue;
            }
            catch (SaslException saslException) {
                throw new RuntimeException(saslException);
            }
            JDKSaslMechanism jDKSaslMechanism = new JDKSaslMechanism(saslClient);
            return jDKSaslMechanism;
        }
        return null;
    }

    private class JDKSaslMechanism
    implements SaslMechanism {
        private SaslClient client;

        public JDKSaslMechanism(SaslClient saslClient) {
            this.client = saslClient;
        }

        @Override
        public String getName() {
            return this.client.getMechanismName();
        }

        @Override
        public LongString handleChallenge(LongString longString, String string2, String string3) {
            try {
                LongString longString2 = LongStringHelper.asLongString(this.client.evaluateChallenge(longString.getBytes()));
                return longString2;
            }
            catch (SaslException saslException) {
                throw new RuntimeException(saslException);
            }
        }
    }

    private class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private ConnectionFactory factory;

        public UsernamePasswordCallbackHandler(ConnectionFactory connectionFactory) {
            this.factory = connectionFactory;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            int n2 = callbackArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Callback callback = callbackArray[n3];
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.factory.getUsername());
                } else {
                    if (!(callback instanceof PasswordCallback)) {
                        throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
                    }
                    ((PasswordCallback)callback).setPassword(this.factory.getPassword().toCharArray());
                }
                ++n3;
            }
            return;
        }
    }
}

