/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.DefaultSaslConfig;
import com.rabbitmq.client.NullTrustManager;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.SocketFrameHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ConnectionFactory
implements Cloneable {
    public static final int DEFAULT_AMQP_OVER_SSL_PORT = 5671;
    public static final int DEFAULT_AMQP_PORT = 5672;
    public static final int DEFAULT_CHANNEL_MAX = 0;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 0;
    public static final int DEFAULT_FRAME_MAX = 0;
    public static final int DEFAULT_HEARTBEAT = 0;
    public static final String DEFAULT_HOST = "localhost";
    @Deprecated
    public static final int DEFAULT_NUM_CONSUMER_THREADS = 5;
    public static final String DEFAULT_PASS = "guest";
    private static final String DEFAULT_SSL_PROTOCOL = "SSLv3";
    public static final String DEFAULT_USER = "guest";
    public static final String DEFAULT_VHOST = "/";
    public static final int USE_DEFAULT_PORT = -1;
    private Map<String, Object> _clientProperties = AMQConnection.defaultClientProperties();
    private int connectionTimeout = 0;
    private SocketFactory factory = SocketFactory.getDefault();
    private String host = "localhost";
    private String password = "guest";
    private int port = -1;
    private int requestedChannelMax = 0;
    private int requestedFrameMax = 0;
    private int requestedHeartbeat = 0;
    private SaslConfig saslConfig = DefaultSaslConfig.PLAIN;
    private String username = "guest";
    private String virtualHost = "/";

    private int portOrDefault(int n2) {
        if (n2 != -1) {
            return n2;
        }
        if (this.isSSL()) {
            return 5671;
        }
        return 5672;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void quietTrySocketClose(Socket socket) {
        if (socket == null) return;
        try {
            socket.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private String uriDecode(String string2) {
        try {
            String string3 = URLDecoder.decode(string2.replace("+", "%2B"), "US-ASCII");
            return string3;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public ConnectionFactory clone() {
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)super.clone();
            return connectionFactory;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }

    protected void configureSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(true);
    }

    protected FrameHandler createFrameHandler(Address address) throws IOException {
        String string2 = address.getHost();
        int n2 = this.portOrDefault(address.getPort());
        Socket socket = null;
        try {
            socket = this.factory.createSocket();
            this.configureSocket(socket);
            socket.connect(new InetSocketAddress(string2, n2), this.connectionTimeout);
            FrameHandler frameHandler = this.createFrameHandler(socket);
            return frameHandler;
        }
        catch (IOException iOException) {
            ConnectionFactory.quietTrySocketClose(socket);
            throw iOException;
        }
    }

    protected FrameHandler createFrameHandler(Socket socket) throws IOException {
        return new SocketFrameHandler(socket);
    }

    public Map<String, Object> getClientProperties() {
        return this._clientProperties;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getHost() {
        return this.host;
    }

    @Deprecated
    public int getNumConsumerThreads() {
        return 5;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.portOrDefault(this.port);
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public int getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public SaslConfig getSaslConfig() {
        return this.saslConfig;
    }

    public SocketFactory getSocketFactory() {
        return this.factory;
    }

    public String getUsername() {
        return this.username;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public boolean isSSL() {
        return this.getSocketFactory() instanceof SSLSocketFactory;
    }

    public Connection newConnection() throws IOException {
        Address[] addressArray = new Address[]{new Address(this.getHost(), this.getPort())};
        return this.newConnection(null, addressArray);
    }

    public Connection newConnection(ExecutorService executorService) throws IOException {
        Address[] addressArray = new Address[]{new Address(this.getHost(), this.getPort())};
        return this.newConnection(executorService, addressArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection newConnection(ExecutorService executorService, Address[] addressArray) throws IOException {
        IOException iOException = null;
        for (Address address : addressArray) {
            try {
                FrameHandler frameHandler = this.createFrameHandler(address);
                AMQConnection aMQConnection = new AMQConnection(this.username, this.password, frameHandler, executorService, this.virtualHost, this.getClientProperties(), this.requestedFrameMax, this.requestedChannelMax, this.requestedHeartbeat, this.saslConfig);
                aMQConnection.start();
                return aMQConnection;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        iOException = new IOException("failed to connect");
        throw iOException;
    }

    public Connection newConnection(Address[] addressArray) throws IOException {
        return this.newConnection(null, addressArray);
    }

    public void setClientProperties(Map<String, Object> map) {
        this._clientProperties = map;
    }

    public void setConnectionTimeout(int n2) {
        this.connectionTimeout = n2;
    }

    public void setHost(String string2) {
        this.host = string2;
    }

    @Deprecated
    public void setNumConsumerThreads(int n2) {
        throw new IllegalArgumentException("setNumConsumerThreads not supported -- create explicit ExecutorService instead.");
    }

    public void setPassword(String string2) {
        this.password = string2;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public void setRequestedChannelMax(int n2) {
        this.requestedChannelMax = n2;
    }

    public void setRequestedFrameMax(int n2) {
        this.requestedFrameMax = n2;
    }

    public void setRequestedHeartbeat(int n2) {
        this.requestedHeartbeat = n2;
    }

    public void setSaslConfig(SaslConfig saslConfig) {
        this.saslConfig = saslConfig;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.factory = socketFactory;
    }

    public void setUri(String string2) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        this.setUri(new URI(string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setUri(URI uRI) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        String string2;
        String string3;
        int n2;
        String string4;
        if (!"amqp".equals(uRI.getScheme().toLowerCase())) {
            if (!"amqps".equals(uRI.getScheme().toLowerCase())) {
                throw new IllegalArgumentException("Wrong scheme in AMQP URI: " + uRI.getScheme());
            }
            this.setPort(5671);
            this.useSslProtocol();
        }
        if ((string4 = uRI.getHost()) != null) {
            this.setHost(string4);
        }
        if ((n2 = uRI.getPort()) != -1) {
            this.setPort(n2);
        }
        if ((string3 = uRI.getRawUserInfo()) != null) {
            String[] stringArray = string3.split(":");
            if (stringArray.length > 2) {
                throw new IllegalArgumentException("Bad user info in AMQP URI: " + string3);
            }
            this.setUsername(this.uriDecode(stringArray[0]));
            if (stringArray.length == 2) {
                this.setPassword(this.uriDecode(stringArray[1]));
            }
        }
        if ((string2 = uRI.getRawPath()) != null && string2.length() > 0) {
            if (string2.indexOf(47, 1) != -1) {
                throw new IllegalArgumentException("Multiple segments in path of AMQP URI: " + string2);
            }
            this.setVirtualHost(this.uriDecode(uRI.getPath().substring(1)));
        }
    }

    public void setUsername(String string2) {
        this.username = string2;
    }

    public void setVirtualHost(String string2) {
        this.virtualHost = string2;
    }

    public void useSslProtocol() throws NoSuchAlgorithmException, KeyManagementException {
        this.useSslProtocol(DEFAULT_SSL_PROTOCOL);
    }

    public void useSslProtocol(String string2) throws NoSuchAlgorithmException, KeyManagementException {
        this.useSslProtocol(string2, new NullTrustManager());
    }

    public void useSslProtocol(String string2, TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sSLContext = SSLContext.getInstance(string2);
        sSLContext.init(null, new TrustManager[]{trustManager}, null);
        this.useSslProtocol(sSLContext);
    }

    public void useSslProtocol(SSLContext sSLContext) {
        this.setSocketFactory(sSLContext.getSocketFactory());
    }
}

